/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.process.computer;

import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.tinkerpop.gremlin.process.computer.MessageCombiner;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.Messenger;
import org.apache.tinkerpop.gremlin.process.computer.util.VertexProgramHelper;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.tinkergraph.process.computer.TinkerMessageBoard;
import org.apache.tinkerpop.gremlin.util.iterator.MultiIterator;

public final class TinkerMessenger<M>
implements Messenger<M> {
    private final Vertex vertex;
    private final TinkerMessageBoard<M> messageBoard;
    private final MessageCombiner<M> combiner;

    public TinkerMessenger(Vertex vertex, TinkerMessageBoard<M> messageBoard, Optional<MessageCombiner<M>> combiner) {
        this.vertex = vertex;
        this.messageBoard = messageBoard;
        this.combiner = combiner.isPresent() ? combiner.get() : null;
    }

    public Iterator<M> receiveMessages() {
        MultiIterator multiIterator = new MultiIterator();
        for (MessageScope messageScope : this.messageBoard.receiveMessages.keySet()) {
            if (messageScope instanceof MessageScope.Local) {
                MessageScope.Local localMessageScope = (MessageScope.Local)messageScope;
                Object incidentTraversal = TinkerMessenger.setVertexStart((Traversal.Admin<Vertex, Edge>)((Traversal)localMessageScope.getIncidentTraversal().get()).asAdmin(), this.vertex);
                Direction direction = TinkerMessenger.getDirection(incidentTraversal);
                Edge[] edge = new Edge[1];
                multiIterator.addIterator(StreamSupport.stream(Spliterators.spliteratorUnknownSize(VertexProgramHelper.reverse((Traversal.Admin)incidentTraversal.asAdmin()), 1088), false).map(e -> {
                    edge[0] = e;
                    Vertex vv = direction.equals((Object)Direction.IN) || direction.equals((Object)Direction.OUT) ? (Vertex)e.vertices(direction).next() : (e.outVertex() == this.vertex ? e.inVertex() : e.outVertex());
                    return this.messageBoard.receiveMessages.get(messageScope).get(vv);
                }).filter(q -> null != q).flatMap(Collection::stream).map(message -> localMessageScope.getEdgeFunction().apply(message, edge[0])).iterator());
                continue;
            }
            multiIterator.addIterator(Stream.of(this.vertex).map(this.messageBoard.receiveMessages.get(messageScope)::get).filter(q -> null != q).flatMap(Collection::stream).iterator());
        }
        return multiIterator;
    }

    public void sendMessage(MessageScope messageScope, M message) {
        if (messageScope instanceof MessageScope.Local) {
            this.addMessage(this.vertex, message, messageScope);
        } else {
            ((MessageScope.Global)messageScope).vertices().forEach(v -> this.addMessage((Vertex)v, message, messageScope));
        }
    }

    private void addMessage(Vertex vertex, M message, MessageScope messageScope) {
        this.messageBoard.sendMessages.compute(messageScope, (ms, messages) -> {
            if (null == messages) {
                messages = new ConcurrentHashMap();
            }
            return messages;
        });
        this.messageBoard.sendMessages.get(messageScope).compute(vertex, (v, queue) -> {
            if (null == queue) {
                queue = new ConcurrentLinkedQueue<Object>();
            }
            queue.add(null != this.combiner && !queue.isEmpty() ? this.combiner.combine(queue.remove(), message) : message);
            return queue;
        });
    }

    private static <T extends Traversal.Admin<Vertex, Edge>> T setVertexStart(Traversal.Admin<Vertex, Edge> incidentTraversal, Vertex vertex) {
        incidentTraversal.addStart(incidentTraversal.getTraverserGenerator().generate((Object)vertex, incidentTraversal.getStartStep(), 1L));
        return (T)incidentTraversal;
    }

    private static Direction getDirection(Traversal.Admin<Vertex, Edge> incidentTraversal) {
        VertexStep step = (VertexStep)TraversalHelper.getLastStepOfAssignableClass(VertexStep.class, incidentTraversal).get();
        return step.getDirection();
    }
}

