/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource.loader;

import java.util.Locale;
import org.apache.wicket.core.util.resource.locator.IResourceNameIterator;
import org.apache.wicket.resource.IPropertiesFactory;
import org.apache.wicket.resource.Properties;
import org.apache.wicket.resource.loader.ComponentStringResourceLoader;
import org.apache.wicket.util.string.Strings;

public class PackageStringResourceLoader
extends ComponentStringResourceLoader {
    private String filename = "wicket-package";

    @Override
    public String loadStringResource(Class<?> clazz, String key, Locale locale, String style, String variation) {
        if (clazz == null) {
            return null;
        }
        IPropertiesFactory propertiesFactory = this.getPropertiesFactory();
        do {
            Package pkg;
            String packageName = (pkg = clazz.getPackage()) == null ? "" : pkg.getName();
            packageName = packageName.replace('.', '/');
            do {
                Object path = this.filename;
                if (packageName.length() > 0) {
                    path = packageName + "/" + (String)path;
                }
                IResourceNameIterator iter = this.newResourceNameIterator((String)path, locale, style, variation);
                while (iter.hasNext()) {
                    String value;
                    String newPath = (String)iter.next();
                    Properties props = propertiesFactory.load(clazz, newPath);
                    if (props == null || (value = props.getString(key)) == null) continue;
                    return value;
                }
            } while ((packageName = Strings.beforeLast(packageName, '/')).length() > 0);
        } while ((clazz = clazz.getSuperclass()) != null);
        return null;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }
}

