/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.activemq.network;

import org.apache.activemq.transport.Transport;
import org.mockito.Mockito;

public class CustomNetworkBridgeFactory implements BridgeFactory { 

    private final NetworkBridgeListener listener;

    public CustomNetworkBridgeFactory() {
        this(Mockito.mock(NetworkBridgeListener.class));
    }

    public CustomNetworkBridgeFactory(NetworkBridgeListener listener) {
        this.listener = listener;
    }

    public NetworkBridgeListener getListener() {
        return listener;
    }

    @Override
    public DemandForwardingBridge createNetworkBridge(NetworkBridgeConfiguration configuration, Transport localTransport, Transport remoteTransport, NetworkBridgeListener listener) {
        DemandForwardingBridge bridge = new DemandForwardingBridge(configuration, localTransport, remoteTransport);
        bridge.setNetworkBridgeListener(new CompositeNetworkBridgeListener(this.listener, listener));
        return bridge;
    }

 }
