/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.util;

import java.io.Closeable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class SimpleLockManager {
    private final ConcurrentHashMap<String, Locked> _locks = new ConcurrentHashMap();

    public Locked lock(String lockKey) {
        try {
            return this.tryLock(lockKey, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (LockFailedException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public Locked tryLock(String lockKey, long time, TimeUnit timeunit) throws InterruptedException, LockFailedException {
        LockedImpl newLock = new LockedImpl(lockKey);
        long timeoutNanos = timeunit.toNanos(time);
        long startAt = System.nanoTime();
        Locked previous;
        while ((previous = this._locks.putIfAbsent(lockKey, newLock)) != null) {
            if (System.nanoTime() - startAt >= timeoutNanos) {
                throw new LockFailedException();
            }
            Thread.sleep(10L);
        }
        return newLock;
    }

    public static class LockFailedException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    public static abstract class Locked
    implements Closeable {
        @Override
        public abstract void close();
    }

    private class LockedImpl
    extends Locked {
        private final String id;

        private LockedImpl(String id) {
            this.id = id;
        }

        @Override
        public void close() {
            SimpleLockManager.this._locks.remove(this.id);
        }
    }
}

