/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Get, set, delete or watch keys in etcd key-value store.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface Etcd3EndpointBuilderFactory {

    /**
     * Builder for endpoint consumers for the Etcd v3 component.
     */
    public interface Etcd3EndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedEtcd3EndpointConsumerBuilder advanced() {
            return (AdvancedEtcd3EndpointConsumerBuilder) this;
        }
        /**
         * Configure etcd server endpoints using the IPNameResolver. Multiple
         * endpoints can be separated by comma.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: http://localhost:2379
         * Group: common
         * 
         * @param endpoints the value to set
         * @return the dsl builder
         */
        default Etcd3EndpointConsumerBuilder endpoints(String endpoints) {
            doSetProperty("endpoints", endpoints);
            return this;
        }
        /**
         * Configure the charset to use for the keys.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: UTF-8
         * Group: common
         * 
         * @param keyCharset the value to set
         * @return the dsl builder
         */
        default Etcd3EndpointConsumerBuilder keyCharset(String keyCharset) {
            doSetProperty("keyCharset", keyCharset);
            return this;
        }
        /**
         * Configure the namespace of keys used. / will be treated as no
         * namespace.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param namespace the value to set
         * @return the dsl builder
         */
        default Etcd3EndpointConsumerBuilder namespace(String namespace) {
            doSetProperty("namespace", namespace);
            return this;
        }
        /**
         * To apply an action on all the key-value pairs whose key that starts
         * with the target path.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param prefix the value to set
         * @return the dsl builder
         */
        default Etcd3EndpointConsumerBuilder prefix(boolean prefix) {
            doSetProperty("prefix", prefix);
            return this;
        }
        /**
         * To apply an action on all the key-value pairs whose key that starts
         * with the target path.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param prefix the value to set
         * @return the dsl builder
         */
        default Etcd3EndpointConsumerBuilder prefix(String prefix) {
            doSetProperty("prefix", prefix);
            return this;
        }
        /**
         * The path to look for service discovery.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: /services/
         * Group: cloud
         * 
         * @param servicePath the value to set
         * @return the dsl builder
         */
        default Etcd3EndpointConsumerBuilder servicePath(String servicePath) {
            doSetProperty("servicePath", servicePath);
            return this;
        }
        /**
         * Configure etcd auth password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default Etcd3EndpointConsumerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Configure etcd auth user.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param userName the value to set
         * @return the dsl builder
         */
        default Etcd3EndpointConsumerBuilder userName(String userName) {
            doSetProperty("userName", userName);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Etcd v3 component.
     */
    public interface AdvancedEtcd3EndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default Etcd3EndpointConsumerBuilder basic() {
            return (Etcd3EndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointConsumerBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointConsumerBuilder bridgeErrorHandler(String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointConsumerBuilder exceptionHandler(org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointConsumerBuilder exceptionHandler(String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointConsumerBuilder exchangePattern(org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointConsumerBuilder exchangePattern(String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * The index to watch from.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 0
         * Group: consumer (advanced)
         * 
         * @param fromIndex the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointConsumerBuilder fromIndex(long fromIndex) {
            doSetProperty("fromIndex", fromIndex);
            return this;
        }
        /**
         * The index to watch from.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 0
         * Group: consumer (advanced)
         * 
         * @param fromIndex the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointConsumerBuilder fromIndex(String fromIndex) {
            doSetProperty("fromIndex", fromIndex);
            return this;
        }
        /**
         * Configure the headers to be added to auth request headers.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.String&gt;</code> type.
         * The option is multivalued, and you can use the authHeaders(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointConsumerBuilder authHeaders(String key, Object value) {
            doSetMultiValueProperty("authHeaders", "authHeaders." + key, value);
            return this;
        }
        /**
         * Configure the headers to be added to auth request headers.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.String&gt;</code> type.
         * The option is multivalued, and you can use the authHeaders(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointConsumerBuilder authHeaders(Map values) {
            doSetMultiValueProperties("authHeaders", "authHeaders.", values);
            return this;
        }
        /**
         * Configure the authority used to authenticate connections to servers.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         * 
         * @param authority the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointConsumerBuilder authority(String authority) {
            doSetProperty("authority", authority);
            return this;
        }
        /**
         * Configure the connection timeout.
         * 
         * The option is a: <code>java.time.Duration</code> type.
         * 
         * Group: advanced
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointConsumerBuilder connectionTimeout(java.time.Duration connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Configure the connection timeout.
         * 
         * The option will be converted to a <code>java.time.Duration</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointConsumerBuilder connectionTimeout(String connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Configure the headers to be added to http request headers.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.String&gt;</code> type.
         * The option is multivalued, and you can use the headers(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointConsumerBuilder headers(String key, Object value) {
            doSetMultiValueProperty("headers", "headers." + key, value);
            return this;
        }
        /**
         * Configure the headers to be added to http request headers.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.String&gt;</code> type.
         * The option is multivalued, and you can use the headers(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointConsumerBuilder headers(Map values) {
            doSetMultiValueProperties("headers", "headers.", values);
            return this;
        }
        /**
         * Configure the interval for gRPC keepalives. The current minimum
         * allowed by gRPC is 10 seconds.
         * 
         * The option is a: <code>java.time.Duration</code> type.
         * 
         * Default: 30 seconds
         * Group: advanced
         * 
         * @param keepAliveTime the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointConsumerBuilder keepAliveTime(java.time.Duration keepAliveTime) {
            doSetProperty("keepAliveTime", keepAliveTime);
            return this;
        }
        /**
         * Configure the interval for gRPC keepalives. The current minimum
         * allowed by gRPC is 10 seconds.
         * 
         * The option will be converted to a <code>java.time.Duration</code>
         * type.
         * 
         * Default: 30 seconds
         * Group: advanced
         * 
         * @param keepAliveTime the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointConsumerBuilder keepAliveTime(String keepAliveTime) {
            doSetProperty("keepAliveTime", keepAliveTime);
            return this;
        }
        /**
         * Configure the timeout for gRPC keepalives.
         * 
         * The option is a: <code>java.time.Duration</code> type.
         * 
         * Default: 10 seconds
         * Group: advanced
         * 
         * @param keepAliveTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointConsumerBuilder keepAliveTimeout(java.time.Duration keepAliveTimeout) {
            doSetProperty("keepAliveTimeout", keepAliveTimeout);
            return this;
        }
        /**
         * Configure the timeout for gRPC keepalives.
         * 
         * The option will be converted to a <code>java.time.Duration</code>
         * type.
         * 
         * Default: 10 seconds
         * Group: advanced
         * 
         * @param keepAliveTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointConsumerBuilder keepAliveTimeout(String keepAliveTimeout) {
            doSetProperty("keepAliveTimeout", keepAliveTimeout);
            return this;
        }
        /**
         * Configure etcd load balancer policy.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         * 
         * @param loadBalancerPolicy the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointConsumerBuilder loadBalancerPolicy(String loadBalancerPolicy) {
            doSetProperty("loadBalancerPolicy", loadBalancerPolicy);
            return this;
        }
        /**
         * Configure the maximum message size allowed for a single gRPC frame.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: advanced
         * 
         * @param maxInboundMessageSize the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointConsumerBuilder maxInboundMessageSize(Integer maxInboundMessageSize) {
            doSetProperty("maxInboundMessageSize", maxInboundMessageSize);
            return this;
        }
        /**
         * Configure the maximum message size allowed for a single gRPC frame.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param maxInboundMessageSize the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointConsumerBuilder maxInboundMessageSize(String maxInboundMessageSize) {
            doSetProperty("maxInboundMessageSize", maxInboundMessageSize);
            return this;
        }
        /**
         * Configure the delay between retries in milliseconds.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 500
         * Group: advanced
         * 
         * @param retryDelay the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointConsumerBuilder retryDelay(long retryDelay) {
            doSetProperty("retryDelay", retryDelay);
            return this;
        }
        /**
         * Configure the delay between retries in milliseconds.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 500
         * Group: advanced
         * 
         * @param retryDelay the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointConsumerBuilder retryDelay(String retryDelay) {
            doSetProperty("retryDelay", retryDelay);
            return this;
        }
        /**
         * Configure the max backing off delay between retries in milliseconds.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 2500
         * Group: advanced
         * 
         * @param retryMaxDelay the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointConsumerBuilder retryMaxDelay(long retryMaxDelay) {
            doSetProperty("retryMaxDelay", retryMaxDelay);
            return this;
        }
        /**
         * Configure the max backing off delay between retries in milliseconds.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 2500
         * Group: advanced
         * 
         * @param retryMaxDelay the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointConsumerBuilder retryMaxDelay(String retryMaxDelay) {
            doSetProperty("retryMaxDelay", retryMaxDelay);
            return this;
        }
        /**
         * Configure the retries max duration.
         * 
         * The option is a: <code>java.time.Duration</code> type.
         * 
         * Group: advanced
         * 
         * @param retryMaxDuration the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointConsumerBuilder retryMaxDuration(java.time.Duration retryMaxDuration) {
            doSetProperty("retryMaxDuration", retryMaxDuration);
            return this;
        }
        /**
         * Configure the retries max duration.
         * 
         * The option will be converted to a <code>java.time.Duration</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param retryMaxDuration the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointConsumerBuilder retryMaxDuration(String retryMaxDuration) {
            doSetProperty("retryMaxDuration", retryMaxDuration);
            return this;
        }
        /**
         * Configure SSL/TLS context to use instead of the system default.
         * 
         * The option is a: <code>io.netty.handler.ssl.SslContext</code> type.
         * 
         * Group: security
         * 
         * @param sslContext the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointConsumerBuilder sslContext(io.netty.handler.ssl.SslContext sslContext) {
            doSetProperty("sslContext", sslContext);
            return this;
        }
        /**
         * Configure SSL/TLS context to use instead of the system default.
         * 
         * The option will be converted to a
         * <code>io.netty.handler.ssl.SslContext</code> type.
         * 
         * Group: security
         * 
         * @param sslContext the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointConsumerBuilder sslContext(String sslContext) {
            doSetProperty("sslContext", sslContext);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Etcd v3 component.
     */
    public interface Etcd3EndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedEtcd3EndpointProducerBuilder advanced() {
            return (AdvancedEtcd3EndpointProducerBuilder) this;
        }

        /**
         * Configure etcd server endpoints using the IPNameResolver. Multiple
         * endpoints can be separated by comma.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: http://localhost:2379
         * Group: common
         * 
         * @param endpoints the value to set
         * @return the dsl builder
         */
        default Etcd3EndpointProducerBuilder endpoints(String endpoints) {
            doSetProperty("endpoints", endpoints);
            return this;
        }
        /**
         * Configure the charset to use for the keys.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: UTF-8
         * Group: common
         * 
         * @param keyCharset the value to set
         * @return the dsl builder
         */
        default Etcd3EndpointProducerBuilder keyCharset(String keyCharset) {
            doSetProperty("keyCharset", keyCharset);
            return this;
        }
        /**
         * Configure the namespace of keys used. / will be treated as no
         * namespace.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param namespace the value to set
         * @return the dsl builder
         */
        default Etcd3EndpointProducerBuilder namespace(String namespace) {
            doSetProperty("namespace", namespace);
            return this;
        }
        /**
         * To apply an action on all the key-value pairs whose key that starts
         * with the target path.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param prefix the value to set
         * @return the dsl builder
         */
        default Etcd3EndpointProducerBuilder prefix(boolean prefix) {
            doSetProperty("prefix", prefix);
            return this;
        }
        /**
         * To apply an action on all the key-value pairs whose key that starts
         * with the target path.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param prefix the value to set
         * @return the dsl builder
         */
        default Etcd3EndpointProducerBuilder prefix(String prefix) {
            doSetProperty("prefix", prefix);
            return this;
        }
        /**
         * Configure the charset to use for the values.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: UTF-8
         * Group: producer
         * 
         * @param valueCharset the value to set
         * @return the dsl builder
         */
        default Etcd3EndpointProducerBuilder valueCharset(String valueCharset) {
            doSetProperty("valueCharset", valueCharset);
            return this;
        }
        /**
         * The path to look for service discovery.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: /services/
         * Group: cloud
         * 
         * @param servicePath the value to set
         * @return the dsl builder
         */
        default Etcd3EndpointProducerBuilder servicePath(String servicePath) {
            doSetProperty("servicePath", servicePath);
            return this;
        }
        /**
         * Configure etcd auth password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default Etcd3EndpointProducerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Configure etcd auth user.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param userName the value to set
         * @return the dsl builder
         */
        default Etcd3EndpointProducerBuilder userName(String userName) {
            doSetProperty("userName", userName);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Etcd v3 component.
     */
    public interface AdvancedEtcd3EndpointProducerBuilder extends EndpointProducerBuilder {
        default Etcd3EndpointProducerBuilder basic() {
            return (Etcd3EndpointProducerBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointProducerBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointProducerBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Configure the headers to be added to auth request headers.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.String&gt;</code> type.
         * The option is multivalued, and you can use the authHeaders(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointProducerBuilder authHeaders(String key, Object value) {
            doSetMultiValueProperty("authHeaders", "authHeaders." + key, value);
            return this;
        }
        /**
         * Configure the headers to be added to auth request headers.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.String&gt;</code> type.
         * The option is multivalued, and you can use the authHeaders(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointProducerBuilder authHeaders(Map values) {
            doSetMultiValueProperties("authHeaders", "authHeaders.", values);
            return this;
        }
        /**
         * Configure the authority used to authenticate connections to servers.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         * 
         * @param authority the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointProducerBuilder authority(String authority) {
            doSetProperty("authority", authority);
            return this;
        }
        /**
         * Configure the connection timeout.
         * 
         * The option is a: <code>java.time.Duration</code> type.
         * 
         * Group: advanced
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointProducerBuilder connectionTimeout(java.time.Duration connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Configure the connection timeout.
         * 
         * The option will be converted to a <code>java.time.Duration</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointProducerBuilder connectionTimeout(String connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Configure the headers to be added to http request headers.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.String&gt;</code> type.
         * The option is multivalued, and you can use the headers(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointProducerBuilder headers(String key, Object value) {
            doSetMultiValueProperty("headers", "headers." + key, value);
            return this;
        }
        /**
         * Configure the headers to be added to http request headers.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.String&gt;</code> type.
         * The option is multivalued, and you can use the headers(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointProducerBuilder headers(Map values) {
            doSetMultiValueProperties("headers", "headers.", values);
            return this;
        }
        /**
         * Configure the interval for gRPC keepalives. The current minimum
         * allowed by gRPC is 10 seconds.
         * 
         * The option is a: <code>java.time.Duration</code> type.
         * 
         * Default: 30 seconds
         * Group: advanced
         * 
         * @param keepAliveTime the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointProducerBuilder keepAliveTime(java.time.Duration keepAliveTime) {
            doSetProperty("keepAliveTime", keepAliveTime);
            return this;
        }
        /**
         * Configure the interval for gRPC keepalives. The current minimum
         * allowed by gRPC is 10 seconds.
         * 
         * The option will be converted to a <code>java.time.Duration</code>
         * type.
         * 
         * Default: 30 seconds
         * Group: advanced
         * 
         * @param keepAliveTime the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointProducerBuilder keepAliveTime(String keepAliveTime) {
            doSetProperty("keepAliveTime", keepAliveTime);
            return this;
        }
        /**
         * Configure the timeout for gRPC keepalives.
         * 
         * The option is a: <code>java.time.Duration</code> type.
         * 
         * Default: 10 seconds
         * Group: advanced
         * 
         * @param keepAliveTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointProducerBuilder keepAliveTimeout(java.time.Duration keepAliveTimeout) {
            doSetProperty("keepAliveTimeout", keepAliveTimeout);
            return this;
        }
        /**
         * Configure the timeout for gRPC keepalives.
         * 
         * The option will be converted to a <code>java.time.Duration</code>
         * type.
         * 
         * Default: 10 seconds
         * Group: advanced
         * 
         * @param keepAliveTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointProducerBuilder keepAliveTimeout(String keepAliveTimeout) {
            doSetProperty("keepAliveTimeout", keepAliveTimeout);
            return this;
        }
        /**
         * Configure etcd load balancer policy.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         * 
         * @param loadBalancerPolicy the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointProducerBuilder loadBalancerPolicy(String loadBalancerPolicy) {
            doSetProperty("loadBalancerPolicy", loadBalancerPolicy);
            return this;
        }
        /**
         * Configure the maximum message size allowed for a single gRPC frame.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: advanced
         * 
         * @param maxInboundMessageSize the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointProducerBuilder maxInboundMessageSize(Integer maxInboundMessageSize) {
            doSetProperty("maxInboundMessageSize", maxInboundMessageSize);
            return this;
        }
        /**
         * Configure the maximum message size allowed for a single gRPC frame.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param maxInboundMessageSize the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointProducerBuilder maxInboundMessageSize(String maxInboundMessageSize) {
            doSetProperty("maxInboundMessageSize", maxInboundMessageSize);
            return this;
        }
        /**
         * Configure the delay between retries in milliseconds.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 500
         * Group: advanced
         * 
         * @param retryDelay the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointProducerBuilder retryDelay(long retryDelay) {
            doSetProperty("retryDelay", retryDelay);
            return this;
        }
        /**
         * Configure the delay between retries in milliseconds.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 500
         * Group: advanced
         * 
         * @param retryDelay the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointProducerBuilder retryDelay(String retryDelay) {
            doSetProperty("retryDelay", retryDelay);
            return this;
        }
        /**
         * Configure the max backing off delay between retries in milliseconds.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 2500
         * Group: advanced
         * 
         * @param retryMaxDelay the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointProducerBuilder retryMaxDelay(long retryMaxDelay) {
            doSetProperty("retryMaxDelay", retryMaxDelay);
            return this;
        }
        /**
         * Configure the max backing off delay between retries in milliseconds.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 2500
         * Group: advanced
         * 
         * @param retryMaxDelay the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointProducerBuilder retryMaxDelay(String retryMaxDelay) {
            doSetProperty("retryMaxDelay", retryMaxDelay);
            return this;
        }
        /**
         * Configure the retries max duration.
         * 
         * The option is a: <code>java.time.Duration</code> type.
         * 
         * Group: advanced
         * 
         * @param retryMaxDuration the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointProducerBuilder retryMaxDuration(java.time.Duration retryMaxDuration) {
            doSetProperty("retryMaxDuration", retryMaxDuration);
            return this;
        }
        /**
         * Configure the retries max duration.
         * 
         * The option will be converted to a <code>java.time.Duration</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param retryMaxDuration the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointProducerBuilder retryMaxDuration(String retryMaxDuration) {
            doSetProperty("retryMaxDuration", retryMaxDuration);
            return this;
        }
        /**
         * Configure SSL/TLS context to use instead of the system default.
         * 
         * The option is a: <code>io.netty.handler.ssl.SslContext</code> type.
         * 
         * Group: security
         * 
         * @param sslContext the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointProducerBuilder sslContext(io.netty.handler.ssl.SslContext sslContext) {
            doSetProperty("sslContext", sslContext);
            return this;
        }
        /**
         * Configure SSL/TLS context to use instead of the system default.
         * 
         * The option will be converted to a
         * <code>io.netty.handler.ssl.SslContext</code> type.
         * 
         * Group: security
         * 
         * @param sslContext the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointProducerBuilder sslContext(String sslContext) {
            doSetProperty("sslContext", sslContext);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Etcd v3 component.
     */
    public interface Etcd3EndpointBuilder
            extends
                Etcd3EndpointConsumerBuilder,
                Etcd3EndpointProducerBuilder {
        default AdvancedEtcd3EndpointBuilder advanced() {
            return (AdvancedEtcd3EndpointBuilder) this;
        }

        /**
         * Configure etcd server endpoints using the IPNameResolver. Multiple
         * endpoints can be separated by comma.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: http://localhost:2379
         * Group: common
         * 
         * @param endpoints the value to set
         * @return the dsl builder
         */
        default Etcd3EndpointBuilder endpoints(String endpoints) {
            doSetProperty("endpoints", endpoints);
            return this;
        }
        /**
         * Configure the charset to use for the keys.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: UTF-8
         * Group: common
         * 
         * @param keyCharset the value to set
         * @return the dsl builder
         */
        default Etcd3EndpointBuilder keyCharset(String keyCharset) {
            doSetProperty("keyCharset", keyCharset);
            return this;
        }
        /**
         * Configure the namespace of keys used. / will be treated as no
         * namespace.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param namespace the value to set
         * @return the dsl builder
         */
        default Etcd3EndpointBuilder namespace(String namespace) {
            doSetProperty("namespace", namespace);
            return this;
        }
        /**
         * To apply an action on all the key-value pairs whose key that starts
         * with the target path.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param prefix the value to set
         * @return the dsl builder
         */
        default Etcd3EndpointBuilder prefix(boolean prefix) {
            doSetProperty("prefix", prefix);
            return this;
        }
        /**
         * To apply an action on all the key-value pairs whose key that starts
         * with the target path.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param prefix the value to set
         * @return the dsl builder
         */
        default Etcd3EndpointBuilder prefix(String prefix) {
            doSetProperty("prefix", prefix);
            return this;
        }
        /**
         * The path to look for service discovery.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: /services/
         * Group: cloud
         * 
         * @param servicePath the value to set
         * @return the dsl builder
         */
        default Etcd3EndpointBuilder servicePath(String servicePath) {
            doSetProperty("servicePath", servicePath);
            return this;
        }
        /**
         * Configure etcd auth password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default Etcd3EndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Configure etcd auth user.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param userName the value to set
         * @return the dsl builder
         */
        default Etcd3EndpointBuilder userName(String userName) {
            doSetProperty("userName", userName);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Etcd v3 component.
     */
    public interface AdvancedEtcd3EndpointBuilder
            extends
                AdvancedEtcd3EndpointConsumerBuilder,
                AdvancedEtcd3EndpointProducerBuilder {
        default Etcd3EndpointBuilder basic() {
            return (Etcd3EndpointBuilder) this;
        }

        /**
         * Configure the headers to be added to auth request headers.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.String&gt;</code> type.
         * The option is multivalued, and you can use the authHeaders(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointBuilder authHeaders(String key, Object value) {
            doSetMultiValueProperty("authHeaders", "authHeaders." + key, value);
            return this;
        }
        /**
         * Configure the headers to be added to auth request headers.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.String&gt;</code> type.
         * The option is multivalued, and you can use the authHeaders(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointBuilder authHeaders(Map values) {
            doSetMultiValueProperties("authHeaders", "authHeaders.", values);
            return this;
        }
        /**
         * Configure the authority used to authenticate connections to servers.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         * 
         * @param authority the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointBuilder authority(String authority) {
            doSetProperty("authority", authority);
            return this;
        }
        /**
         * Configure the connection timeout.
         * 
         * The option is a: <code>java.time.Duration</code> type.
         * 
         * Group: advanced
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointBuilder connectionTimeout(java.time.Duration connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Configure the connection timeout.
         * 
         * The option will be converted to a <code>java.time.Duration</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointBuilder connectionTimeout(String connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Configure the headers to be added to http request headers.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.String&gt;</code> type.
         * The option is multivalued, and you can use the headers(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointBuilder headers(String key, Object value) {
            doSetMultiValueProperty("headers", "headers." + key, value);
            return this;
        }
        /**
         * Configure the headers to be added to http request headers.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.String&gt;</code> type.
         * The option is multivalued, and you can use the headers(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointBuilder headers(Map values) {
            doSetMultiValueProperties("headers", "headers.", values);
            return this;
        }
        /**
         * Configure the interval for gRPC keepalives. The current minimum
         * allowed by gRPC is 10 seconds.
         * 
         * The option is a: <code>java.time.Duration</code> type.
         * 
         * Default: 30 seconds
         * Group: advanced
         * 
         * @param keepAliveTime the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointBuilder keepAliveTime(java.time.Duration keepAliveTime) {
            doSetProperty("keepAliveTime", keepAliveTime);
            return this;
        }
        /**
         * Configure the interval for gRPC keepalives. The current minimum
         * allowed by gRPC is 10 seconds.
         * 
         * The option will be converted to a <code>java.time.Duration</code>
         * type.
         * 
         * Default: 30 seconds
         * Group: advanced
         * 
         * @param keepAliveTime the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointBuilder keepAliveTime(String keepAliveTime) {
            doSetProperty("keepAliveTime", keepAliveTime);
            return this;
        }
        /**
         * Configure the timeout for gRPC keepalives.
         * 
         * The option is a: <code>java.time.Duration</code> type.
         * 
         * Default: 10 seconds
         * Group: advanced
         * 
         * @param keepAliveTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointBuilder keepAliveTimeout(java.time.Duration keepAliveTimeout) {
            doSetProperty("keepAliveTimeout", keepAliveTimeout);
            return this;
        }
        /**
         * Configure the timeout for gRPC keepalives.
         * 
         * The option will be converted to a <code>java.time.Duration</code>
         * type.
         * 
         * Default: 10 seconds
         * Group: advanced
         * 
         * @param keepAliveTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointBuilder keepAliveTimeout(String keepAliveTimeout) {
            doSetProperty("keepAliveTimeout", keepAliveTimeout);
            return this;
        }
        /**
         * Configure etcd load balancer policy.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         * 
         * @param loadBalancerPolicy the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointBuilder loadBalancerPolicy(String loadBalancerPolicy) {
            doSetProperty("loadBalancerPolicy", loadBalancerPolicy);
            return this;
        }
        /**
         * Configure the maximum message size allowed for a single gRPC frame.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: advanced
         * 
         * @param maxInboundMessageSize the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointBuilder maxInboundMessageSize(Integer maxInboundMessageSize) {
            doSetProperty("maxInboundMessageSize", maxInboundMessageSize);
            return this;
        }
        /**
         * Configure the maximum message size allowed for a single gRPC frame.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param maxInboundMessageSize the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointBuilder maxInboundMessageSize(String maxInboundMessageSize) {
            doSetProperty("maxInboundMessageSize", maxInboundMessageSize);
            return this;
        }
        /**
         * Configure the delay between retries in milliseconds.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 500
         * Group: advanced
         * 
         * @param retryDelay the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointBuilder retryDelay(long retryDelay) {
            doSetProperty("retryDelay", retryDelay);
            return this;
        }
        /**
         * Configure the delay between retries in milliseconds.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 500
         * Group: advanced
         * 
         * @param retryDelay the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointBuilder retryDelay(String retryDelay) {
            doSetProperty("retryDelay", retryDelay);
            return this;
        }
        /**
         * Configure the max backing off delay between retries in milliseconds.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 2500
         * Group: advanced
         * 
         * @param retryMaxDelay the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointBuilder retryMaxDelay(long retryMaxDelay) {
            doSetProperty("retryMaxDelay", retryMaxDelay);
            return this;
        }
        /**
         * Configure the max backing off delay between retries in milliseconds.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 2500
         * Group: advanced
         * 
         * @param retryMaxDelay the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointBuilder retryMaxDelay(String retryMaxDelay) {
            doSetProperty("retryMaxDelay", retryMaxDelay);
            return this;
        }
        /**
         * Configure the retries max duration.
         * 
         * The option is a: <code>java.time.Duration</code> type.
         * 
         * Group: advanced
         * 
         * @param retryMaxDuration the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointBuilder retryMaxDuration(java.time.Duration retryMaxDuration) {
            doSetProperty("retryMaxDuration", retryMaxDuration);
            return this;
        }
        /**
         * Configure the retries max duration.
         * 
         * The option will be converted to a <code>java.time.Duration</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param retryMaxDuration the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointBuilder retryMaxDuration(String retryMaxDuration) {
            doSetProperty("retryMaxDuration", retryMaxDuration);
            return this;
        }
        /**
         * Configure SSL/TLS context to use instead of the system default.
         * 
         * The option is a: <code>io.netty.handler.ssl.SslContext</code> type.
         * 
         * Group: security
         * 
         * @param sslContext the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointBuilder sslContext(io.netty.handler.ssl.SslContext sslContext) {
            doSetProperty("sslContext", sslContext);
            return this;
        }
        /**
         * Configure SSL/TLS context to use instead of the system default.
         * 
         * The option will be converted to a
         * <code>io.netty.handler.ssl.SslContext</code> type.
         * 
         * Group: security
         * 
         * @param sslContext the value to set
         * @return the dsl builder
         */
        default AdvancedEtcd3EndpointBuilder sslContext(String sslContext) {
            doSetProperty("sslContext", sslContext);
            return this;
        }
    }

    public interface Etcd3Builders {
        /**
         * Etcd v3 (camel-etcd3)
         * Get, set, delete or watch keys in etcd key-value store.
         * 
         * Category: clustering,database
         * Since: 3.19
         * Maven coordinates: org.apache.camel:camel-etcd3
         * 
         * @return the dsl builder for the headers' name.
         */
        @Deprecated
        default Etcd3HeaderNameBuilder etcd3() {
            return Etcd3HeaderNameBuilder.INSTANCE;
        }
        /**
         * Etcd v3 (camel-etcd3)
         * Get, set, delete or watch keys in etcd key-value store.
         * 
         * Category: clustering,database
         * Since: 3.19
         * Maven coordinates: org.apache.camel:camel-etcd3
         * 
         * Syntax: <code>etcd3:path</code>
         * 
         * Path parameter: path
         * The path the endpoint refers to
         * 
         * @param path path
         * @return the dsl builder
         */
        @Deprecated
        default Etcd3EndpointBuilder etcd3(String path) {
            return Etcd3EndpointBuilderFactory.endpointBuilder("etcd3", path);
        }
        /**
         * Etcd v3 (camel-etcd3)
         * Get, set, delete or watch keys in etcd key-value store.
         * 
         * Category: clustering,database
         * Since: 3.19
         * Maven coordinates: org.apache.camel:camel-etcd3
         * 
         * Syntax: <code>etcd3:path</code>
         * 
         * Path parameter: path
         * The path the endpoint refers to
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path path
         * @return the dsl builder
         */
        @Deprecated
        default Etcd3EndpointBuilder etcd3(String componentName, String path) {
            return Etcd3EndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the Etcd v3 component.
     */
    public static class Etcd3HeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final Etcd3HeaderNameBuilder INSTANCE = new Etcd3HeaderNameBuilder();

        /**
         * The action to perform. Supported values: set get delete.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code EtcdAction}.
         */
        public String etcdAction() {
            return "CamelEtcdAction";
        }
        /**
         * The target path.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code EtcdPath}.
         */
        public String etcdPath() {
            return "CamelEtcdPath";
        }
        /**
         * To apply an action on all the key-value pairs whose key that starts
         * with the target path.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code EtcdIsPrefix}.
         */
        public String etcdIsPrefix() {
            return "CamelEtcdIsPrefix";
        }
        /**
         * The charset to use for the keys.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code EtcdKeyCharset}.
         */
        public String etcdKeyCharset() {
            return "CamelEtcdKeyCharset";
        }
        /**
         * The charset to use for the values.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code EtcdValueCharset}.
         */
        public String etcdValueCharset() {
            return "CamelEtcdValueCharset";
        }
    }
    static Etcd3EndpointBuilder endpointBuilder(String componentName, String path) {
        class Etcd3EndpointBuilderImpl extends AbstractEndpointBuilder implements Etcd3EndpointBuilder, AdvancedEtcd3EndpointBuilder {
            public Etcd3EndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new Etcd3EndpointBuilderImpl(path);
    }
}