/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.analysis.matchers;

import java.util.Objects;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.analysis.IHeaders;
import org.apache.rat.analysis.matchers.AbstractHeaderMatcher;
import org.apache.rat.config.parameters.ComponentType;
import org.apache.rat.config.parameters.ConfigComponent;

@ConfigComponent(type=ComponentType.MATCHER, name="not", desc="Negates the enclosed matcher.")
public class NotMatcher
extends AbstractHeaderMatcher {
    @ConfigComponent(desc="enclosed Matcher", type=ComponentType.PARAMETER, parameterType=IHeaderMatcher.class, required=true)
    private final IHeaderMatcher enclosed;

    public NotMatcher(String id, IHeaderMatcher enclosed) {
        super(id);
        Objects.requireNonNull(enclosed, "enclosed matcher may not be null");
        this.enclosed = enclosed;
    }

    public IHeaderMatcher getEnclosed() {
        return this.enclosed;
    }

    @Override
    public boolean matches(IHeaders headers) {
        return !this.enclosed.matches(headers);
    }

    @Override
    public void reset() {
        this.enclosed.reset();
    }
}

