/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.misc.processor;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.factory.WSDLFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.tools.common.Processor;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.util.ClassCollector;
import org.apache.cxf.tools.util.FileWriterUtil;
import org.apache.cxf.tools.util.OutputStreamCreator;
import org.apache.cxf.tools.validator.internal.WSDL11Validator;
import org.apache.cxf.tools.wsdlto.core.WSDLDefinitionBuilder;
import org.apache.cxf.wsdl.WSDLExtensibilityPlugin;
import org.apache.cxf.wsdl.WSDLManager;
import org.xml.sax.SAXParseException;

public class AbstractWSDLToProcessor
implements Processor {
    protected static final Logger LOG = LogUtils.getL7dLogger(AbstractWSDLToProcessor.class);
    protected static final String WSDL_FILE_NAME_EXT = ".wsdl";
    protected Definition wsdlDefinition;
    protected ToolContext env;
    protected WSDLFactory wsdlFactory;
    protected ExtensionRegistry extReg;
    protected ClassCollector classColletor;
    private Map<String, WSDLExtensibilityPlugin> wsdlPlugins = new HashMap<String, WSDLExtensibilityPlugin>();

    protected Writer getOutputWriter(String newNameExt) throws ToolException {
        Object newName;
        if (this.env.get("outputfile") != null) {
            newName = (String)this.env.get("outputfile");
        } else {
            String oldName = (String)this.env.get("wsdlurl");
            int position = oldName.lastIndexOf(47);
            if (position < 0) {
                position = oldName.lastIndexOf(92);
            }
            if (position >= 0) {
                oldName = oldName.substring(position + 1, oldName.length());
            }
            newName = oldName.toLowerCase().indexOf(WSDL_FILE_NAME_EXT) >= 0 ? oldName.substring(0, oldName.length() - 5) + newNameExt + WSDL_FILE_NAME_EXT : oldName + newNameExt;
        }
        String outputDir = this.env.get("outputdir") != null ? (String)this.env.get("outputdir") : "./";
        FileWriterUtil fw = new FileWriterUtil(outputDir, (OutputStreamCreator)this.env.get(OutputStreamCreator.class));
        try {
            return fw.getWriter("", (String)newName);
        }
        catch (IOException ioe) {
            Message msg = new Message("FAIL_TO_WRITE_FILE", LOG, new Object[]{String.valueOf(this.env.get("outputdir")) + System.getProperty("file.seperator") + (String)newName});
            throw new ToolException(msg, (Throwable)ioe);
        }
    }

    protected void parseWSDL(String wsdlURL) throws ToolException {
        Bus bus = (Bus)this.env.get(Bus.class);
        if (bus == null) {
            bus = BusFactory.getThreadDefaultBus();
            this.env.put(Bus.class, (Object)bus);
        }
        WSDLDefinitionBuilder builder = new WSDLDefinitionBuilder(bus);
        this.wsdlDefinition = builder.build(wsdlURL);
        if (this.env.fullValidateWSDL()) {
            this.validate(this.wsdlDefinition, this.env, bus);
        }
        WSDLManager mgr = (WSDLManager)bus.getExtension(WSDLManager.class);
        mgr.removeDefinition(this.wsdlDefinition);
        this.wsdlFactory = mgr.getWSDLFactory();
        this.extReg = mgr.getExtensionRegistry();
        this.wsdlPlugins = builder.getWSDLPlugins();
    }

    public WSDLExtensibilityPlugin getWSDLPlugin(String key, Class<?> clz) {
        StringBuilder sb = new StringBuilder();
        sb.append(key);
        sb.append('-');
        sb.append(clz.getName());
        WSDLExtensibilityPlugin plugin = this.wsdlPlugins.get(sb.toString());
        if (plugin == null) {
            throw new ToolException(new Message("FOUND_NO_WSDL_PLUGIN", LOG, new Object[]{sb.toString(), clz}));
        }
        return plugin;
    }

    protected void init() throws ToolException {
    }

    public Definition getWSDLDefinition() {
        return this.wsdlDefinition;
    }

    public void process() throws ToolException {
    }

    public void validateWSDL() throws ToolException {
        if (this.env.fullValidateWSDL()) {
            WSDL11Validator validator = new WSDL11Validator(this.wsdlDefinition, this.env);
            validator.isValid();
        }
    }

    public void setEnvironment(ToolContext penv) {
        this.env = penv;
    }

    public ToolContext getEnvironment() {
        return this.env;
    }

    public void error(SAXParseException exception) {
        if (this.env.isVerbose()) {
            exception.printStackTrace();
        } else {
            System.err.println("Parsing schema error: \n" + exception.toString());
        }
    }

    public void fatalError(SAXParseException exception) {
        if (this.env.isVerbose()) {
            exception.printStackTrace();
        } else {
            System.err.println("Parsing schema fatal error: \n" + exception.toString());
        }
    }

    public void info(SAXParseException exception) {
        if (this.env.isVerbose()) {
            System.err.println("Parsing schema info: " + exception.toString());
        }
    }

    public void warning(SAXParseException exception) {
        if (this.env.isVerbose()) {
            System.err.println("Parsing schema warning " + exception.toString());
        }
    }

    public boolean validate(Definition def, ToolContext context, Bus bus) throws ToolException {
        return new WSDL11Validator(def, context, bus).isValid();
    }
}

