/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.contracts.generation;

import java.lang.annotation.Annotation;
import java.util.List;
import org.apache.groovy.contracts.annotations.meta.ClassInvariant;
import org.apache.groovy.contracts.generation.AssertStatementCreationUtility;
import org.apache.groovy.contracts.generation.BaseGenerator;
import org.apache.groovy.contracts.util.AnnotationUtils;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.control.io.ReaderSource;
import org.codehaus.groovy.syntax.Token;

public class ClassInvariantGenerator
extends BaseGenerator {
    public ClassInvariantGenerator(ReaderSource source) {
        super(source);
    }

    public void generateInvariantAssertionStatement(ClassNode type, org.apache.groovy.contracts.domain.ClassInvariant classInvariant) {
        BooleanExpression classInvariantExpression = this.addCallsToSuperAnnotationClosure(type, ClassInvariant.class, classInvariant.booleanExpression());
        BlockStatement blockStatement = new BlockStatement();
        MethodNode methodNode = type.addMethod(ClassInvariantGenerator.getInvariantMethodName(type), 4100, ClassHelper.VOID_TYPE, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, (Statement)blockStatement);
        methodNode.setSynthetic(true);
        blockStatement.addStatements(this.wrapAssertionBooleanExpression(type, methodNode, classInvariantExpression, "invariant").getStatements());
    }

    private BooleanExpression addCallsToSuperAnnotationClosure(ClassNode type, Class<? extends Annotation> annotationType, BooleanExpression booleanExpression) {
        List<AnnotationNode> nextContractElementAnnotations = AnnotationUtils.getAnnotationNodeInHierarchyWithMetaAnnotation(type.getSuperClass(), ClassHelper.makeWithoutCaching(annotationType));
        if (nextContractElementAnnotations.isEmpty()) {
            return booleanExpression;
        }
        for (AnnotationNode nextContractElementAnnotation : nextContractElementAnnotations) {
            ClassExpression classExpression = (ClassExpression)nextContractElementAnnotation.getMember("value");
            if (classExpression == null) continue;
            MethodCallExpression doCall = GeneralUtils.callX((Expression)GeneralUtils.ctorX((ClassNode)classExpression.getType(), (Expression)GeneralUtils.args((Expression[])new Expression[]{VariableExpression.THIS_EXPRESSION, VariableExpression.THIS_EXPRESSION})), (String)"doCall");
            doCall.setMethodTarget((MethodNode)classExpression.getType().getMethods("doCall").get(0));
            BooleanExpression rightExpression = GeneralUtils.boolX((Expression)doCall);
            booleanExpression.setSourcePosition((ASTNode)nextContractElementAnnotation);
            booleanExpression = GeneralUtils.boolX((Expression)GeneralUtils.binX((Expression)booleanExpression, (Token)GeneralUtils.AND, (Expression)rightExpression));
        }
        return booleanExpression;
    }

    public void addInvariantAssertionStatement(ClassNode type, MethodNode method) {
        String invariantMethodName = ClassInvariantGenerator.getInvariantMethodName(type);
        MethodNode invariantMethod = type.getDeclaredMethod(invariantMethodName, Parameter.EMPTY_ARRAY);
        if (invariantMethod == null) {
            return;
        }
        Statement invariantMethodCall = GeneralUtils.stmt((Expression)GeneralUtils.callThisX((String)invariantMethod.getName()));
        Statement statement = method.getCode();
        if (statement instanceof BlockStatement && !ClassHelper.isPrimitiveVoid((ClassNode)method.getReturnType()) && !(method instanceof ConstructorNode)) {
            BlockStatement blockStatement = (BlockStatement)statement;
            List<ReturnStatement> returnStatements = AssertStatementCreationUtility.getReturnStatements(method);
            for (ReturnStatement returnStatement : returnStatements) {
                AssertStatementCreationUtility.addAssertionCallStatementToReturnStatement(blockStatement, returnStatement, invariantMethodCall);
            }
            if (returnStatements.isEmpty()) {
                blockStatement.addStatement(invariantMethodCall);
            }
        } else if (statement instanceof BlockStatement) {
            BlockStatement blockStatement = (BlockStatement)statement;
            blockStatement.addStatement(invariantMethodCall);
        } else {
            BlockStatement assertionBlock = new BlockStatement();
            assertionBlock.addStatement(statement);
            assertionBlock.addStatement(invariantMethodCall);
            method.setCode((Statement)assertionBlock);
        }
    }
}

