/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.cassandra.io.util.DataOutputBufferFixed;
import org.apache.cassandra.streaming.StreamingDataOutputPlus;

public class StreamingDataOutputPlusFixed
extends DataOutputBufferFixed
implements StreamingDataOutputPlus {
    public StreamingDataOutputPlusFixed(ByteBuffer buffer) {
        super(buffer);
    }

    @Override
    public int writeToChannel(StreamingDataOutputPlus.Write write, StreamingDataOutputPlus.RateLimiter limiter) throws IOException {
        int position = this.buffer.position();
        write.write((int size) -> this.buffer);
        return this.buffer.position() - position;
    }

    @Override
    public long writeFileToChannel(FileChannel file, StreamingDataOutputPlus.RateLimiter limiter) throws IOException {
        long tmp;
        long count = 0L;
        while (0L <= (tmp = (long)file.read(this.buffer))) {
            count += tmp;
        }
        return count;
    }
}

