/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.IFSChangeAttrsReq;
import com.ibm.as400.access.IFSCloseRep;
import com.ibm.as400.access.IFSCloseReq;
import com.ibm.as400.access.IFSCommitReq;
import com.ibm.as400.access.IFSCopyReq;
import com.ibm.as400.access.IFSDataStream;
import com.ibm.as400.access.IFSExchangeAttrRep;
import com.ibm.as400.access.IFSExchangeAttrReq;
import com.ibm.as400.access.IFSFileDescriptorImpl;
import com.ibm.as400.access.IFSFileOutputStreamImplRemote;
import com.ibm.as400.access.IFSFreeHandleReq;
import com.ibm.as400.access.IFSGetFileSystemRep;
import com.ibm.as400.access.IFSGetFileSystemReq;
import com.ibm.as400.access.IFSKey;
import com.ibm.as400.access.IFSListAttrsRep;
import com.ibm.as400.access.IFSListAttrsReq;
import com.ibm.as400.access.IFSLockBytesRep;
import com.ibm.as400.access.IFSLockBytesReq;
import com.ibm.as400.access.IFSLookupRep;
import com.ibm.as400.access.IFSLookupReq;
import com.ibm.as400.access.IFSOpenRep;
import com.ibm.as400.access.IFSOpenReq;
import com.ibm.as400.access.IFSRandomAccessFileImplRemote;
import com.ibm.as400.access.IFSReadRep;
import com.ibm.as400.access.IFSReadReq;
import com.ibm.as400.access.IFSReturnCodeRep;
import com.ibm.as400.access.IFSUnlockBytesReq;
import com.ibm.as400.access.IFSWriteRep;
import com.ibm.as400.access.IFSWriteReq;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Vector;

class IFSFileDescriptorImplRemote
implements IFSFileDescriptorImpl {
    private static final int UNINITIALIZED = -1;
    private static final int MAX_BYTES_PER_READ = 16000000;
    ConverterImplRemote converter_;
    private int fileHandle_ = -1;
    int preferredServerCCSID_;
    private int fileDataCCSID_ = -1;
    private int fileAsp_ = -1;
    private int fileSystemType_ = -1;
    int serverDatastreamLevel_;
    int requestedDatastreamLevel_;
    private long fileOffset_;
    boolean isOpen_;
    boolean isOpenAllowed_ = true;
    private Object parent_;
    String path_ = "";
    byte[] pathnameBytes_;
    transient Object serverLock_ = new Object();
    AS400Server server_;
    private int shareOption_;
    AS400ImplRemote system_;
    private Object fileOffsetLock_ = new Object();
    private int maxDataBlockSize_ = 1024;
    private Integer systemVRM_;
    transient int errorRC_;
    int patternMatching_ = 0;
    private static final boolean DEBUG = false;
    String fileOwnerName_ = null;

    IFSFileDescriptorImplRemote() {
    }

    static IFSFileDescriptorImplRemote castImplToImplRemote(IFSFileDescriptorImpl fd) {
        try {
            return (IFSFileDescriptorImplRemote)fd;
        }
        catch (ClassCastException e) {
            Trace.log(2, "Argument is not an instance of IFSFileDescriptorImplRemote", (Throwable)e);
            throw new InternalErrorException(10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int checkAccess(int access, int openOption) throws IOException, AS400SecurityException {
        int fileHandle = -1;
        try {
            fileHandle = this.createFileHandle(access, openOption);
        }
        finally {
            if (fileHandle != -1) {
                this.close(fileHandle);
            }
        }
        return this.errorRC_;
    }

    @Override
    public void close() {
        try {
            this.close0();
        }
        catch (IOException e) {
            Trace.log(2, "Error while closing file " + this.path_, (Throwable)e);
        }
    }

    public void close0() throws IOException {
        this.isOpen_ = false;
        this.close(this.fileHandle_);
        this.fileHandle_ = -1;
    }

    void close(int fileHandle) throws IOException {
        if (fileHandle == -1) {
            return;
        }
        ClientAccessDataStream ds = null;
        IFSCloseReq req = new IFSCloseReq(fileHandle);
        try {
            ds = (ClientAccessDataStream)this.server_.sendAndReceive(req);
        }
        catch (ConnectionDroppedException e) {
            Trace.log(2, "Byte stream connection lost during close", (Throwable)e);
            this.connectionDropped(e);
        }
        catch (InterruptedException e) {
            Trace.log(2, "Interrupted", (Throwable)e);
            InterruptedIOException throwException = new InterruptedIOException(e.getMessage());
            throwException.initCause(e);
            throw throwException;
        }
        if (ds instanceof IFSCloseRep) {
            int rc = ((IFSCloseRep)ds).getReturnCode();
            if (rc != 0) {
                Trace.log(2, "IFSCloseRep return code", rc);
                throw new ExtendedIOException(this.path_, rc);
            }
        } else if (ds instanceof IFSReturnCodeRep) {
            int rc = ((IFSReturnCodeRep)ds).getReturnCode();
            if (rc != 0) {
                Trace.log(2, "IFSReturnCodeRep return code", IFSFileDescriptorImplRemote.descriptionForReturnCode(rc));
                throw new ExtendedIOException(this.path_, rc);
            }
        } else {
            Trace.log(2, "Unknown reply data stream", ds.data_);
            throw new InternalErrorException(Integer.toHexString(ds.getReqRepID()), 2);
        }
    }

    void connect() throws IOException, AS400SecurityException {
        if (this.server_ != null) {
            return;
        }
        if (this.system_ == null) {
            throw new ExtendedIllegalStateException("system", 4);
        }
        try {
            this.server_ = this.system_.getConnection(0, false, false);
        }
        catch (AS400SecurityException e) {
            Trace.log(2, "Access to byte stream server on '" + this.system_.getSystemName() + "' denied.", (Throwable)e);
            throw e;
        }
        this.exchangeServerAttributes();
    }

    void connectionDropped(ConnectionDroppedException e) throws ConnectionDroppedException {
        if (this.server_ != null) {
            this.system_.disconnectServer(this.server_);
            this.server_ = null;
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Trace.log(2, "Byte stream connection lost.");
        throw e;
    }

    boolean copyTo(String destinationPath, boolean replace) throws AS400SecurityException, IOException {
        ClientAccessDataStream ds = null;
        IFSCopyReq req = new IFSCopyReq(this.path_, destinationPath, replace);
        try {
            ds = (ClientAccessDataStream)this.server_.sendAndReceive(req);
        }
        catch (ConnectionDroppedException e) {
            Trace.log(2, "Byte stream connection lost during copy", (Throwable)e);
            this.connectionDropped(e);
        }
        catch (InterruptedException e) {
            Trace.log(2, "Interrupted", (Throwable)e);
            InterruptedIOException throwException = new InterruptedIOException(e.getMessage());
            throwException.initCause(e);
            throw throwException;
        }
        if (ds instanceof IFSReturnCodeRep) {
            int rc = ((IFSReturnCodeRep)ds).getReturnCode();
            if (rc != 0) {
                String path = rc == 4 ? destinationPath : this.path_;
                IFSFileDescriptorImplRemote.throwSecurityExceptionIfAccessDenied(path, rc);
                Trace.log(2, "IFSReturnCodeRep return code", IFSFileDescriptorImplRemote.descriptionForReturnCode(rc));
                throw new ExtendedIOException(path, rc);
            }
            return true;
        }
        Trace.log(2, "Unknown reply data stream", ds.data_);
        throw new InternalErrorException(Integer.toHexString(ds.getReqRepID()), 2);
    }

    private final int createFileHandle() throws IOException, AS400SecurityException {
        return this.createFileHandle(1, 8);
    }

    int createFileHandle(int access, int openOption) throws IOException, AS400SecurityException {
        int fileHandle;
        int returnCode;
        block7: {
            returnCode = 2;
            fileHandle = -1;
            this.errorRC_ = 0;
            try {
                IFSOpenReq req = new IFSOpenReq(this.getPathnameAsBytes(), this.preferredServerCCSID_, 0, access, 0, 0, openOption, this.serverDatastreamLevel_);
                ClientAccessDataStream ds = (ClientAccessDataStream)this.server_.sendAndReceive(req);
                if (ds instanceof IFSOpenRep) {
                    returnCode = 0;
                    fileHandle = ((IFSOpenRep)ds).getFileHandle();
                    break block7;
                }
                if (ds instanceof IFSReturnCodeRep) {
                    returnCode = ((IFSReturnCodeRep)ds).getReturnCode();
                    IFSFileDescriptorImplRemote.throwSecurityExceptionIfAccessDenied(this.path_, returnCode);
                    break block7;
                }
                Trace.log(2, "Unknown reply data stream", ds.data_);
                throw new InternalErrorException(Integer.toHexString(ds.getReqRepID()), 2);
            }
            catch (ConnectionDroppedException e) {
                Trace.log(2, "Byte stream server connection lost", (Throwable)e);
                this.connectionDropped(e);
            }
            catch (InterruptedException e) {
                Trace.log(2, "Interrupted", (Throwable)e);
                InterruptedIOException throwException = new InterruptedIOException(e.getMessage());
                throwException.initCause(e);
                throw throwException;
            }
        }
        if (returnCode != 0) {
            if (Trace.isTraceOn() && Trace.isTraceDiagnosticOn()) {
                Trace.log(1, "Unable to open file " + this.path_ + ": IFSReturnCodeRep return code", IFSFileDescriptorImplRemote.descriptionForReturnCode(returnCode));
            }
            this.errorRC_ = returnCode;
            return -1;
        }
        return fileHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exchangeServerAttributes() throws IOException, AS400SecurityException {
        Object object = this.serverLock_;
        synchronized (object) {
            DataStream ds = this.server_.getExchangeAttrReply();
            IFSExchangeAttrRep rep = null;
            try {
                rep = (IFSExchangeAttrRep)ds;
            }
            catch (ClassCastException e) {
                if (ds instanceof IFSReturnCodeRep) {
                    int rc = ((IFSReturnCodeRep)ds).getReturnCode();
                    IFSFileDescriptorImplRemote.throwSecurityExceptionIfAccessDenied(this.path_, rc);
                    Trace.log(2, "IFSReturnCodeRep return code", IFSFileDescriptorImplRemote.descriptionForReturnCode(rc));
                    throw new ExtendedIOException(this.path_, rc);
                }
                String className = ds == null ? "null" : ds.getClass().getName();
                Trace.log(2, "Unexpected reply from Exchange Server Attributes: " + className);
                throw new InternalErrorException(2);
            }
            this.requestedDatastreamLevel_ = this.getSystemVRM() >= 393472 ? 16 : (this.getSystemVRM() >= 328448 ? 8 : (this.getSystemVRM() >= 263424 ? 2 : 0));
            if (rep == null) {
                ds = null;
                try {
                    int[] preferredCcsids = this.getSystemVRM() >= 328448 ? new int[]{1200, 13488, 61952} : (this.getSystemVRM() >= 263424 ? new int[]{13488, 61952} : new int[]{61952});
                    ds = this.server_.sendExchangeAttrRequest(new IFSExchangeAttrReq(true, false, 2, -1, this.requestedDatastreamLevel_, preferredCcsids));
                    rep = (IFSExchangeAttrRep)ds;
                }
                catch (ConnectionDroppedException e) {
                    Trace.log(2, "Byte stream server connection lost");
                    this.connectionDropped(e);
                }
                catch (InterruptedException e) {
                    Trace.log(2, "Interrupted", (Throwable)e);
                    this.system_.disconnectServer(this.server_);
                    this.server_ = null;
                    InterruptedIOException throwException = new InterruptedIOException(e.getMessage());
                    throwException.initCause(e);
                    throw throwException;
                }
                catch (IOException e) {
                    Trace.log(2, "I/O error during attribute exchange.");
                    this.system_.disconnectServer(this.server_);
                    this.server_ = null;
                    throw e;
                }
                catch (ClassCastException e) {
                    if (ds instanceof IFSReturnCodeRep) {
                        int rc = ((IFSReturnCodeRep)ds).getReturnCode();
                        IFSFileDescriptorImplRemote.throwSecurityExceptionIfAccessDenied(this.path_, rc);
                        Trace.log(2, "IFSReturnCodeRep return code", IFSFileDescriptorImplRemote.descriptionForReturnCode(rc));
                        throw new ExtendedIOException(this.path_, rc);
                    }
                    String className = ds == null ? "null" : ds.getClass().getName();
                    Trace.log(2, "Unexpected reply from Exchange Server Attributes: " + className);
                    throw new InternalErrorException(2);
                }
            }
            if (rep == null) {
                Trace.log(2, "Null reply data stream");
                this.system_.disconnectServer(this.server_);
                this.server_ = null;
                throw new InternalErrorException(2);
            }
            this.maxDataBlockSize_ = rep.getMaxDataBlockSize();
            this.preferredServerCCSID_ = rep.getPreferredCCSID();
            this.serverDatastreamLevel_ = rep.getDataStreamLevel();
            this.setConverter(ConverterImplRemote.getConverter(this.preferredServerCCSID_, this.system_));
        }
    }

    private static String descriptionForReturnCode(int rc) {
        switch (rc) {
            case 4636: {
                return rc + ": Not authorized to command. (Check for user exit program.)";
            }
            case 4692: {
                return rc + ": Command check. (Check for user exit program.)";
            }
            case 4702: {
                return rc + ": Closed with damage.";
            }
            case 3391: {
                return rc + ": File is temporarily unavailable.";
            }
            case 3392: {
                return rc + ": Directory is temporarily unavailable.";
            }
            case 3393: {
                return rc + ": Working directory handle is not valid.";
            }
            case 3394: {
                return rc + ": File handle is not valid.";
            }
            case 3395: {
                return rc + ": User handle is not valid.";
            }
            case 3396: {
                return rc + ": User is temporarily unavailable.";
            }
        }
        return Integer.toString(rc);
    }

    void finalize0() throws Throwable {
        block8: {
            try {
                if (this.fileHandle_ == -1) break block8;
                IFSCloseReq req = new IFSCloseReq(this.fileHandle_);
                try {
                    this.server_.sendAndDiscardReply(req);
                }
                finally {
                    this.isOpen_ = false;
                    this.fileHandle_ = -1;
                }
            }
            catch (Throwable e) {
                Trace.log(2, "Error during finalization.", e);
            }
            finally {
                super.finalize();
            }
        }
    }

    void flush() throws IOException, AS400SecurityException {
        IFSCommitReq req = new IFSCommitReq(this.fileHandle_);
        ClientAccessDataStream ds = null;
        try {
            ds = (ClientAccessDataStream)this.server_.sendAndReceive(req);
        }
        catch (ConnectionDroppedException e) {
            Trace.log(2, "Byte stream server connection lost");
            this.connectionDropped(e);
        }
        catch (InterruptedException e) {
            Trace.log(2, "Interrupted", (Throwable)e);
            InterruptedIOException throwException = new InterruptedIOException(e.getMessage());
            throwException.initCause(e);
            throw throwException;
        }
        if (ds instanceof IFSReturnCodeRep) {
            int rc = ((IFSReturnCodeRep)ds).getReturnCode();
            if (rc != 0) {
                IFSFileDescriptorImplRemote.throwSecurityExceptionIfAccessDenied(this.path_, rc);
                Trace.log(2, "IFSReturnCodeRep return code", IFSFileDescriptorImplRemote.descriptionForReturnCode(rc));
                throw new ExtendedIOException(this.path_, rc);
            }
        } else {
            Trace.log(2, "Unknown reply data stream", ds.data_);
            throw new InternalErrorException(Integer.toHexString(ds.getReqRepID()), 2);
        }
    }

    ConverterImplRemote getConverter() {
        return this.converter_;
    }

    public String getOwnerName() throws IOException {
        block9: {
            if (this.fileOwnerName_ == null) {
                try {
                    this.connect();
                    IFSListAttrsRep reply = this.listObjAttrs12(2048, 0);
                    if (reply != null) {
                        this.fileOwnerName_ = reply.getOwnerName(this.system_.getCcsid());
                        if (this.fileDataCCSID_ == -1) {
                            this.fileDataCCSID_ = reply.getCCSID(this.serverDatastreamLevel_);
                        }
                        break block9;
                    }
                    if (this.errorRC_ == 2 || this.errorRC_ == 3) {
                        throw new ExtendedIOException(this.path_, 3);
                    }
                    return this.getOwnerNameByUserHandle(true);
                }
                catch (ExtendedIOException e) {
                    if (e.getReturnCode() == 4) {
                        if (Trace.traceOn_) {
                            Trace.log(4, "Unable to determine owner of directory.", (Throwable)e);
                        }
                    }
                    throw e;
                }
                catch (AS400SecurityException e) {
                    throw new ExtendedIOException(this.path_, 5);
                }
            }
        }
        return this.fileOwnerName_ == null ? "" : this.fileOwnerName_;
    }

    public int getCCSID(boolean retrieveAll) throws IOException {
        if (this.fileDataCCSID_ == -1) {
            try {
                this.connect();
                IFSListAttrsRep reply = null;
                reply = retrieveAll ? this.listObjAttrs12(2048, 0) : this.listObjAttrs2();
                if (reply != null) {
                    this.fileDataCCSID_ = reply.getCCSID(this.serverDatastreamLevel_);
                    if (retrieveAll && this.fileOwnerName_ == null) {
                        this.fileOwnerName_ = reply.getOwnerName(this.system_.getCcsid());
                    }
                } else {
                    if (this.errorRC_ == 2 || this.errorRC_ == 3) {
                        throw new ExtendedIOException(this.path_, 3);
                    }
                    if (retrieveAll) {
                        return this.getCCSID();
                    }
                }
            }
            catch (AS400SecurityException e) {
                throw new ExtendedIOException(this.path_, 5);
            }
        }
        return this.fileDataCCSID_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCCSID() throws IOException {
        block15: {
            if (this.fileDataCCSID_ == -1) {
                ClientAccessDataStream ds = null;
                try {
                    this.connect();
                    int userHandle = -1;
                    int objectHandle = -1;
                    try {
                        int n = userHandle = this.getSystem().getVRM() <= 460032 ? this.system_.createUserHandle() : 0;
                        if (userHandle == -1) {
                            IFSListAttrsRep reply = this.listObjAttrs2();
                            if (reply != null) {
                                this.fileDataCCSID_ = reply.getCCSID(this.serverDatastreamLevel_);
                            }
                            break block15;
                        }
                        try {
                            byte[] path = this.getConverter().stringToByteArray(this.path_);
                            IFSLookupReq req = new IFSLookupReq(path, this.preferredServerCCSID_, userHandle, 12, 0x100800, 0);
                            ds = (ClientAccessDataStream)this.server_.sendAndReceive(req);
                        }
                        catch (ConnectionDroppedException e) {
                            Trace.log(2, "Byte stream server connection lost.");
                            this.connectionDropped(e);
                        }
                        catch (InterruptedException e) {
                            Trace.log(2, "Interrupted");
                            InterruptedIOException throwException = new InterruptedIOException(e.getMessage());
                            throwException.initCause(e);
                            throw throwException;
                        }
                        int rc = 0;
                        if (ds instanceof IFSLookupRep) {
                            objectHandle = ((IFSLookupRep)ds).getHandle();
                            this.retrieveAttributes(ds, objectHandle);
                            break block15;
                        }
                        if (ds instanceof IFSReturnCodeRep) {
                            rc = ((IFSReturnCodeRep)ds).getReturnCode();
                            if (rc != 0) {
                                Trace.log(2, "IFSReturnCodeRep return code", rc);
                            }
                            throw new ExtendedIOException(this.path_, rc);
                        }
                        Trace.log(2, "Unknown reply data stream", ds.getReqRepID());
                        throw new InternalErrorException(Integer.toHexString(ds.getReqRepID()), 2);
                    }
                    finally {
                        if (objectHandle != -1) {
                            this.freeHandle(objectHandle);
                        }
                    }
                }
                catch (AS400SecurityException e) {
                    throw new ExtendedIOException(this.path_, 5);
                }
            }
        }
        return this.fileDataCCSID_;
    }

    int getFileHandle() {
        return this.fileHandle_;
    }

    @Override
    public long getFileOffset() {
        return this.fileOffset_;
    }

    Object getParent() {
        return this.parent_;
    }

    String getPath() {
        return this.path_;
    }

    final byte[] getPathnameAsBytes() {
        if (this.pathnameBytes_ == null) {
            this.pathnameBytes_ = this.converter_.stringToByteArray(this.path_);
        }
        return this.pathnameBytes_;
    }

    int getPreferredCCSID() {
        return this.preferredServerCCSID_;
    }

    AS400Server getServer() {
        return this.server_;
    }

    int getShareOption() {
        return this.shareOption_;
    }

    AS400ImplRemote getSystem() {
        return this.system_;
    }

    int getSystemVRM() {
        if (this.systemVRM_ == null) {
            this.systemVRM_ = this.system_.getVRM();
        }
        return this.systemVRM_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementFileOffset(long fileOffsetIncrement) {
        Object object = this.fileOffsetLock_;
        synchronized (object) {
            this.fileOffset_ += fileOffsetIncrement;
        }
    }

    @Override
    public void initialize(long fileOffset, Object parentImpl, String path, int shareOption, AS400Impl system) {
        this.fileOffset_ = fileOffset;
        this.parent_ = parentImpl;
        this.path_ = path;
        this.shareOption_ = shareOption;
        this.system_ = (AS400ImplRemote)system;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen_;
    }

    boolean isOpenAllowed() {
        return this.isOpenAllowed_;
    }

    Vector listAttributes(IFSListAttrsReq req) throws IOException, AS400SecurityException {
        this.errorRC_ = 0;
        Vector<ClientAccessDataStream> replys = new Vector<ClientAccessDataStream>(256);
        ClientAccessDataStream ds = null;
        try {
            ds = (ClientAccessDataStream)this.server_.sendAndReceive(req);
        }
        catch (ConnectionDroppedException e) {
            Trace.log(2, "Byte stream server connection lost.");
            this.connectionDropped(e);
        }
        catch (InterruptedException e) {
            Trace.log(2, "Interrupted");
            InterruptedIOException throwException = new InterruptedIOException(e.getMessage());
            throwException.initCause(e);
            throw throwException;
        }
        int rc = -1;
        boolean done = false;
        do {
            if (ds instanceof IFSListAttrsRep) {
                replys.addElement(ds);
            } else if (ds instanceof IFSReturnCodeRep) {
                rc = ((IFSReturnCodeRep)ds).getReturnCode();
                if (rc != 0 && rc != 18 && rc != 2 && rc != 3) {
                    IFSFileDescriptorImplRemote.throwSecurityExceptionIfAccessDenied(this.path_, rc);
                    Trace.log(2, "Error getting file attributes for file " + this.path_ + ": IFSReturnCodeRep return code", IFSFileDescriptorImplRemote.descriptionForReturnCode(rc));
                    throw new ExtendedIOException(this.path_, rc);
                }
            } else {
                Trace.log(2, "Unknown reply data stream", ds.data_);
                throw new InternalErrorException(Integer.toHexString(ds.getReqRepID()), 2);
            }
            done = ((IFSDataStream)ds).isEndOfChain();
            if (done) continue;
            try {
                ds = (ClientAccessDataStream)this.server_.receive(req.getCorrelation());
            }
            catch (ConnectionDroppedException e) {
                Trace.log(2, "Byte stream server connection lost.");
                this.connectionDropped(e);
            }
            catch (InterruptedException e) {
                Trace.log(2, "Interrupted");
                InterruptedIOException throwException = new InterruptedIOException(e.getMessage());
                throwException.initCause(e);
                throw throwException;
            }
        } while (!done);
        if (rc == 3) {
            this.errorRC_ = rc;
            replys = null;
        } else {
            replys.trimToSize();
        }
        return replys;
    }

    IFSListAttrsRep listObjAttrs1(int flags1, int flags2) throws IOException, AS400SecurityException {
        return this.listObjAttrs(1, flags1, flags2);
    }

    IFSListAttrsRep listObjAttrs2() throws IOException, AS400SecurityException {
        return this.listObjAttrs(2, 0, 0);
    }

    IFSListAttrsRep listObjAttrs12(int flags1, int flags2) throws IOException, AS400SecurityException {
        return this.listObjAttrs(12, flags1, flags2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IFSListAttrsRep listObjAttrs(int attrsType, int flags1, int flags2) throws IOException, AS400SecurityException {
        IFSListAttrsRep reply = null;
        int fileHandle = -1;
        boolean usedGlobalHandle = false;
        try {
            if (this.fileHandle_ != -1) {
                fileHandle = this.fileHandle_;
                usedGlobalHandle = true;
            } else {
                fileHandle = this.createFileHandle();
                if (fileHandle == -1) {
                    if (Trace.traceOn_) {
                        Trace.log(2, "Unable to create handle to file " + this.path_ + ". IFSReturnCodeRep return code", this.errorRC_);
                    }
                    IFSListAttrsRep iFSListAttrsRep = null;
                    return iFSListAttrsRep;
                }
            }
            IFSListAttrsReq req1 = new IFSListAttrsReq(fileHandle, attrsType, flags1, flags2);
            req1.setPatternMatching(this.patternMatching_);
            Vector replys = this.listAttributes(req1);
            if (replys == null) {
                if (Trace.traceOn_) {
                    Trace.log(4, "Received null from listAttributes(fileHandle).");
                }
            } else if (replys.size() == 0) {
                if (Trace.traceOn_) {
                    Trace.log(4, "Received no replies from listAttributes(fileHandle).");
                }
            } else if (replys.size() > 1) {
                if (Trace.traceOn_) {
                    Trace.log(4, "Received multiple replies from listAttributes(fileHandle) (" + replys.size() + ")");
                }
            } else {
                reply = (IFSListAttrsRep)replys.elementAt(0);
            }
        }
        finally {
            if (!usedGlobalHandle && fileHandle != -1) {
                this.close(fileHandle);
            }
        }
        return reply;
    }

    IFSKey lock(long length) throws IOException, AS400SecurityException {
        return this.lock(this.fileOffset_, length);
    }

    IFSKey lock(long offset, long length) throws IOException, AS400SecurityException {
        int rc;
        ClientAccessDataStream ds = null;
        try {
            IFSLockBytesReq req = new IFSLockBytesReq(this.fileHandle_, true, false, offset, length, this.serverDatastreamLevel_);
            ds = (ClientAccessDataStream)this.server_.sendAndReceive(req);
        }
        catch (ConnectionDroppedException e) {
            Trace.log(2, "Byte stream server connection lost");
            this.connectionDropped(e);
        }
        catch (InterruptedException e) {
            Trace.log(2, "Interrupted", (Throwable)e);
            InterruptedIOException throwException = new InterruptedIOException(e.getMessage());
            throwException.initCause(e);
            throw throwException;
        }
        if (ds instanceof IFSLockBytesRep) {
            rc = ((IFSLockBytesRep)ds).getReturnCode();
            if (rc != 0) {
                Trace.log(2, "IFSLockBytesRep return code", rc);
                throw new ExtendedIOException(this.path_, rc);
            }
        } else if (ds instanceof IFSReturnCodeRep) {
            rc = ((IFSReturnCodeRep)ds).getReturnCode();
            if (rc != 0) {
                IFSFileDescriptorImplRemote.throwSecurityExceptionIfAccessDenied(this.path_, rc);
                Trace.log(2, "IFSReturnCodeRep return code", IFSFileDescriptorImplRemote.descriptionForReturnCode(rc));
                throw new ExtendedIOException(this.path_, rc);
            }
        } else {
            Trace.log(2, "Unknown reply data stream", ds.data_);
            throw new InternalErrorException(Integer.toHexString(ds.getReqRepID()), 2);
        }
        IFSKey key = new IFSKey(this.fileHandle_, offset, length, true);
        return key;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int read(byte[] data, int dataOffset, int length) throws IOException, AS400SecurityException {
        if (length == 0) {
            return 0;
        }
        int totalBytesRead = 0;
        int bytesRemainingToRead = length;
        boolean endOfFile = false;
        while (true) {
            ClientAccessDataStream ds;
            IFSReadReq req;
            if (totalBytesRead < length && !endOfFile) {
                int bytesToReadThisTime = Math.min(bytesRemainingToRead, 16000000);
                req = new IFSReadReq(this.fileHandle_, this.fileOffset_, bytesToReadThisTime, this.serverDatastreamLevel_);
                ds = null;
                try {
                    ds = (ClientAccessDataStream)this.server_.sendAndReceive(req);
                }
                catch (ConnectionDroppedException e) {
                    Trace.log(2, "Byte stream server connection lost");
                    this.connectionDropped(e);
                }
                catch (InterruptedException e) {
                    Trace.log(2, "Interrupted", (Throwable)e);
                    InterruptedIOException throwException = new InterruptedIOException(e.getMessage());
                    throwException.initCause(e);
                    throw throwException;
                }
            } else {
                if (endOfFile && totalBytesRead == 0) {
                    return -1;
                }
                int n = totalBytesRead;
                return n;
            }
            boolean endOfChain = false;
            int bytesReadByThisRequest = 0;
            do {
                if (ds instanceof IFSReadRep) {
                    byte[] buffer = ((IFSReadRep)ds).getData();
                    if (buffer.length > 0) {
                        System.arraycopy(buffer, 0, data, dataOffset, buffer.length);
                        bytesReadByThisRequest += buffer.length;
                        dataOffset += buffer.length;
                    } else {
                        bytesReadByThisRequest = -1;
                        endOfFile = true;
                    }
                } else {
                    if (!(ds instanceof IFSReturnCodeRep)) {
                        Trace.log(2, "Unknown reply data stream", ds.data_);
                        throw new InternalErrorException(Integer.toHexString(ds.getReqRepID()), 2);
                    }
                    int rc = ((IFSReturnCodeRep)ds).getReturnCode();
                    if (rc != 0) {
                        if (rc != 22) {
                            IFSFileDescriptorImplRemote.throwSecurityExceptionIfAccessDenied(this.path_, rc);
                            Trace.log(2, "IFSReturnCodeRep return code", IFSFileDescriptorImplRemote.descriptionForReturnCode(rc));
                            throw new ExtendedIOException(this.path_, rc);
                        }
                        bytesReadByThisRequest = -1;
                        endOfFile = true;
                    }
                }
                endOfChain = ((IFSDataStream)ds).isEndOfChain();
                if (endOfChain) continue;
                try {
                    ds = (ClientAccessDataStream)this.server_.receive(req.getCorrelation());
                }
                catch (ConnectionDroppedException e) {
                    Trace.log(2, "Byte stream server connection lost");
                    this.connectionDropped(e);
                }
                catch (InterruptedException e) {
                    Trace.log(2, "Interrupted", (Throwable)e);
                    InterruptedIOException throwException = new InterruptedIOException(e.getMessage());
                    throwException.initCause(e);
                    throw throwException;
                }
            } while (!endOfChain);
            if (bytesReadByThisRequest <= 0) continue;
            this.incrementFileOffset(bytesReadByThisRequest);
            totalBytesRead += bytesReadByThisRequest;
            bytesRemainingToRead -= bytesReadByThisRequest;
        }
    }

    void setConverter(ConverterImplRemote converter) {
        this.converter_ = converter;
    }

    void setCCSID(int ccsid) throws IOException {
        this.fileDataCCSID_ = ccsid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFileOffset(long fileOffset) {
        Object object = this.fileOffsetLock_;
        synchronized (object) {
            this.fileOffset_ = fileOffset;
        }
    }

    boolean setLength(long length) throws IOException, AS400SecurityException {
        ClientAccessDataStream ds = null;
        int fileHandle = -1;
        try {
            fileHandle = this.createFileHandle(2, 8);
            if (fileHandle == -1) {
                if (Trace.traceOn_) {
                    Trace.log(2, "Unable to create handle to file " + this.path_ + ". IFSReturnCodeRep return code", this.errorRC_);
                }
                boolean bl = false;
                return bl;
            }
            IFSChangeAttrsReq req = new IFSChangeAttrsReq(fileHandle, length, this.serverDatastreamLevel_);
            ds = (ClientAccessDataStream)this.server_.sendAndReceive(req);
        }
        catch (ConnectionDroppedException e) {
            Trace.log(2, "Byte stream server connection lost.");
            this.connectionDropped(e);
        }
        catch (InterruptedException e) {
            Trace.log(2, "Interrupted");
            InterruptedIOException throwException = new InterruptedIOException(e.getMessage());
            throwException.initCause(e);
            throw throwException;
        }
        finally {
            this.close(fileHandle);
        }
        boolean success = false;
        if (ds instanceof IFSReturnCodeRep) {
            int rc = ((IFSReturnCodeRep)ds).getReturnCode();
            if (rc == 0) {
                success = true;
            } else {
                Trace.log(2, this.path_ + ": IFSReturnCodeRep return code", IFSFileDescriptorImplRemote.descriptionForReturnCode(rc));
                IFSFileDescriptorImplRemote.throwSecurityExceptionIfAccessDenied(this.path_, rc);
            }
        } else {
            Trace.log(2, "Unknown reply data stream", ds.data_);
            throw new InternalErrorException(Integer.toHexString(ds.getReqRepID()), 2);
        }
        if (this.fileOffset_ > length) {
            this.fileOffset_ = length;
        }
        return success;
    }

    void setOpen(boolean state, int fileHandle) {
        if (state) {
            if (fileHandle == -1) {
                Trace.log(2, "Called setOpen with invalid file handle: " + fileHandle);
                throw new InternalErrorException(10);
            }
            if (fileHandle != this.fileHandle_) {
                this.close();
            }
            this.fileHandle_ = fileHandle;
        }
        this.isOpen_ = state;
    }

    void setOpenAllowed(boolean state) {
        this.isOpenAllowed_ = state;
    }

    void setPreferredCCSID(int ccsid) {
        this.preferredServerCCSID_ = ccsid;
    }

    void setServer(AS400Server server) {
        this.server_ = server;
    }

    @Override
    public void sync() throws IOException {
        if (this.parent_ == null) {
            Trace.log(2, "IFSFileDescriptor.sync() was called when parent is null.");
        } else if (this.parent_ instanceof IFSRandomAccessFileImplRemote) {
            ((IFSRandomAccessFileImplRemote)this.parent_).flush();
        } else if (this.parent_ instanceof IFSFileOutputStreamImplRemote) {
            ((IFSFileOutputStreamImplRemote)this.parent_).flush();
        } else {
            Trace.log(4, "IFSFileDescriptor.sync() was called when parent is neither an IFSRandomAccessFile nor an IFSFileOutputStream.");
        }
    }

    private static final void throwSecurityExceptionIfAccessDenied(String path, int returnCode) throws AS400SecurityException {
        if (returnCode == 5 || returnCode == 13) {
            if (Trace.traceOn_) {
                Trace.log(1, "Access denied to file " + path + ". IFSReturnCodeRep return code", returnCode);
            }
            throw new AS400SecurityException(path, 1);
        }
    }

    void unlock(IFSKey key) throws IOException, AS400SecurityException {
        if (key.fileHandle_ != this.fileHandle_) {
            Trace.log(2, "Attempt to use IFSKey on different file stream.");
            throw new ExtendedIllegalArgumentException("key", 2);
        }
        ClientAccessDataStream ds = null;
        IFSUnlockBytesReq req = new IFSUnlockBytesReq(key.fileHandle_, key.offset_, key.length_, key.isMandatory_, this.serverDatastreamLevel_);
        try {
            ds = (ClientAccessDataStream)this.server_.sendAndReceive(req);
        }
        catch (ConnectionDroppedException e) {
            Trace.log(2, "Byte stream server connection lost");
            this.connectionDropped(e);
        }
        catch (InterruptedException e) {
            Trace.log(2, "Interrupted", (Throwable)e);
            InterruptedIOException throwException = new InterruptedIOException(e.getMessage());
            throwException.initCause(e);
            throw throwException;
        }
        if (ds instanceof IFSReturnCodeRep) {
            int rc = ((IFSReturnCodeRep)ds).getReturnCode();
            if (rc != 0) {
                IFSFileDescriptorImplRemote.throwSecurityExceptionIfAccessDenied(this.path_, rc);
                Trace.log(2, "IFSReturnCodeRep return code", IFSFileDescriptorImplRemote.descriptionForReturnCode(rc));
                throw new ExtendedIOException(this.path_, rc);
            }
        } else {
            Trace.log(2, "Unknown reply data stream", ds.data_);
            throw new InternalErrorException(Integer.toHexString(ds.getReqRepID()), 2);
        }
    }

    void writeBytes(byte[] data, int dataOffset, int length) throws IOException, AS400SecurityException {
        this.writeBytes(data, dataOffset, length, false);
    }

    void writeBytes(byte[] data, int dataOffset, int length, boolean forceToStorage) throws IOException, AS400SecurityException {
        while (length > 0) {
            int writeLength = length > this.maxDataBlockSize_ ? this.maxDataBlockSize_ : length;
            IFSWriteReq req = new IFSWriteReq(this.fileHandle_, this.fileOffset_, data, dataOffset, writeLength, 65535, forceToStorage, this.serverDatastreamLevel_);
            if (length - writeLength > 0) {
                req.setChainIndicator(1);
            }
            ClientAccessDataStream ds = null;
            try {
                ds = (ClientAccessDataStream)this.server_.sendAndReceive(req);
            }
            catch (ConnectionDroppedException e) {
                Trace.log(2, "Byte stream server connection lost");
                this.connectionDropped(e);
            }
            catch (InterruptedException e) {
                Trace.log(2, "Interrupted", (Throwable)e);
                InterruptedIOException throwException = new InterruptedIOException(e.getMessage());
                throwException.initCause(e);
                throw throwException;
            }
            if (ds instanceof IFSWriteRep) {
                IFSWriteRep rep = (IFSWriteRep)ds;
                int rc = rep.getReturnCode();
                if (rc != 0) {
                    Trace.log(2, "IFSWriteRep return code", rc);
                    throw new ExtendedIOException(this.path_, rc);
                }
                int lengthWritten = writeLength - rep.getLengthNotWritten();
                this.incrementFileOffset(lengthWritten);
                dataOffset += lengthWritten;
                length -= lengthWritten;
                if (lengthWritten == writeLength) continue;
                Trace.log(2, "Incomplete write.  Only " + Integer.toString(lengthWritten) + " bytes of a requested " + Integer.toString(writeLength) + " were written.");
                throw new ExtendedIOException(this.path_, 25);
            }
            if (ds instanceof IFSReturnCodeRep) {
                int rc = ((IFSReturnCodeRep)ds).getReturnCode();
                if (rc == 0) continue;
                IFSFileDescriptorImplRemote.throwSecurityExceptionIfAccessDenied(this.path_, rc);
                Trace.log(2, "IFSReturnCodeRep return code", IFSFileDescriptorImplRemote.descriptionForReturnCode(rc));
                throw new ExtendedIOException(this.path_, rc);
            }
            Trace.log(2, "Unknown reply data stream", ds.data_);
            throw new InternalErrorException(Integer.toHexString(ds.getReqRepID()), 2);
        }
    }

    public int getServerDatastreamLevel() {
        return this.serverDatastreamLevel_;
    }

    public void freeHandle(int objectHandle) throws IOException, AS400SecurityException {
        IFSFreeHandleReq req = new IFSFreeHandleReq(objectHandle);
        this.server_.send(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getASP() throws IOException, AS400SecurityException {
        block12: {
            if (this.fileAsp_ == -1) {
                ClientAccessDataStream ds = null;
                int rc = 0;
                this.connect();
                byte[] pathname = this.getConverter().stringToByteArray(this.path_);
                int userHandle = -1;
                int objectHandle = -1;
                try {
                    int n = userHandle = this.getSystem().getVRM() <= 460032 ? this.system_.createUserHandle() : 0;
                    if (userHandle == -1) {
                        break block12;
                    }
                    try {
                        IFSLookupReq req = new IFSLookupReq(pathname, this.preferredServerCCSID_, userHandle, 12, 0x100800, 0);
                        ds = (ClientAccessDataStream)this.server_.sendAndReceive(req);
                    }
                    catch (ConnectionDroppedException e) {
                        Trace.log(2, "Byte stream server connection lost.");
                        this.connectionDropped(e);
                    }
                    catch (InterruptedException e) {
                        Trace.log(2, "Interrupted");
                        InterruptedIOException throwException = new InterruptedIOException(e.getMessage());
                        throwException.initCause(e);
                        throw throwException;
                    }
                    rc = 0;
                    if (ds instanceof IFSLookupRep) {
                        objectHandle = ((IFSLookupRep)ds).getHandle();
                        this.retrieveAttributes(ds, objectHandle);
                        break block12;
                    }
                    if (ds instanceof IFSReturnCodeRep) {
                        rc = ((IFSReturnCodeRep)ds).getReturnCode();
                        if (rc != 0) {
                            Trace.log(2, "IFSReturnCodeRep return code", rc);
                        }
                        throw new ExtendedIOException(this.path_, rc);
                    }
                    Trace.log(2, "Unknown reply data stream", ds.getReqRepID());
                    throw new InternalErrorException(Integer.toHexString(ds.getReqRepID()), 2);
                }
                finally {
                    if (objectHandle != -1) {
                        this.freeHandle(objectHandle);
                    }
                }
            }
        }
        return this.fileAsp_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOwnerNameByUserHandle(boolean forceRetrieve) throws IOException, AS400SecurityException {
        block16: {
            Trace.log(3, "Owner Name " + (this.fileOwnerName_ == null ? "is null" : this.fileOwnerName_));
            if (forceRetrieve || this.fileOwnerName_ == null) {
                Trace.log(3, "force retrieve for Owner Name.");
                ClientAccessDataStream ds = null;
                int rc = 0;
                this.connect();
                byte[] pathname = this.getConverter().stringToByteArray(this.path_);
                int userHandle = -1;
                int objectHandle = -1;
                try {
                    int n = userHandle = this.getSystem().getVRM() <= 460032 ? this.system_.createUserHandle() : 0;
                    if (userHandle == -1) {
                        IFSListAttrsRep reply = this.listObjAttrs1(2048, 0);
                        if (reply != null) {
                            this.fileOwnerName_ = reply.getOwnerName(this.system_.getCcsid());
                        } else {
                            if (Trace.traceOn_) {
                                Trace.log(4, "getOwnerNameByUserHandle: IFSReturnCodeRep return code", this.errorRC_);
                            }
                            if (this.errorRC_ == 2 || this.errorRC_ == 3) {
                                throw new ExtendedIOException(this.path_, 3);
                            }
                        }
                        break block16;
                    }
                    try {
                        IFSLookupReq req = new IFSLookupReq(pathname, this.preferredServerCCSID_, userHandle, 12, 0x100800, 0);
                        ds = (ClientAccessDataStream)this.server_.sendAndReceive(req);
                    }
                    catch (ConnectionDroppedException e) {
                        Trace.log(2, "Byte stream server connection lost.");
                        this.connectionDropped(e);
                    }
                    catch (InterruptedException e) {
                        Trace.log(2, "Interrupted");
                        InterruptedIOException throwException = new InterruptedIOException(e.getMessage());
                        throwException.initCause(e);
                        throw throwException;
                    }
                    rc = 0;
                    if (ds instanceof IFSLookupRep) {
                        objectHandle = ((IFSLookupRep)ds).getHandle();
                        this.retrieveAttributes(ds, objectHandle);
                        break block16;
                    }
                    if (ds instanceof IFSReturnCodeRep) {
                        rc = ((IFSReturnCodeRep)ds).getReturnCode();
                        if (rc != 0) {
                            Trace.log(2, "IFSReturnCodeRep return code", rc);
                        }
                        throw new ExtendedIOException(this.path_, rc);
                    }
                    Trace.log(2, "Unknown reply data stream", ds.getReqRepID());
                    throw new InternalErrorException(Integer.toHexString(ds.getReqRepID()), 2);
                }
                finally {
                    if (objectHandle != -1) {
                        this.freeHandle(objectHandle);
                    }
                }
            }
        }
        return this.fileOwnerName_ == null ? "" : this.fileOwnerName_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFileSystemType() throws IOException, AS400SecurityException {
        String typeString;
        block26: {
            typeString = "Unknown";
            if (this.fileSystemType_ == -1) {
                ClientAccessDataStream ds = null;
                int rc = 0;
                this.connect();
                int objectHandle = -1;
                byte[] pathname = this.getConverter().stringToByteArray(this.path_);
                int userHandle = -1;
                try {
                    int n = userHandle = this.getSystem().getVRM() <= 460032 ? this.system_.createUserHandle() : 0;
                    if (userHandle == -1) {
                        break block26;
                    }
                    try {
                        IFSLookupReq req = new IFSLookupReq(pathname, this.preferredServerCCSID_, userHandle, 12, 0x100800, 0);
                        ds = (ClientAccessDataStream)this.server_.sendAndReceive(req);
                    }
                    catch (ConnectionDroppedException e) {
                        Trace.log(2, "Byte stream server connection lost.");
                        this.connectionDropped(e);
                    }
                    catch (InterruptedException e) {
                        Trace.log(2, "Interrupted");
                        InterruptedIOException throwException = new InterruptedIOException(e.getMessage());
                        throwException.initCause(e);
                        throw throwException;
                    }
                    rc = 0;
                    if (ds instanceof IFSLookupRep) {
                        objectHandle = ((IFSLookupRep)ds).getHandle();
                        this.retrieveAttributes(ds, objectHandle);
                        break block26;
                    }
                    if (ds instanceof IFSReturnCodeRep) {
                        rc = ((IFSReturnCodeRep)ds).getReturnCode();
                        if (rc != 0) {
                            Trace.log(2, "IFSReturnCodeRep return code", rc);
                        }
                        throw new ExtendedIOException(this.path_, rc);
                    }
                    Trace.log(2, "Unknown reply data stream", ds.getReqRepID());
                    throw new InternalErrorException(Integer.toHexString(ds.getReqRepID()), 2);
                }
                finally {
                    if (objectHandle != -1) {
                        this.freeHandle(objectHandle);
                    }
                }
            }
        }
        switch (this.fileSystemType_) {
            case 1: {
                typeString = "EPFS";
                break;
            }
            case 2: {
                typeString = "QDLS";
                break;
            }
            case 3: {
                typeString = "QSYS";
                break;
            }
            case 4: {
                typeString = "NFS";
                break;
            }
            case 5: {
                typeString = "LRFS";
                break;
            }
            case 6: {
                typeString = "QOPT";
                break;
            }
            case 7: {
                typeString = "QRFS";
                break;
            }
            case 9: {
                typeString = "EPFSP";
                break;
            }
            case 11: {
                typeString = "QNETC";
                break;
            }
            case 12: {
                typeString = "QDTL";
                break;
            }
            case 13: {
                typeString = "IEPFS";
                break;
            }
            case 14: {
                typeString = "ASPQSYS";
            }
        }
        return typeString;
    }

    private void retrieveAttributes(ClientAccessDataStream ds, int objectHandle) throws IOException, AS400SecurityException {
        this.fileAsp_ = ((IFSLookupRep)ds).getASP();
        if (this.fileAsp_ < 1) {
            this.fileAsp_ = -1;
        }
        this.fileOwnerName_ = ((IFSLookupRep)ds).getOwnerName(this.system_.getCcsid());
        this.fileDataCCSID_ = ((IFSLookupRep)ds).getCCSID(this.serverDatastreamLevel_);
        if (this.fileDataCCSID_ < 1) {
            this.fileDataCCSID_ = -1;
        }
        int userHandle = this.getSystem().getVRM() <= 460032 ? this.system_.getUserHandle() : 0;
        int rc = 0;
        ds = null;
        try {
            IFSGetFileSystemReq req = new IFSGetFileSystemReq(objectHandle, userHandle);
            ds = (ClientAccessDataStream)this.server_.sendAndReceive(req);
        }
        catch (ConnectionDroppedException e) {
            Trace.log(2, "Byte stream server connection lost.");
            this.connectionDropped(e);
        }
        catch (InterruptedException e) {
            Trace.log(2, "Interrupted");
            InterruptedIOException throwException = new InterruptedIOException(e.getMessage());
            throwException.initCause(e);
            throw throwException;
        }
        rc = 0;
        if (!(ds instanceof IFSGetFileSystemRep)) {
            if (ds instanceof IFSReturnCodeRep) {
                rc = ((IFSReturnCodeRep)ds).getReturnCode();
                if (rc != 0) {
                    Trace.log(2, "IFSReturnCodeRep return code", rc);
                }
                throw new ExtendedIOException(this.path_, rc);
            }
            Trace.log(2, "Unknown reply data stream", ds.getReqRepID());
            throw new InternalErrorException(2, Integer.toHexString(ds.getReqRepID()), null);
        }
        this.fileSystemType_ = ((IFSGetFileSystemRep)ds).getFileSystemType();
    }

    static {
        AS400Server.addReplyStream((DataStream)new IFSCloseRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSExchangeAttrRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSLockBytesRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSReturnCodeRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSWriteRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSReadRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSLookupRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSGetFileSystemRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSOpenRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSListAttrsRep(), 0);
    }
}

