/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.ObjectDescription;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class JobDescription
implements Serializable {
    static final long serialVersionUID = 4L;
    private static final int VRM520 = AS400.generateVRM(5, 2, 0);
    private static final int VRM530 = AS400.generateVRM(5, 3, 0);
    private static final int VRM540 = AS400.generateVRM(5, 4, 0);
    private int vrm_;
    private AS400 system_;
    private String name_;
    private String library_;
    private transient boolean loaded_;
    private static final ProgramParameter errorCode_ = new ProgramParameter(new byte[4]);
    private String jobDescriptionName_;
    private String jobDescriptionLibraryName_;
    private String userName_;
    private String[] initialLibraryList_;
    private String jobDate_;
    private String jobSwitches_;
    private String jobQueueName_;
    private String jobQueueLibraryName_;
    private String jobQueuePriority_;
    private String holdOnJobQueue_;
    private String outputQueueName_;
    private String outputQueueLibraryName_;
    private String outputQueuePriority_;
    private String printerDeviceName_;
    private String printText_;
    private int syntaxCheckSeverity_;
    private int endSeverity_;
    private int messageLoggingSeverity_;
    private String messageLoggingLevel_;
    private String messageLoggingText_;
    private String loggingOfCLPrograms_;
    private String inquiryMessageReply_;
    private String deviceRecoveryAction_;
    private String timeSliceEndPool_;
    private String accountingCode_;
    private String routingData_;
    private String textDescription_;
    private int jobMessageQueueMaximumSize_;
    private String jobMessageQueueFullAction_;
    private String CYMDJobDate_;
    private String allowMultipleThreads_;
    private String spooledFileAction_;
    private String[] iaspNames_;
    private String ddmConversation_;
    private String jobLogOutput_;
    private transient ObjectDescription objectDescription_;

    public JobDescription(AS400 system, String library, String name) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (library == null) {
            throw new NullPointerException("library");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.system_ = system;
        this.name_ = name;
        this.library_ = library;
    }

    public JobDescription(AS400 system, QSYSObjectPathName path) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (path == null) {
            throw new NullPointerException("path");
        }
        this.system_ = system;
        this.name_ = path.getObjectName();
        this.library_ = path.getLibraryName();
    }

    public void refresh() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, ObjectDoesNotExistException, IOException {
        int bytesAvailable;
        if (this.system_ == null) {
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.name_ == null) {
            throw new ExtendedIllegalStateException("name", 4);
        }
        if (this.library_ == null) {
            throw new ExtendedIllegalStateException("library", 4);
        }
        int ccsid = this.system_.getCcsid();
        ConvTable conv = ConvTable.getTable(ccsid, null);
        AS400Text text20 = new AS400Text(20, ccsid);
        StringBuilder qualifiedJobDName = new StringBuilder(20);
        qualifiedJobDName.append(this.name_);
        for (int i = 0; i < 10 - this.name_.length(); ++i) {
            qualifiedJobDName.append(" ");
        }
        qualifiedJobDName.append(this.library_);
        ProgramParameter[] parms = new ProgramParameter[5];
        int len = 2048;
        parms[0] = new ProgramParameter(len);
        parms[1] = new ProgramParameter(BinaryConverter.intToByteArray(len));
        parms[2] = new ProgramParameter(conv.stringToByteArray("JOBD0100"));
        parms[3] = new ProgramParameter(text20.toBytes(qualifiedJobDName.toString().trim().toUpperCase()));
        parms[4] = errorCode_;
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QWDRJOBD.PGM", parms);
        if (!pc.run()) {
            throw new AS400Exception(pc.getMessageList());
        }
        byte[] data = parms[0].getOutputData();
        int bytesReturned = BinaryConverter.byteArrayToInt(data, 0);
        if (bytesReturned < (bytesAvailable = BinaryConverter.byteArrayToInt(data, 4))) {
            if (Trace.traceOn_) {
                Trace.log(1, "JobDescription: Not enough bytes, trying again. Bytes returned = " + bytesReturned + "; bytes available = " + bytesAvailable);
            }
            len = bytesAvailable;
            try {
                parms[0].setOutputDataLength(len);
                parms[1].setInputData(BinaryConverter.intToByteArray(len));
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            if (!pc.run()) {
                throw new AS400Exception(pc.getMessageList());
            }
            data = parms[0].getOutputData();
        }
        this.jobDescriptionName_ = conv.byteArrayToString(data, 8, 10).trim();
        this.jobDescriptionLibraryName_ = conv.byteArrayToString(data, 18, 10).trim();
        this.userName_ = conv.byteArrayToString(data, 28, 10).trim();
        this.jobDate_ = conv.byteArrayToString(data, 38, 8).trim();
        this.jobSwitches_ = conv.byteArrayToString(data, 46, 8).trim();
        this.jobQueueName_ = conv.byteArrayToString(data, 54, 10).trim();
        this.jobQueueLibraryName_ = conv.byteArrayToString(data, 64, 10).trim();
        this.jobQueuePriority_ = conv.byteArrayToString(data, 74, 2).trim();
        this.holdOnJobQueue_ = conv.byteArrayToString(data, 76, 10).trim();
        this.outputQueueName_ = conv.byteArrayToString(data, 86, 10).trim();
        this.outputQueueLibraryName_ = conv.byteArrayToString(data, 96, 10).trim();
        this.outputQueuePriority_ = conv.byteArrayToString(data, 106, 2).trim();
        this.printerDeviceName_ = conv.byteArrayToString(data, 108, 10).trim();
        this.printText_ = conv.byteArrayToString(data, 118, 30).trim();
        this.syntaxCheckSeverity_ = BinaryConverter.byteArrayToInt(data, 148);
        this.endSeverity_ = BinaryConverter.byteArrayToInt(data, 152);
        this.messageLoggingSeverity_ = BinaryConverter.byteArrayToInt(data, 156);
        this.messageLoggingLevel_ = conv.byteArrayToString(data, 160, 1).trim();
        this.messageLoggingText_ = conv.byteArrayToString(data, 161, 10).trim();
        this.loggingOfCLPrograms_ = conv.byteArrayToString(data, 171, 10).trim();
        this.inquiryMessageReply_ = conv.byteArrayToString(data, 181, 10).trim();
        this.deviceRecoveryAction_ = conv.byteArrayToString(data, 191, 13).trim();
        this.timeSliceEndPool_ = conv.byteArrayToString(data, 204, 10).trim();
        this.accountingCode_ = conv.byteArrayToString(data, 214, 15).trim();
        this.routingData_ = conv.byteArrayToString(data, 229, 80).trim();
        this.textDescription_ = conv.byteArrayToString(data, 309, 50).trim();
        this.jobMessageQueueMaximumSize_ = BinaryConverter.byteArrayToInt(data, 376);
        this.jobMessageQueueFullAction_ = conv.byteArrayToString(data, 380, 10).trim();
        this.CYMDJobDate_ = conv.byteArrayToString(data, 390, 10).trim();
        this.allowMultipleThreads_ = conv.byteArrayToString(data, 400, 10).trim();
        int initialLibraryListCount = BinaryConverter.byteArrayToInt(data, 364);
        this.initialLibraryList_ = new String[initialLibraryListCount];
        int initialLibraryListOffset = BinaryConverter.byteArrayToInt(data, 360);
        for (int i = 0; i < initialLibraryListCount; ++i) {
            this.initialLibraryList_[i] = conv.byteArrayToString(data, initialLibraryListOffset + i * 11, 10).trim();
        }
        if (this.vrm_ == 0) {
            this.vrm_ = this.system_.getVRM();
        }
        if (this.vrm_ >= VRM520) {
            this.spooledFileAction_ = conv.byteArrayToString(data, 410, 10).trim();
            int iaspOffset = BinaryConverter.byteArrayToInt(data, 420);
            int iaspCount = BinaryConverter.byteArrayToInt(data, 424);
            int iaspLength = BinaryConverter.byteArrayToInt(data, 428);
            this.iaspNames_ = new String[iaspCount];
            for (int i = 0; i < iaspCount; ++i) {
                int offset = iaspOffset + i * iaspLength;
                this.iaspNames_[i] = conv.byteArrayToString(data, offset, 10).trim();
            }
        }
        if (this.vrm_ >= VRM530) {
            this.ddmConversation_ = conv.byteArrayToString(data, 432, 10).trim();
        }
        if (this.vrm_ >= VRM540) {
            this.jobLogOutput_ = conv.byteArrayToString(data, 442, 10).trim();
        }
        this.loaded_ = true;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.loaded_ = false;
    }

    private void loadInformation() throws RuntimeException {
        try {
            this.refresh();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            Trace.log(2, "Exception rethrown by loadInformation():", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    public String getAccountingCode() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.accountingCode_;
    }

    public boolean isAllowMultipleThreads() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.allowMultipleThreads_.equals("*YES");
    }

    public String getCYMDJobDate() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.CYMDJobDate_;
    }

    public String getDeviceRecoveryAction() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.deviceRecoveryAction_;
    }

    public String getDDMConversation() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.ddmConversation_;
    }

    public int getEndSeverity() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.endSeverity_;
    }

    public boolean isHoldOnJobQueue() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.holdOnJobQueue_.equals("*YES");
    }

    public String[] getInitialLibraryList() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.initialLibraryList_;
    }

    public String getInquiryMessageReply() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.inquiryMessageReply_;
    }

    public String[] getInitialASPGroupNames() {
        return this.iaspNames_;
    }

    public String getJobDateString() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.jobDate_;
    }

    public String getLibraryName() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.jobDescriptionLibraryName_;
    }

    public String getName() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.jobDescriptionName_;
    }

    public String getJobLogOutput() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.jobLogOutput_;
    }

    public String getJobMessageQueueFullAction() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.jobMessageQueueFullAction_;
    }

    public int getJobMessageQueueMaximumSize() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.jobMessageQueueMaximumSize_;
    }

    public String getJobQueueLibraryName() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.jobQueueLibraryName_;
    }

    public String getJobQueueName() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.jobQueueName_;
    }

    public int getJobQueuePriority() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        try {
            return Integer.parseInt(this.jobQueuePriority_);
        }
        catch (NumberFormatException e) {
            Trace.log(2, "Exception swallowed by getJobQueuePriority():", (Throwable)e);
            return 9;
        }
    }

    public byte getJobSwitches() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        byte bitmap = 0;
        for (int i = 0; i < 8; ++i) {
            if (this.jobSwitches_.charAt(i) != '1') continue;
            bitmap = (byte)(bitmap | 1 << 7 - i);
        }
        return bitmap;
    }

    public boolean isLoggingOfCLPrograms() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.loggingOfCLPrograms_.equals("*YES");
    }

    public int getMessageLoggingLevel() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        try {
            return Integer.parseInt(this.messageLoggingLevel_);
        }
        catch (NumberFormatException e) {
            Trace.log(2, "Exception swallowed by getMessageLoggingLevel():", (Throwable)e);
            return 0;
        }
    }

    public int getMessageLoggingSeverity() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.messageLoggingSeverity_;
    }

    public String getMessageLoggingText() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.messageLoggingText_;
    }

    public String getOutputQueueLibraryName() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.outputQueueLibraryName_;
    }

    public String getOutputQueueName() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.outputQueueName_;
    }

    public int getOutputQueuePriority() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        try {
            return Integer.parseInt(this.outputQueuePriority_);
        }
        catch (NumberFormatException e) {
            Trace.log(2, "Exception swallowed by getOutputQueuePriority():", (Throwable)e);
            return 9;
        }
    }

    public String getPrinterDeviceName() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.printerDeviceName_;
    }

    public String getPrintText() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.printText_;
    }

    public String getRoutingData() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.routingData_;
    }

    public String getSpooledFileAction() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.spooledFileAction_;
    }

    public int getSyntaxCheckSeverity() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.syntaxCheckSeverity_;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public String getTextDescription() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.textDescription_;
    }

    public String getTimeSliceEndPool() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.timeSliceEndPool_;
    }

    public String getUserName() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.userName_;
    }

    public void setLibraryName(String library) {
        if (library == null) {
            throw new NullPointerException("library");
        }
        if (this.loaded_) {
            throw new ExtendedIllegalStateException("library", 5);
        }
        this.library_ = library;
    }

    public void setName(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (this.loaded_) {
            throw new ExtendedIllegalStateException("name", 5);
        }
        this.name_ = name;
    }

    public void setSystem(AS400 system) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (this.loaded_) {
            throw new ExtendedIllegalStateException("system", 5);
        }
        this.system_ = system;
        this.vrm_ = 0;
    }

    public boolean exists() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.objectDescription_ == null) {
            this.objectDescription_ = this.getObjDesc();
        }
        return this.objectDescription_.exists();
    }

    public ObjectDescription getObjectDescription() {
        if (this.objectDescription_ == null) {
            this.objectDescription_ = this.getObjDesc();
        }
        return this.objectDescription_;
    }

    private ObjectDescription getObjDesc() {
        return new ObjectDescription(this.system_, this.library_, this.name_, "JOBD");
    }
}

