/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.MessageFile;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.ibm.as400.resource.BooleanValueMap;
import com.ibm.as400.resource.DateValueMap;
import com.ibm.as400.resource.IntegerValueMap;
import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.PresentationLoader;
import com.ibm.as400.resource.ProgramMap;
import com.ibm.as400.resource.QualifiedValueMap;
import com.ibm.as400.resource.RQueuedMessage;
import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceMetaDataTable;
import com.ibm.as400.resource.SubstringValueMap;
import com.ibm.as400.resource.SystemResourceList;
import java.beans.PropertyVetoException;
import java.io.UnsupportedEncodingException;

public class RMessageQueue
extends SystemResourceList {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static final String PRESENTATION_KEY_ = "MESSAGE_QUEUE";
    private static final String ICON_BASE_NAME_ = "RMessageQueue";
    private static PresentationLoader presentationLoader_;
    public static final String ALL = "*ALL";
    public static final String ANY = "*ANY";
    public static final String BYKEY = "*BYKEY";
    public static final String COMPLETION = "*COMP";
    public static final String COPY = "*COPY";
    public static final String CURRENT = "*CURRENT";
    public static final String DIAGNOSTIC = "*DIAG";
    public static final String FIRST = "*FIRST";
    public static final String INFORMATIONAL = "*INFO";
    public static final String INQUIRY = "*INQ";
    public static final String KEEP_UNANSWERED = "*KEEPUNANS";
    public static final String LAST = "*LAST";
    public static final String MESSAGES_NEED_REPLY = "*MNR";
    public static final String MESSAGES_NO_NEED_REPLY = "*MNNR";
    public static final String NEW = "*NEW";
    public static final byte[] NEWEST;
    public static final String NEXT = "*NEXT";
    public static final String OLD = "*OLD";
    public static final byte[] OLDEST;
    public static final String PREVIOUS = "*PRV";
    public static final String REMOVE = "*REMOVE";
    public static final String REPLY = "*RPY";
    public static final String SAME = "*SAME";
    public static final String SENDERS_COPY_NEED_REPLY = "*SCNR";
    public static final Integer NO_FORMATTING;
    public static final Integer RETURN_FORMATTING_CHARACTERS;
    public static final Integer SUBSTITUTE_FORMATTING_CHARACTERS;
    private static ResourceMetaDataTable selections_;
    private static ProgramMap selectionMap_;
    public static final String FORMATTING_CHARACTERS = "FORMATTING_CHARACTERS";
    public static final String LIST_DIRECTION = "LIST_DIRECTION";
    public static final String REPLACEMENT_DATA = "REPLACEMENT_DATA";
    public static final String SELECTION_CRITERIA = "SELECTION_CRITERIA";
    public static final String SEVERITY_CRITERIA = "SEVERITY_CRITERIA";
    public static final String SORT_CRITERIA = "SORT_CRITERIA";
    public static final String STARTING_USER_MESSAGE_KEY = "STARTING_USER_MESSAGE_KEY";
    public static final String STARTING_WORKSTATION_MESSAGE_KEY = "STARTING_WORKSTATION_MESSAGE_KEY";
    private static ProgramMap openListAttributeMap_;
    private static final String openListProgramName_ = "qgyolmsg";
    private static final String receiveProgramName_ = "qmhrcvm";
    private static ProgramMap receiveAttributeMap_;
    private static final String DOCUMENT_NAME_ = "com.ibm.as400.resource.RMessageQueue";
    private static final String messageFieldIdentifier_ = "qgyolmsg.messageSelectionInformation.messageFieldIdentifier";
    private static final String messageHelpFieldIdentifier_ = "qgyolmsg.messageSelectionInformation.messageHelpFieldIdentifier";
    private static ProgramCallDocument staticDocument_;
    private static final byte[] BLANK_KEY;
    private static final String QUSRSYS = "QUSRSYS";
    private ProgramCallDocument document_ = null;
    private String path_ = null;

    public RMessageQueue() {
        super(presentationLoader_.getPresentationWithIcon(PRESENTATION_KEY_, ICON_BASE_NAME_), RQueuedMessage.attributes_, selections_, null, openListProgramName_, null, selectionMap_);
        try {
            this.setPath(CURRENT);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public RMessageQueue(AS400 system) {
        this();
        try {
            this.setSystem(system);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public RMessageQueue(AS400 system, String path) {
        this();
        try {
            this.setSystem(system);
            this.setPath(path);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    @Override
    protected void establishConnection() throws ResourceException {
        block3: {
            if (this.path_ == null) {
                throw new ExtendedIllegalStateException("path", 4);
            }
            super.establishConnection();
            this.document_ = (ProgramCallDocument)staticDocument_.clone();
            this.setDocument(this.document_);
            try {
                this.document_.setValue("qgyolmsg.userOrQueueInformation.userOrQueueIndicator", this.path_.equals(CURRENT) ? "0" : "1");
                this.formatQualifiedMessageQueueName(this.document_, "qgyolmsg.userOrQueueInformation.userOrQueueName");
            }
            catch (PcmlException e) {
                if (!Trace.isTraceOn()) break block3;
                Trace.log(2, "Error setting path information in PCML document", (Throwable)e);
            }
        }
    }

    private void formatQualifiedMessageQueueName(ProgramCallDocument document, String name) throws PcmlException {
        if (this.path_.equals(CURRENT)) {
            AS400 system = this.getSystem();
            if (system != null) {
                String userId = system.getUserId();
                document.setValue(name + ".objectName", userId);
                document.setValue(name + ".libraryName", QUSRSYS);
            }
        } else {
            QSYSObjectPathName fullPath = new QSYSObjectPathName(this.path_);
            document.setValue(name + ".objectName", fullPath.getObjectName());
            document.setValue(name + ".libraryName", fullPath.getLibraryName());
        }
    }

    public String getPath() {
        return this.path_;
    }

    public RQueuedMessage receive(byte[] messageKey) throws ResourceException {
        return this.receive(messageKey, 0, REMOVE, ANY);
    }

    public RQueuedMessage receive(byte[] messageKey, int waitTime, String messageAction, String messageType) throws ResourceException {
        if (messageAction == null) {
            throw new NullPointerException("messageAction");
        }
        if (!(messageAction.equals(OLD) || messageAction.equals(REMOVE) || messageAction.equals(SAME))) {
            throw new ExtendedIllegalArgumentException("messageAction", 2);
        }
        if (messageType == null) {
            throw new NullPointerException("messageType");
        }
        if (!(messageType.equals(ANY) || messageType.equals(COMPLETION) || messageType.equals(COPY) || messageType.equals(DIAGNOSTIC) || messageType.equals(FIRST) || messageType.equals(INFORMATIONAL) || messageType.equals(INQUIRY) || messageType.equals(LAST) || messageType.equals(NEXT) || messageType.equals(PREVIOUS) || messageType.equals(REPLY))) {
            throw new ExtendedIllegalArgumentException("messageType", 2);
        }
        if ((messageType.equals(COPY) || messageType.equals(NEXT) || messageType.equals(PREVIOUS)) && messageKey == null) {
            throw new ExtendedIllegalArgumentException("messageKey", 2);
        }
        if ((messageType.equals(FIRST) || messageType.equals(LAST)) && messageKey != null) {
            throw new ExtendedIllegalArgumentException("messageKey", 2);
        }
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        try {
            this.formatQualifiedMessageQueueName(this.document_, "qmhrcvm.qualifiedMessageQueueName");
            this.document_.setValue("qmhrcvm.messageType", messageType);
            this.document_.setValue("qmhrcvm.messageKey", messageKey == null ? BLANK_KEY : messageKey);
            this.document_.setIntValue("qmhrcvm.waitTime", waitTime);
            this.document_.setValue("qmhrcvm.messageAction", messageAction);
            if (!this.document_.callProgram(receiveProgramName_)) {
                throw new ResourceException(this.document_.getMessageList(receiveProgramName_));
            }
            if (this.document_.getIntValue("qmhrcvm.messageInformation.bytesReturned") <= 8) {
                if (Trace.isTraceOn()) {
                    Trace.log(3, "Queued message can not be received.");
                }
                return null;
            }
            AS400 system = this.getSystem();
            RQueuedMessage rQueuedMessage = new RQueuedMessage();
            try {
                rQueuedMessage.setSystem(system);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            Object[] attributeIDs = receiveAttributeMap_.getIDs();
            Object[] values = receiveAttributeMap_.getValues(attributeIDs, system, this.document_, receiveProgramName_, null);
            for (int j = 0; j < values.length; ++j) {
                rQueuedMessage.initializeAttributeValue(attributeIDs[j], values[j]);
            }
            String messageText = (String)this.document_.getValue("qmhrcvm.messageInformation.message");
            byte[] substitutionData = (byte[])this.document_.getValue("qmhrcvm.messageInformation.replacementDataOrImpromptuText");
            if (((String)rQueuedMessage.getAttributeValue("MESSAGE_ID")).length() > 0) {
                rQueuedMessage.initializeAttributeValue("MESSAGE_TEXT", messageText);
                rQueuedMessage.initializeAttributeValue("SUBSTITUTION_DATA", substitutionData);
            } else {
                CharConverter converter = new CharConverter(system.getCcsid(), system);
                rQueuedMessage.initializeAttributeValue("MESSAGE_TEXT", converter.byteArrayToString(substitutionData));
                rQueuedMessage.initializeAttributeValue("SUBSTITUTION_DATA", substitutionData);
            }
            Object resourceKey = RQueuedMessage.computeResourceKey(system, this.path_, (byte[])rQueuedMessage.getAttributeValue("MESSAGE_KEY"));
            rQueuedMessage.setResourceKey(resourceKey);
            return rQueuedMessage;
        }
        catch (PcmlException e) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Error when receiving message", (Throwable)e);
            }
            throw new ResourceException(e);
        }
        catch (UnsupportedEncodingException e) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Error when receiving message", (Throwable)e);
            }
            throw new ResourceException(e);
        }
    }

    public void remove() throws ResourceException {
        this.remove(BLANK_KEY, ALL);
    }

    public void remove(byte[] messageKey) throws ResourceException {
        this.remove(messageKey, BYKEY);
    }

    public void remove(String messageType) throws ResourceException {
        this.remove(BLANK_KEY, messageType);
    }

    void remove(byte[] messageKey, String messageType) throws ResourceException {
        if (messageKey == null) {
            throw new NullPointerException("messageKey");
        }
        if (messageType == null) {
            throw new NullPointerException("messageType");
        }
        if (!(messageType.equals(ALL) || messageType.equals(BYKEY) || messageType.equals(KEEP_UNANSWERED) || messageType.equals(NEW) || messageType.equals(OLD))) {
            throw new ExtendedIllegalArgumentException("messageType", 2);
        }
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        try {
            this.formatQualifiedMessageQueueName(this.document_, "qmhrmvm.qualifiedMessageQueueName");
            this.document_.setValue("qmhrmvm.messageKey", messageKey);
            this.document_.setValue("qmhrmvm.messagesToRemove", messageType);
            if (!this.document_.callProgram("qmhrmvm")) {
                throw new ResourceException(this.document_.getMessageList("qmhrmvm"));
            }
        }
        catch (PcmlException e) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Error when removing message", (Throwable)e);
            }
            throw new ResourceException(e);
        }
    }

    public void reply(byte[] messageKey, String replyText) throws ResourceException {
        this.reply(messageKey, replyText, true);
    }

    public void reply(byte[] messageKey, String replyText, boolean remove) throws ResourceException {
        if (messageKey == null) {
            throw new NullPointerException("messageKey");
        }
        if (replyText == null) {
            throw new NullPointerException("replyText");
        }
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        try {
            this.document_.setValue("qmhsndrm.messageKey", messageKey);
            this.formatQualifiedMessageQueueName(this.document_, "qmhsndrm.qualifiedMessageQueueName");
            byte[] asBytes = CharConverter.stringToByteArray(this.getSystem(), replyText);
            this.document_.setIntValue("qmhsndrm.lengthOfReplyText", asBytes.length);
            this.document_.setValue("qmhsndrm.replyText", asBytes);
            this.document_.setValue("qmhsndrm.removeMessage", remove ? "*YES" : "*NO");
            if (!this.document_.callProgram("qmhsndrm")) {
                throw new ResourceException(this.document_.getMessageList("qmhsndrm"));
            }
        }
        catch (PcmlException e) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Error when replying to message", (Throwable)e);
            }
            throw new ResourceException(e);
        }
    }

    private byte[] send(String messageID, String messageFile, Object substitutionData, String messageType, String replyMessageQueue) throws ResourceException {
        if (messageID == null) {
            throw new NullPointerException("messageID");
        }
        if (messageFile == null) {
            throw new NullPointerException("messageFile");
        }
        if (substitutionData != null && !(substitutionData instanceof byte[]) && !(substitutionData instanceof String)) {
            throw new ExtendedIllegalArgumentException("substitutionData", 2);
        }
        if (messageType == null) {
            throw new NullPointerException("messageType");
        }
        if (!messageType.equals(INFORMATIONAL) && !messageType.equals(INQUIRY)) {
            throw new ExtendedIllegalArgumentException("messageType", 2);
        }
        if (replyMessageQueue == null) {
            throw new NullPointerException("replyQueue");
        }
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        try {
            String programName;
            if (substitutionData != null) {
                if (substitutionData instanceof byte[]) {
                    programName = "qmhsndmWithMessageData";
                    this.document_.setIntValue(programName + ".lengthOfMessageData", ((byte[])substitutionData).length);
                    this.document_.setValue(programName + ".messageData", substitutionData);
                } else {
                    programName = "qmhsndmWithImmediateText";
                    byte[] asBytes = CharConverter.stringToByteArray(this.getSystem(), (String)substitutionData);
                    this.document_.setIntValue(programName + ".lengthOfImmediateText", asBytes.length);
                    this.document_.setValue(programName + ".immediateText", asBytes);
                }
            } else {
                programName = "qmhsndmWithImmediateText";
                this.document_.setIntValue(programName + ".lengthOfImmediateText", 0);
                this.document_.setValue(programName + ".immediateText", new byte[0]);
            }
            this.document_.setValue(programName + ".messageID", messageID);
            if (messageFile.length() > 0) {
                QSYSObjectPathName messageFilePathName = new QSYSObjectPathName(messageFile);
                this.document_.setValue(programName + ".qualifiedMessageFileName.objectName", messageFilePathName.getObjectName());
                this.document_.setValue(programName + ".qualifiedMessageFileName.libraryName", messageFilePathName.getLibraryName());
            } else {
                this.document_.setValue(programName + ".qualifiedMessageFileName.objectName", "");
                this.document_.setValue(programName + ".qualifiedMessageFileName.libraryName", "");
            }
            this.document_.setValue(programName + ".messageType", messageType);
            this.formatQualifiedMessageQueueName(this.document_, programName + ".qualifiedMessageQueueNames");
            if (replyMessageQueue.length() > 0) {
                QSYSObjectPathName replyMessageQueuePathName = new QSYSObjectPathName(replyMessageQueue);
                this.document_.setValue(programName + ".qualifiedReplyMessageQueueName.objectName", replyMessageQueuePathName.getObjectName());
                this.document_.setValue(programName + ".qualifiedReplyMessageQueueName.libraryName", replyMessageQueuePathName.getLibraryName());
            } else {
                this.document_.setValue(programName + ".qualifiedReplyMessageQueueName.objectName", "");
                this.document_.setValue(programName + ".qualifiedReplyMessageQueueName.libraryName", "");
            }
            if (!this.document_.callProgram(programName)) {
                throw new ResourceException(this.document_.getMessageList(programName));
            }
            byte[] messageKey = null;
            if (messageType.equals(INQUIRY)) {
                messageKey = (byte[])this.document_.getValue(programName + ".messageKey");
            }
            return messageKey;
        }
        catch (PcmlException e) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Error when sending a message", (Throwable)e);
            }
            throw new ResourceException(e);
        }
    }

    public void sendInformational(String messageID, String messageFile) throws ResourceException {
        this.send(messageID, messageFile, null, INFORMATIONAL, "");
    }

    public void sendInformational(String messageID, String messageFile, byte[] substitutionData) throws ResourceException {
        this.send(messageID, messageFile, substitutionData, INFORMATIONAL, "");
    }

    public void sendInformational(String messageText) throws ResourceException {
        if (messageText == null) {
            throw new NullPointerException("messageText");
        }
        this.send("", "", messageText, INFORMATIONAL, "");
    }

    public byte[] sendInquiry(String messageID, String messageFile, String replyMessageQueue) throws ResourceException {
        return this.send(messageID, messageFile, null, INQUIRY, replyMessageQueue);
    }

    public byte[] sendInquiry(String messageID, String messageFile, byte[] substitutionData, String replyMessageQueue) throws ResourceException {
        return this.send(messageID, messageFile, substitutionData, INQUIRY, replyMessageQueue);
    }

    public byte[] sendInquiry(String messageText, String replyMessageQueue) throws ResourceException {
        if (messageText == null) {
            throw new NullPointerException("messageText");
        }
        return this.send("", "", messageText, INQUIRY, replyMessageQueue);
    }

    public void setPath(String path) throws PropertyVetoException {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (this.arePropertiesFrozen()) {
            throw new ExtendedIllegalStateException("propertiesFrozen", 5);
        }
        String oldValue = this.path_;
        this.fireVetoableChange("path", oldValue, path);
        this.path_ = path.trim();
        Presentation presentation = this.getPresentation();
        if (this.path_.equals(CURRENT)) {
            presentation.setName(CURRENT);
        } else {
            QSYSObjectPathName fullPath = new QSYSObjectPathName(this.path_);
            presentation.setName(fullPath.getObjectName());
            presentation.setFullName(fullPath.getPath());
        }
        this.firePropertyChange("path", oldValue, path);
    }

    @Override
    void setOpenParameters(ProgramCallDocument document) throws PcmlException, ResourceException {
        super.setOpenParameters(document);
        boolean replacementData = (Boolean)this.getSelectionValue(REPLACEMENT_DATA);
        Integer formattingCharacters = (Integer)this.getSelectionValue(FORMATTING_CHARACTERS);
        if (replacementData) {
            document.setIntValue(messageFieldIdentifier_, 302);
            if (formattingCharacters.equals(NO_FORMATTING)) {
                document.setIntValue(messageHelpFieldIdentifier_, 402);
            } else {
                document.setIntValue(messageHelpFieldIdentifier_, 404);
            }
        } else {
            document.setIntValue(messageFieldIdentifier_, 301);
            if (formattingCharacters.equals(NO_FORMATTING)) {
                document.setIntValue(messageHelpFieldIdentifier_, 401);
            } else {
                document.setIntValue(messageHelpFieldIdentifier_, 403);
            }
        }
    }

    @Override
    Resource newResource(String programName, int[] indices) throws PcmlException, ResourceException {
        AS400 system = this.getSystem();
        byte[] messageKey = (byte[])this.document_.getValue(programName + ".receiverVariable.messageKey", indices);
        Object resourceKey = RQueuedMessage.computeResourceKey(system, this.path_, messageKey);
        RQueuedMessage rQueuedMessage = new RQueuedMessage();
        try {
            rQueuedMessage.setSystem(system);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        rQueuedMessage.setResourceKey(resourceKey);
        Object[] attributeIDs = openListAttributeMap_.getIDs();
        Object[] values = openListAttributeMap_.getValues(attributeIDs, system, this.document_, programName, indices);
        for (int i = 0; i < values.length; ++i) {
            rQueuedMessage.initializeAttributeValue(attributeIDs[i], values[i]);
        }
        Integer formattingCharacters = (Integer)this.getSelectionValue(FORMATTING_CHARACTERS);
        if (formattingCharacters.equals(SUBSTITUTE_FORMATTING_CHARACTERS)) {
            String messageHelp = (String)rQueuedMessage.getAttributeValue("MESSAGE_HELP");
            messageHelp = MessageFile.substituteFormattingCharacters(messageHelp);
            rQueuedMessage.initializeAttributeValue("MESSAGE_HELP", messageHelp);
        }
        StringBuilder name = new StringBuilder();
        name.append((String)rQueuedMessage.getAttributeValue("MESSAGE_ID"));
        name.append('(');
        name.append(Presentation.bytesToHex((byte[])rQueuedMessage.getAttributeValue("MESSAGE_KEY")));
        name.append(')');
        StringBuilder fullName = new StringBuilder();
        fullName.append(this.path_);
        fullName.append('-');
        fullName.append(name.toString());
        Presentation presentation = rQueuedMessage.getPresentation();
        presentation.setName(name.toString());
        presentation.setFullName(fullName.toString());
        presentation.setValue("Description Text", rQueuedMessage.getAttributeValue("MESSAGE_TEXT"));
        presentation.setValue("Help Text", rQueuedMessage.getAttributeValue("MESSAGE_HELP"));
        return rQueuedMessage;
    }

    static {
        block2: {
            presentationLoader_ = new PresentationLoader("com.ibm.as400.resource.ResourceMRI");
            NEWEST = new byte[]{-1, -1, -1, -1};
            OLDEST = new byte[]{0, 0, 0, 0};
            NO_FORMATTING = 0;
            RETURN_FORMATTING_CHARACTERS = 1;
            SUBSTITUTE_FORMATTING_CHARACTERS = 2;
            selections_ = new ResourceMetaDataTable(presentationLoader_, PRESENTATION_KEY_);
            selectionMap_ = new ProgramMap();
            selections_.add(FORMATTING_CHARACTERS, Integer.class, false, new Integer[]{NO_FORMATTING, RETURN_FORMATTING_CHARACTERS, SUBSTITUTE_FORMATTING_CHARACTERS}, NO_FORMATTING, true);
            selections_.add(LIST_DIRECTION, String.class, false, new String[]{NEXT, PREVIOUS}, NEXT, true);
            selectionMap_.add(LIST_DIRECTION, null, "messageSelectionInformation.listDirection");
            selections_.add(REPLACEMENT_DATA, Boolean.class, false, null, Boolean.TRUE, false);
            selections_.add(SELECTION_CRITERIA, String.class, false, new String[]{ALL, MESSAGES_NEED_REPLY, SENDERS_COPY_NEED_REPLY, MESSAGES_NO_NEED_REPLY}, ALL, true);
            selectionMap_.add(SELECTION_CRITERIA, null, "messageSelectionInformation.selectionCriteria");
            selections_.add(SEVERITY_CRITERIA, Integer.class, false, null, 0, false);
            selectionMap_.add(SEVERITY_CRITERIA, null, "messageSelectionInformation.severityCriteria");
            selections_.add(SORT_CRITERIA, Boolean.class, false, null, Boolean.FALSE, false);
            selectionMap_.add((Object)SORT_CRITERIA, null, "sortInformation", new BooleanValueMap("0", "1"));
            selections_.add(STARTING_USER_MESSAGE_KEY, byte[].class, false, (Object[])new byte[][]{NEWEST, OLDEST}, OLDEST, false);
            selectionMap_.add((Object)STARTING_USER_MESSAGE_KEY, null, "messageSelectionInformation.startingMessageKeys", new int[]{0});
            selections_.add(STARTING_WORKSTATION_MESSAGE_KEY, byte[].class, false, (Object[])new byte[][]{NEWEST, OLDEST}, OLDEST, false);
            selectionMap_.add((Object)STARTING_WORKSTATION_MESSAGE_KEY, null, "messageSelectionInformation.startingMessageKeys", new int[]{1});
            openListAttributeMap_ = new ProgramMap();
            openListAttributeMap_.add("MESSAGE_SEVERITY", null, "receiverVariable.messageSeverity");
            openListAttributeMap_.add("MESSAGE_ID", null, "receiverVariable.messageIdentifier");
            openListAttributeMap_.add((Object)"MESSAGE_TYPE", null, "receiverVariable.messageType", new IntegerValueMap());
            openListAttributeMap_.add("MESSAGE_KEY", null, "receiverVariable.messageKey");
            openListAttributeMap_.add((Object)PRESENTATION_KEY_, null, "receiverVariable.messageQueue", new QualifiedValueMap(20, "MSGQ"));
            openListAttributeMap_.add((Object)"MESSAGE_FILE", null, "receiverVariable.messageFile", new QualifiedValueMap(20, "MSGF"));
            openListAttributeMap_.add((Object)"DATE_SENT", null, "receiverVariable.dateAndTimeSent", new DateValueMap(13));
            openListAttributeMap_.add("MESSAGE_TEXT", null, "receiverVariable.message.data");
            openListAttributeMap_.add((Object)"SENDER_JOB_NAME", null, "receiverVariable.qualifiedSenderJobName.data", new SubstringValueMap(0, 10, true));
            openListAttributeMap_.add((Object)"SENDER_JOB_NUMBER", null, "receiverVariable.qualifiedSenderJobName.data", new SubstringValueMap(20, 6, true));
            openListAttributeMap_.add((Object)"SENDER_USER_NAME", null, "receiverVariable.qualifiedSenderJobName.data", new SubstringValueMap(10, 10, true));
            openListAttributeMap_.add("SENDING_PROGRAM_NAME", null, "receiverVariable.sendingProgramName.data");
            openListAttributeMap_.add("REPLY_STATUS", null, "receiverVariable.replyStatus.data");
            openListAttributeMap_.add("DEFAULT_REPLY", null, "receiverVariable.defaultReply.data");
            openListAttributeMap_.add("MESSAGE_HELP", null, "receiverVariable.messageHelp.data");
            receiveAttributeMap_ = new ProgramMap();
            receiveAttributeMap_.add("MESSAGE_SEVERITY", null, "messageInformation.messageSeverity");
            receiveAttributeMap_.add("MESSAGE_ID", null, "messageInformation.messageID");
            receiveAttributeMap_.add((Object)"MESSAGE_TYPE", null, "messageInformation.messageType", new IntegerValueMap());
            receiveAttributeMap_.add("MESSAGE_KEY", null, "messageInformation.messageKey");
            receiveAttributeMap_.add((Object)"MESSAGE_FILE", null, "messageInformation.messageFile", new QualifiedValueMap(20, "MSGF"));
            receiveAttributeMap_.add("SENDER_JOB_NAME", null, "messageInformation.sendingJob");
            receiveAttributeMap_.add("SENDER_JOB_NUMBER", null, "messageInformation.sendingJobsNumber");
            receiveAttributeMap_.add("SENDER_USER_NAME", null, "messageInformation.sendingUserProfile");
            receiveAttributeMap_.add("SENDING_PROGRAM_NAME", null, "messageInformation.sendingProgramName");
            receiveAttributeMap_.add((Object)"DATE_SENT", null, "messageInformation.dateAndTimeSent", new DateValueMap(13));
            receiveAttributeMap_.add("ALERT_OPTION", null, "messageInformation.alertOption");
            receiveAttributeMap_.add("MESSAGE_HELP", null, "messageInformation.messageHelp");
            staticDocument_ = null;
            try {
                staticDocument_ = new ProgramCallDocument();
                staticDocument_.setDocument(DOCUMENT_NAME_);
            }
            catch (PcmlException e) {
                if (!Trace.isTraceOn()) break block2;
                Trace.log(2, "Error instantiating ProgramCallDocument", (Throwable)e);
            }
        }
        BLANK_KEY = new byte[]{64, 64, 64, 64};
    }
}

