/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.MaterializedViewName;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import javax.annotation.Nonnull;

public final class MaterializedView {
    private final com.google.bigtable.admin.v2.MaterializedView proto;

    @InternalApi
    public static MaterializedView fromProto(@Nonnull com.google.bigtable.admin.v2.MaterializedView proto) {
        return new MaterializedView(proto);
    }

    private MaterializedView(@Nonnull com.google.bigtable.admin.v2.MaterializedView proto) {
        Preconditions.checkNotNull((Object)proto);
        Preconditions.checkArgument((!proto.getName().isEmpty() ? 1 : 0) != 0, (Object)"MaterializedView must have a name");
        this.proto = proto;
    }

    public String getId() {
        MaterializedViewName fullName = MaterializedViewName.parse((String)this.proto.getName());
        return fullName.getMaterializedView();
    }

    public String getInstanceId() {
        MaterializedViewName fullName = (MaterializedViewName)Verify.verifyNotNull((Object)MaterializedViewName.parse((String)this.proto.getName()), (String)"Name can never be null", (Object[])new Object[0]);
        return fullName.getInstance();
    }

    public boolean isDeletionProtected() {
        return this.proto.getDeletionProtection();
    }

    public String getQuery() {
        return this.proto.getQuery();
    }

    @InternalApi
    public com.google.bigtable.admin.v2.MaterializedView toProto() {
        return this.proto;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MaterializedView that = (MaterializedView)o;
        return Objects.equal((Object)this.proto, (Object)that.proto);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.proto});
    }
}

