/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.admin.v2.AppProfile;
import com.google.bigtable.admin.v2.Cluster;
import com.google.bigtable.admin.v2.CreateAppProfileRequest;
import com.google.bigtable.admin.v2.CreateClusterMetadata;
import com.google.bigtable.admin.v2.CreateClusterRequest;
import com.google.bigtable.admin.v2.CreateInstanceMetadata;
import com.google.bigtable.admin.v2.CreateInstanceRequest;
import com.google.bigtable.admin.v2.CreateLogicalViewMetadata;
import com.google.bigtable.admin.v2.CreateLogicalViewRequest;
import com.google.bigtable.admin.v2.CreateMaterializedViewMetadata;
import com.google.bigtable.admin.v2.CreateMaterializedViewRequest;
import com.google.bigtable.admin.v2.DeleteAppProfileRequest;
import com.google.bigtable.admin.v2.DeleteClusterRequest;
import com.google.bigtable.admin.v2.DeleteInstanceRequest;
import com.google.bigtable.admin.v2.DeleteLogicalViewRequest;
import com.google.bigtable.admin.v2.DeleteMaterializedViewRequest;
import com.google.bigtable.admin.v2.GetAppProfileRequest;
import com.google.bigtable.admin.v2.GetClusterRequest;
import com.google.bigtable.admin.v2.GetInstanceRequest;
import com.google.bigtable.admin.v2.GetLogicalViewRequest;
import com.google.bigtable.admin.v2.GetMaterializedViewRequest;
import com.google.bigtable.admin.v2.HotTablet;
import com.google.bigtable.admin.v2.Instance;
import com.google.bigtable.admin.v2.ListAppProfilesRequest;
import com.google.bigtable.admin.v2.ListAppProfilesResponse;
import com.google.bigtable.admin.v2.ListClustersRequest;
import com.google.bigtable.admin.v2.ListClustersResponse;
import com.google.bigtable.admin.v2.ListHotTabletsRequest;
import com.google.bigtable.admin.v2.ListHotTabletsResponse;
import com.google.bigtable.admin.v2.ListInstancesRequest;
import com.google.bigtable.admin.v2.ListInstancesResponse;
import com.google.bigtable.admin.v2.ListLogicalViewsRequest;
import com.google.bigtable.admin.v2.ListLogicalViewsResponse;
import com.google.bigtable.admin.v2.ListMaterializedViewsRequest;
import com.google.bigtable.admin.v2.ListMaterializedViewsResponse;
import com.google.bigtable.admin.v2.LogicalView;
import com.google.bigtable.admin.v2.MaterializedView;
import com.google.bigtable.admin.v2.PartialUpdateClusterMetadata;
import com.google.bigtable.admin.v2.PartialUpdateClusterRequest;
import com.google.bigtable.admin.v2.PartialUpdateInstanceRequest;
import com.google.bigtable.admin.v2.UpdateAppProfileMetadata;
import com.google.bigtable.admin.v2.UpdateAppProfileRequest;
import com.google.bigtable.admin.v2.UpdateClusterMetadata;
import com.google.bigtable.admin.v2.UpdateInstanceMetadata;
import com.google.bigtable.admin.v2.UpdateLogicalViewMetadata;
import com.google.bigtable.admin.v2.UpdateLogicalViewRequest;
import com.google.bigtable.admin.v2.UpdateMaterializedViewMetadata;
import com.google.bigtable.admin.v2.UpdateMaterializedViewRequest;
import com.google.cloud.bigtable.admin.v2.BaseBigtableInstanceAdminClient;
import com.google.cloud.bigtable.admin.v2.stub.BigtableInstanceAdminStub;
import com.google.cloud.bigtable.admin.v2.stub.GrpcBigtableInstanceAdminStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class BigtableInstanceAdminStubSettings
extends StubSettings<BigtableInstanceAdminStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/bigtable.admin").add((Object)"https://www.googleapis.com/auth/bigtable.admin.cluster").add((Object)"https://www.googleapis.com/auth/bigtable.admin.instance").add((Object)"https://www.googleapis.com/auth/cloud-bigtable.admin").add((Object)"https://www.googleapis.com/auth/cloud-bigtable.admin.cluster").add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud-platform.read-only").build();
    private final UnaryCallSettings<CreateInstanceRequest, Operation> createInstanceSettings;
    private final OperationCallSettings<CreateInstanceRequest, Instance, CreateInstanceMetadata> createInstanceOperationSettings;
    private final UnaryCallSettings<GetInstanceRequest, Instance> getInstanceSettings;
    private final UnaryCallSettings<ListInstancesRequest, ListInstancesResponse> listInstancesSettings;
    private final UnaryCallSettings<Instance, Instance> updateInstanceSettings;
    private final UnaryCallSettings<PartialUpdateInstanceRequest, Operation> partialUpdateInstanceSettings;
    private final OperationCallSettings<PartialUpdateInstanceRequest, Instance, UpdateInstanceMetadata> partialUpdateInstanceOperationSettings;
    private final UnaryCallSettings<DeleteInstanceRequest, Empty> deleteInstanceSettings;
    private final UnaryCallSettings<CreateClusterRequest, Operation> createClusterSettings;
    private final OperationCallSettings<CreateClusterRequest, Cluster, CreateClusterMetadata> createClusterOperationSettings;
    private final UnaryCallSettings<GetClusterRequest, Cluster> getClusterSettings;
    private final UnaryCallSettings<ListClustersRequest, ListClustersResponse> listClustersSettings;
    private final UnaryCallSettings<Cluster, Operation> updateClusterSettings;
    private final OperationCallSettings<Cluster, Cluster, UpdateClusterMetadata> updateClusterOperationSettings;
    private final UnaryCallSettings<PartialUpdateClusterRequest, Operation> partialUpdateClusterSettings;
    private final OperationCallSettings<PartialUpdateClusterRequest, Cluster, PartialUpdateClusterMetadata> partialUpdateClusterOperationSettings;
    private final UnaryCallSettings<DeleteClusterRequest, Empty> deleteClusterSettings;
    private final UnaryCallSettings<CreateAppProfileRequest, AppProfile> createAppProfileSettings;
    private final UnaryCallSettings<GetAppProfileRequest, AppProfile> getAppProfileSettings;
    private final PagedCallSettings<ListAppProfilesRequest, ListAppProfilesResponse, BaseBigtableInstanceAdminClient.ListAppProfilesPagedResponse> listAppProfilesSettings;
    private final UnaryCallSettings<UpdateAppProfileRequest, Operation> updateAppProfileSettings;
    private final OperationCallSettings<UpdateAppProfileRequest, AppProfile, UpdateAppProfileMetadata> updateAppProfileOperationSettings;
    private final UnaryCallSettings<DeleteAppProfileRequest, Empty> deleteAppProfileSettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private final PagedCallSettings<ListHotTabletsRequest, ListHotTabletsResponse, BaseBigtableInstanceAdminClient.ListHotTabletsPagedResponse> listHotTabletsSettings;
    private final UnaryCallSettings<CreateLogicalViewRequest, Operation> createLogicalViewSettings;
    private final OperationCallSettings<CreateLogicalViewRequest, LogicalView, CreateLogicalViewMetadata> createLogicalViewOperationSettings;
    private final UnaryCallSettings<GetLogicalViewRequest, LogicalView> getLogicalViewSettings;
    private final PagedCallSettings<ListLogicalViewsRequest, ListLogicalViewsResponse, BaseBigtableInstanceAdminClient.ListLogicalViewsPagedResponse> listLogicalViewsSettings;
    private final UnaryCallSettings<UpdateLogicalViewRequest, Operation> updateLogicalViewSettings;
    private final OperationCallSettings<UpdateLogicalViewRequest, LogicalView, UpdateLogicalViewMetadata> updateLogicalViewOperationSettings;
    private final UnaryCallSettings<DeleteLogicalViewRequest, Empty> deleteLogicalViewSettings;
    private final UnaryCallSettings<CreateMaterializedViewRequest, Operation> createMaterializedViewSettings;
    private final OperationCallSettings<CreateMaterializedViewRequest, MaterializedView, CreateMaterializedViewMetadata> createMaterializedViewOperationSettings;
    private final UnaryCallSettings<GetMaterializedViewRequest, MaterializedView> getMaterializedViewSettings;
    private final PagedCallSettings<ListMaterializedViewsRequest, ListMaterializedViewsResponse, BaseBigtableInstanceAdminClient.ListMaterializedViewsPagedResponse> listMaterializedViewsSettings;
    private final UnaryCallSettings<UpdateMaterializedViewRequest, Operation> updateMaterializedViewSettings;
    private final OperationCallSettings<UpdateMaterializedViewRequest, MaterializedView, UpdateMaterializedViewMetadata> updateMaterializedViewOperationSettings;
    private final UnaryCallSettings<DeleteMaterializedViewRequest, Empty> deleteMaterializedViewSettings;
    private static final PagedListDescriptor<ListAppProfilesRequest, ListAppProfilesResponse, AppProfile> LIST_APP_PROFILES_PAGE_STR_DESC = new PagedListDescriptor<ListAppProfilesRequest, ListAppProfilesResponse, AppProfile>(){

        public String emptyToken() {
            return "";
        }

        public ListAppProfilesRequest injectToken(ListAppProfilesRequest payload, String token) {
            return ListAppProfilesRequest.newBuilder((ListAppProfilesRequest)payload).setPageToken(token).build();
        }

        public ListAppProfilesRequest injectPageSize(ListAppProfilesRequest payload, int pageSize) {
            return ListAppProfilesRequest.newBuilder((ListAppProfilesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAppProfilesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAppProfilesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AppProfile> extractResources(ListAppProfilesResponse payload) {
            return payload.getAppProfilesList();
        }
    };
    private static final PagedListDescriptor<ListHotTabletsRequest, ListHotTabletsResponse, HotTablet> LIST_HOT_TABLETS_PAGE_STR_DESC = new PagedListDescriptor<ListHotTabletsRequest, ListHotTabletsResponse, HotTablet>(){

        public String emptyToken() {
            return "";
        }

        public ListHotTabletsRequest injectToken(ListHotTabletsRequest payload, String token) {
            return ListHotTabletsRequest.newBuilder((ListHotTabletsRequest)payload).setPageToken(token).build();
        }

        public ListHotTabletsRequest injectPageSize(ListHotTabletsRequest payload, int pageSize) {
            return ListHotTabletsRequest.newBuilder((ListHotTabletsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListHotTabletsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListHotTabletsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<HotTablet> extractResources(ListHotTabletsResponse payload) {
            return payload.getHotTabletsList();
        }
    };
    private static final PagedListDescriptor<ListLogicalViewsRequest, ListLogicalViewsResponse, LogicalView> LIST_LOGICAL_VIEWS_PAGE_STR_DESC = new PagedListDescriptor<ListLogicalViewsRequest, ListLogicalViewsResponse, LogicalView>(){

        public String emptyToken() {
            return "";
        }

        public ListLogicalViewsRequest injectToken(ListLogicalViewsRequest payload, String token) {
            return ListLogicalViewsRequest.newBuilder((ListLogicalViewsRequest)payload).setPageToken(token).build();
        }

        public ListLogicalViewsRequest injectPageSize(ListLogicalViewsRequest payload, int pageSize) {
            return ListLogicalViewsRequest.newBuilder((ListLogicalViewsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLogicalViewsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLogicalViewsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<LogicalView> extractResources(ListLogicalViewsResponse payload) {
            return payload.getLogicalViewsList();
        }
    };
    private static final PagedListDescriptor<ListMaterializedViewsRequest, ListMaterializedViewsResponse, MaterializedView> LIST_MATERIALIZED_VIEWS_PAGE_STR_DESC = new PagedListDescriptor<ListMaterializedViewsRequest, ListMaterializedViewsResponse, MaterializedView>(){

        public String emptyToken() {
            return "";
        }

        public ListMaterializedViewsRequest injectToken(ListMaterializedViewsRequest payload, String token) {
            return ListMaterializedViewsRequest.newBuilder((ListMaterializedViewsRequest)payload).setPageToken(token).build();
        }

        public ListMaterializedViewsRequest injectPageSize(ListMaterializedViewsRequest payload, int pageSize) {
            return ListMaterializedViewsRequest.newBuilder((ListMaterializedViewsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListMaterializedViewsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListMaterializedViewsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<MaterializedView> extractResources(ListMaterializedViewsResponse payload) {
            return payload.getMaterializedViewsList();
        }
    };
    private static final PagedListResponseFactory<ListAppProfilesRequest, ListAppProfilesResponse, BaseBigtableInstanceAdminClient.ListAppProfilesPagedResponse> LIST_APP_PROFILES_PAGE_STR_FACT = new PagedListResponseFactory<ListAppProfilesRequest, ListAppProfilesResponse, BaseBigtableInstanceAdminClient.ListAppProfilesPagedResponse>(){

        public ApiFuture<BaseBigtableInstanceAdminClient.ListAppProfilesPagedResponse> getFuturePagedResponse(UnaryCallable<ListAppProfilesRequest, ListAppProfilesResponse> callable, ListAppProfilesRequest request, ApiCallContext context, ApiFuture<ListAppProfilesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_APP_PROFILES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BaseBigtableInstanceAdminClient.ListAppProfilesPagedResponse.createAsync((PageContext<ListAppProfilesRequest, ListAppProfilesResponse, AppProfile>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListHotTabletsRequest, ListHotTabletsResponse, BaseBigtableInstanceAdminClient.ListHotTabletsPagedResponse> LIST_HOT_TABLETS_PAGE_STR_FACT = new PagedListResponseFactory<ListHotTabletsRequest, ListHotTabletsResponse, BaseBigtableInstanceAdminClient.ListHotTabletsPagedResponse>(){

        public ApiFuture<BaseBigtableInstanceAdminClient.ListHotTabletsPagedResponse> getFuturePagedResponse(UnaryCallable<ListHotTabletsRequest, ListHotTabletsResponse> callable, ListHotTabletsRequest request, ApiCallContext context, ApiFuture<ListHotTabletsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_HOT_TABLETS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BaseBigtableInstanceAdminClient.ListHotTabletsPagedResponse.createAsync((PageContext<ListHotTabletsRequest, ListHotTabletsResponse, HotTablet>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLogicalViewsRequest, ListLogicalViewsResponse, BaseBigtableInstanceAdminClient.ListLogicalViewsPagedResponse> LIST_LOGICAL_VIEWS_PAGE_STR_FACT = new PagedListResponseFactory<ListLogicalViewsRequest, ListLogicalViewsResponse, BaseBigtableInstanceAdminClient.ListLogicalViewsPagedResponse>(){

        public ApiFuture<BaseBigtableInstanceAdminClient.ListLogicalViewsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLogicalViewsRequest, ListLogicalViewsResponse> callable, ListLogicalViewsRequest request, ApiCallContext context, ApiFuture<ListLogicalViewsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOGICAL_VIEWS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BaseBigtableInstanceAdminClient.ListLogicalViewsPagedResponse.createAsync((PageContext<ListLogicalViewsRequest, ListLogicalViewsResponse, LogicalView>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListMaterializedViewsRequest, ListMaterializedViewsResponse, BaseBigtableInstanceAdminClient.ListMaterializedViewsPagedResponse> LIST_MATERIALIZED_VIEWS_PAGE_STR_FACT = new PagedListResponseFactory<ListMaterializedViewsRequest, ListMaterializedViewsResponse, BaseBigtableInstanceAdminClient.ListMaterializedViewsPagedResponse>(){

        public ApiFuture<BaseBigtableInstanceAdminClient.ListMaterializedViewsPagedResponse> getFuturePagedResponse(UnaryCallable<ListMaterializedViewsRequest, ListMaterializedViewsResponse> callable, ListMaterializedViewsRequest request, ApiCallContext context, ApiFuture<ListMaterializedViewsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_MATERIALIZED_VIEWS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BaseBigtableInstanceAdminClient.ListMaterializedViewsPagedResponse.createAsync((PageContext<ListMaterializedViewsRequest, ListMaterializedViewsResponse, MaterializedView>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateInstanceRequest, Operation> createInstanceSettings() {
        return this.createInstanceSettings;
    }

    public OperationCallSettings<CreateInstanceRequest, Instance, CreateInstanceMetadata> createInstanceOperationSettings() {
        return this.createInstanceOperationSettings;
    }

    public UnaryCallSettings<GetInstanceRequest, Instance> getInstanceSettings() {
        return this.getInstanceSettings;
    }

    public UnaryCallSettings<ListInstancesRequest, ListInstancesResponse> listInstancesSettings() {
        return this.listInstancesSettings;
    }

    public UnaryCallSettings<Instance, Instance> updateInstanceSettings() {
        return this.updateInstanceSettings;
    }

    public UnaryCallSettings<PartialUpdateInstanceRequest, Operation> partialUpdateInstanceSettings() {
        return this.partialUpdateInstanceSettings;
    }

    public OperationCallSettings<PartialUpdateInstanceRequest, Instance, UpdateInstanceMetadata> partialUpdateInstanceOperationSettings() {
        return this.partialUpdateInstanceOperationSettings;
    }

    public UnaryCallSettings<DeleteInstanceRequest, Empty> deleteInstanceSettings() {
        return this.deleteInstanceSettings;
    }

    public UnaryCallSettings<CreateClusterRequest, Operation> createClusterSettings() {
        return this.createClusterSettings;
    }

    public OperationCallSettings<CreateClusterRequest, Cluster, CreateClusterMetadata> createClusterOperationSettings() {
        return this.createClusterOperationSettings;
    }

    public UnaryCallSettings<GetClusterRequest, Cluster> getClusterSettings() {
        return this.getClusterSettings;
    }

    public UnaryCallSettings<ListClustersRequest, ListClustersResponse> listClustersSettings() {
        return this.listClustersSettings;
    }

    public UnaryCallSettings<Cluster, Operation> updateClusterSettings() {
        return this.updateClusterSettings;
    }

    public OperationCallSettings<Cluster, Cluster, UpdateClusterMetadata> updateClusterOperationSettings() {
        return this.updateClusterOperationSettings;
    }

    public UnaryCallSettings<PartialUpdateClusterRequest, Operation> partialUpdateClusterSettings() {
        return this.partialUpdateClusterSettings;
    }

    public OperationCallSettings<PartialUpdateClusterRequest, Cluster, PartialUpdateClusterMetadata> partialUpdateClusterOperationSettings() {
        return this.partialUpdateClusterOperationSettings;
    }

    public UnaryCallSettings<DeleteClusterRequest, Empty> deleteClusterSettings() {
        return this.deleteClusterSettings;
    }

    public UnaryCallSettings<CreateAppProfileRequest, AppProfile> createAppProfileSettings() {
        return this.createAppProfileSettings;
    }

    public UnaryCallSettings<GetAppProfileRequest, AppProfile> getAppProfileSettings() {
        return this.getAppProfileSettings;
    }

    public PagedCallSettings<ListAppProfilesRequest, ListAppProfilesResponse, BaseBigtableInstanceAdminClient.ListAppProfilesPagedResponse> listAppProfilesSettings() {
        return this.listAppProfilesSettings;
    }

    public UnaryCallSettings<UpdateAppProfileRequest, Operation> updateAppProfileSettings() {
        return this.updateAppProfileSettings;
    }

    public OperationCallSettings<UpdateAppProfileRequest, AppProfile, UpdateAppProfileMetadata> updateAppProfileOperationSettings() {
        return this.updateAppProfileOperationSettings;
    }

    public UnaryCallSettings<DeleteAppProfileRequest, Empty> deleteAppProfileSettings() {
        return this.deleteAppProfileSettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public PagedCallSettings<ListHotTabletsRequest, ListHotTabletsResponse, BaseBigtableInstanceAdminClient.ListHotTabletsPagedResponse> listHotTabletsSettings() {
        return this.listHotTabletsSettings;
    }

    public UnaryCallSettings<CreateLogicalViewRequest, Operation> createLogicalViewSettings() {
        return this.createLogicalViewSettings;
    }

    public OperationCallSettings<CreateLogicalViewRequest, LogicalView, CreateLogicalViewMetadata> createLogicalViewOperationSettings() {
        return this.createLogicalViewOperationSettings;
    }

    public UnaryCallSettings<GetLogicalViewRequest, LogicalView> getLogicalViewSettings() {
        return this.getLogicalViewSettings;
    }

    public PagedCallSettings<ListLogicalViewsRequest, ListLogicalViewsResponse, BaseBigtableInstanceAdminClient.ListLogicalViewsPagedResponse> listLogicalViewsSettings() {
        return this.listLogicalViewsSettings;
    }

    public UnaryCallSettings<UpdateLogicalViewRequest, Operation> updateLogicalViewSettings() {
        return this.updateLogicalViewSettings;
    }

    public OperationCallSettings<UpdateLogicalViewRequest, LogicalView, UpdateLogicalViewMetadata> updateLogicalViewOperationSettings() {
        return this.updateLogicalViewOperationSettings;
    }

    public UnaryCallSettings<DeleteLogicalViewRequest, Empty> deleteLogicalViewSettings() {
        return this.deleteLogicalViewSettings;
    }

    public UnaryCallSettings<CreateMaterializedViewRequest, Operation> createMaterializedViewSettings() {
        return this.createMaterializedViewSettings;
    }

    public OperationCallSettings<CreateMaterializedViewRequest, MaterializedView, CreateMaterializedViewMetadata> createMaterializedViewOperationSettings() {
        return this.createMaterializedViewOperationSettings;
    }

    public UnaryCallSettings<GetMaterializedViewRequest, MaterializedView> getMaterializedViewSettings() {
        return this.getMaterializedViewSettings;
    }

    public PagedCallSettings<ListMaterializedViewsRequest, ListMaterializedViewsResponse, BaseBigtableInstanceAdminClient.ListMaterializedViewsPagedResponse> listMaterializedViewsSettings() {
        return this.listMaterializedViewsSettings;
    }

    public UnaryCallSettings<UpdateMaterializedViewRequest, Operation> updateMaterializedViewSettings() {
        return this.updateMaterializedViewSettings;
    }

    public OperationCallSettings<UpdateMaterializedViewRequest, MaterializedView, UpdateMaterializedViewMetadata> updateMaterializedViewOperationSettings() {
        return this.updateMaterializedViewOperationSettings;
    }

    public UnaryCallSettings<DeleteMaterializedViewRequest, Empty> deleteMaterializedViewSettings() {
        return this.deleteMaterializedViewSettings;
    }

    public BigtableInstanceAdminStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcBigtableInstanceAdminStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "bigtableadmin";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "bigtableadmin.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "bigtableadmin.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return BigtableInstanceAdminStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(BigtableInstanceAdminStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected BigtableInstanceAdminStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createInstanceSettings = settingsBuilder.createInstanceSettings().build();
        this.createInstanceOperationSettings = settingsBuilder.createInstanceOperationSettings().build();
        this.getInstanceSettings = settingsBuilder.getInstanceSettings().build();
        this.listInstancesSettings = settingsBuilder.listInstancesSettings().build();
        this.updateInstanceSettings = settingsBuilder.updateInstanceSettings().build();
        this.partialUpdateInstanceSettings = settingsBuilder.partialUpdateInstanceSettings().build();
        this.partialUpdateInstanceOperationSettings = settingsBuilder.partialUpdateInstanceOperationSettings().build();
        this.deleteInstanceSettings = settingsBuilder.deleteInstanceSettings().build();
        this.createClusterSettings = settingsBuilder.createClusterSettings().build();
        this.createClusterOperationSettings = settingsBuilder.createClusterOperationSettings().build();
        this.getClusterSettings = settingsBuilder.getClusterSettings().build();
        this.listClustersSettings = settingsBuilder.listClustersSettings().build();
        this.updateClusterSettings = settingsBuilder.updateClusterSettings().build();
        this.updateClusterOperationSettings = settingsBuilder.updateClusterOperationSettings().build();
        this.partialUpdateClusterSettings = settingsBuilder.partialUpdateClusterSettings().build();
        this.partialUpdateClusterOperationSettings = settingsBuilder.partialUpdateClusterOperationSettings().build();
        this.deleteClusterSettings = settingsBuilder.deleteClusterSettings().build();
        this.createAppProfileSettings = settingsBuilder.createAppProfileSettings().build();
        this.getAppProfileSettings = settingsBuilder.getAppProfileSettings().build();
        this.listAppProfilesSettings = settingsBuilder.listAppProfilesSettings().build();
        this.updateAppProfileSettings = settingsBuilder.updateAppProfileSettings().build();
        this.updateAppProfileOperationSettings = settingsBuilder.updateAppProfileOperationSettings().build();
        this.deleteAppProfileSettings = settingsBuilder.deleteAppProfileSettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
        this.listHotTabletsSettings = settingsBuilder.listHotTabletsSettings().build();
        this.createLogicalViewSettings = settingsBuilder.createLogicalViewSettings().build();
        this.createLogicalViewOperationSettings = settingsBuilder.createLogicalViewOperationSettings().build();
        this.getLogicalViewSettings = settingsBuilder.getLogicalViewSettings().build();
        this.listLogicalViewsSettings = settingsBuilder.listLogicalViewsSettings().build();
        this.updateLogicalViewSettings = settingsBuilder.updateLogicalViewSettings().build();
        this.updateLogicalViewOperationSettings = settingsBuilder.updateLogicalViewOperationSettings().build();
        this.deleteLogicalViewSettings = settingsBuilder.deleteLogicalViewSettings().build();
        this.createMaterializedViewSettings = settingsBuilder.createMaterializedViewSettings().build();
        this.createMaterializedViewOperationSettings = settingsBuilder.createMaterializedViewOperationSettings().build();
        this.getMaterializedViewSettings = settingsBuilder.getMaterializedViewSettings().build();
        this.listMaterializedViewsSettings = settingsBuilder.listMaterializedViewsSettings().build();
        this.updateMaterializedViewSettings = settingsBuilder.updateMaterializedViewSettings().build();
        this.updateMaterializedViewOperationSettings = settingsBuilder.updateMaterializedViewOperationSettings().build();
        this.deleteMaterializedViewSettings = settingsBuilder.deleteMaterializedViewSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<BigtableInstanceAdminStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateInstanceRequest, Operation> createInstanceSettings;
        private final OperationCallSettings.Builder<CreateInstanceRequest, Instance, CreateInstanceMetadata> createInstanceOperationSettings;
        private final UnaryCallSettings.Builder<GetInstanceRequest, Instance> getInstanceSettings;
        private final UnaryCallSettings.Builder<ListInstancesRequest, ListInstancesResponse> listInstancesSettings;
        private final UnaryCallSettings.Builder<Instance, Instance> updateInstanceSettings;
        private final UnaryCallSettings.Builder<PartialUpdateInstanceRequest, Operation> partialUpdateInstanceSettings;
        private final OperationCallSettings.Builder<PartialUpdateInstanceRequest, Instance, UpdateInstanceMetadata> partialUpdateInstanceOperationSettings;
        private final UnaryCallSettings.Builder<DeleteInstanceRequest, Empty> deleteInstanceSettings;
        private final UnaryCallSettings.Builder<CreateClusterRequest, Operation> createClusterSettings;
        private final OperationCallSettings.Builder<CreateClusterRequest, Cluster, CreateClusterMetadata> createClusterOperationSettings;
        private final UnaryCallSettings.Builder<GetClusterRequest, Cluster> getClusterSettings;
        private final UnaryCallSettings.Builder<ListClustersRequest, ListClustersResponse> listClustersSettings;
        private final UnaryCallSettings.Builder<Cluster, Operation> updateClusterSettings;
        private final OperationCallSettings.Builder<Cluster, Cluster, UpdateClusterMetadata> updateClusterOperationSettings;
        private final UnaryCallSettings.Builder<PartialUpdateClusterRequest, Operation> partialUpdateClusterSettings;
        private final OperationCallSettings.Builder<PartialUpdateClusterRequest, Cluster, PartialUpdateClusterMetadata> partialUpdateClusterOperationSettings;
        private final UnaryCallSettings.Builder<DeleteClusterRequest, Empty> deleteClusterSettings;
        private final UnaryCallSettings.Builder<CreateAppProfileRequest, AppProfile> createAppProfileSettings;
        private final UnaryCallSettings.Builder<GetAppProfileRequest, AppProfile> getAppProfileSettings;
        private final PagedCallSettings.Builder<ListAppProfilesRequest, ListAppProfilesResponse, BaseBigtableInstanceAdminClient.ListAppProfilesPagedResponse> listAppProfilesSettings;
        private final UnaryCallSettings.Builder<UpdateAppProfileRequest, Operation> updateAppProfileSettings;
        private final OperationCallSettings.Builder<UpdateAppProfileRequest, AppProfile, UpdateAppProfileMetadata> updateAppProfileOperationSettings;
        private final UnaryCallSettings.Builder<DeleteAppProfileRequest, Empty> deleteAppProfileSettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private final PagedCallSettings.Builder<ListHotTabletsRequest, ListHotTabletsResponse, BaseBigtableInstanceAdminClient.ListHotTabletsPagedResponse> listHotTabletsSettings;
        private final UnaryCallSettings.Builder<CreateLogicalViewRequest, Operation> createLogicalViewSettings;
        private final OperationCallSettings.Builder<CreateLogicalViewRequest, LogicalView, CreateLogicalViewMetadata> createLogicalViewOperationSettings;
        private final UnaryCallSettings.Builder<GetLogicalViewRequest, LogicalView> getLogicalViewSettings;
        private final PagedCallSettings.Builder<ListLogicalViewsRequest, ListLogicalViewsResponse, BaseBigtableInstanceAdminClient.ListLogicalViewsPagedResponse> listLogicalViewsSettings;
        private final UnaryCallSettings.Builder<UpdateLogicalViewRequest, Operation> updateLogicalViewSettings;
        private final OperationCallSettings.Builder<UpdateLogicalViewRequest, LogicalView, UpdateLogicalViewMetadata> updateLogicalViewOperationSettings;
        private final UnaryCallSettings.Builder<DeleteLogicalViewRequest, Empty> deleteLogicalViewSettings;
        private final UnaryCallSettings.Builder<CreateMaterializedViewRequest, Operation> createMaterializedViewSettings;
        private final OperationCallSettings.Builder<CreateMaterializedViewRequest, MaterializedView, CreateMaterializedViewMetadata> createMaterializedViewOperationSettings;
        private final UnaryCallSettings.Builder<GetMaterializedViewRequest, MaterializedView> getMaterializedViewSettings;
        private final PagedCallSettings.Builder<ListMaterializedViewsRequest, ListMaterializedViewsResponse, BaseBigtableInstanceAdminClient.ListMaterializedViewsPagedResponse> listMaterializedViewsSettings;
        private final UnaryCallSettings.Builder<UpdateMaterializedViewRequest, Operation> updateMaterializedViewSettings;
        private final OperationCallSettings.Builder<UpdateMaterializedViewRequest, MaterializedView, UpdateMaterializedViewMetadata> updateMaterializedViewOperationSettings;
        private final UnaryCallSettings.Builder<DeleteMaterializedViewRequest, Empty> deleteMaterializedViewSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.getInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listInstancesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.partialUpdateInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.partialUpdateInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.deleteInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createClusterOperationSettings = OperationCallSettings.newBuilder();
            this.getClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listClustersSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateClusterOperationSettings = OperationCallSettings.newBuilder();
            this.partialUpdateClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.partialUpdateClusterOperationSettings = OperationCallSettings.newBuilder();
            this.deleteClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAppProfileSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getAppProfileSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listAppProfilesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_APP_PROFILES_PAGE_STR_FACT);
            this.updateAppProfileSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateAppProfileOperationSettings = OperationCallSettings.newBuilder();
            this.deleteAppProfileSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listHotTabletsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_HOT_TABLETS_PAGE_STR_FACT);
            this.createLogicalViewSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createLogicalViewOperationSettings = OperationCallSettings.newBuilder();
            this.getLogicalViewSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLogicalViewsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOGICAL_VIEWS_PAGE_STR_FACT);
            this.updateLogicalViewSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateLogicalViewOperationSettings = OperationCallSettings.newBuilder();
            this.deleteLogicalViewSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createMaterializedViewSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createMaterializedViewOperationSettings = OperationCallSettings.newBuilder();
            this.getMaterializedViewSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listMaterializedViewsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_MATERIALIZED_VIEWS_PAGE_STR_FACT);
            this.updateMaterializedViewSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateMaterializedViewOperationSettings = OperationCallSettings.newBuilder();
            this.deleteMaterializedViewSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createInstanceSettings, this.getInstanceSettings, this.listInstancesSettings, this.updateInstanceSettings, this.partialUpdateInstanceSettings, this.deleteInstanceSettings, this.createClusterSettings, this.getClusterSettings, this.listClustersSettings, this.updateClusterSettings, this.partialUpdateClusterSettings, this.deleteClusterSettings, (Object[])new UnaryCallSettings.Builder[]{this.createAppProfileSettings, this.getAppProfileSettings, this.listAppProfilesSettings, this.updateAppProfileSettings, this.deleteAppProfileSettings, this.getIamPolicySettings, this.setIamPolicySettings, this.testIamPermissionsSettings, this.listHotTabletsSettings, this.createLogicalViewSettings, this.getLogicalViewSettings, this.listLogicalViewsSettings, this.updateLogicalViewSettings, this.deleteLogicalViewSettings, this.createMaterializedViewSettings, this.getMaterializedViewSettings, this.listMaterializedViewsSettings, this.updateMaterializedViewSettings, this.deleteMaterializedViewSettings});
            Builder.initDefaults(this);
        }

        protected Builder(BigtableInstanceAdminStubSettings settings) {
            super((StubSettings)settings);
            this.createInstanceSettings = settings.createInstanceSettings.toBuilder();
            this.createInstanceOperationSettings = settings.createInstanceOperationSettings.toBuilder();
            this.getInstanceSettings = settings.getInstanceSettings.toBuilder();
            this.listInstancesSettings = settings.listInstancesSettings.toBuilder();
            this.updateInstanceSettings = settings.updateInstanceSettings.toBuilder();
            this.partialUpdateInstanceSettings = settings.partialUpdateInstanceSettings.toBuilder();
            this.partialUpdateInstanceOperationSettings = settings.partialUpdateInstanceOperationSettings.toBuilder();
            this.deleteInstanceSettings = settings.deleteInstanceSettings.toBuilder();
            this.createClusterSettings = settings.createClusterSettings.toBuilder();
            this.createClusterOperationSettings = settings.createClusterOperationSettings.toBuilder();
            this.getClusterSettings = settings.getClusterSettings.toBuilder();
            this.listClustersSettings = settings.listClustersSettings.toBuilder();
            this.updateClusterSettings = settings.updateClusterSettings.toBuilder();
            this.updateClusterOperationSettings = settings.updateClusterOperationSettings.toBuilder();
            this.partialUpdateClusterSettings = settings.partialUpdateClusterSettings.toBuilder();
            this.partialUpdateClusterOperationSettings = settings.partialUpdateClusterOperationSettings.toBuilder();
            this.deleteClusterSettings = settings.deleteClusterSettings.toBuilder();
            this.createAppProfileSettings = settings.createAppProfileSettings.toBuilder();
            this.getAppProfileSettings = settings.getAppProfileSettings.toBuilder();
            this.listAppProfilesSettings = settings.listAppProfilesSettings.toBuilder();
            this.updateAppProfileSettings = settings.updateAppProfileSettings.toBuilder();
            this.updateAppProfileOperationSettings = settings.updateAppProfileOperationSettings.toBuilder();
            this.deleteAppProfileSettings = settings.deleteAppProfileSettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.listHotTabletsSettings = settings.listHotTabletsSettings.toBuilder();
            this.createLogicalViewSettings = settings.createLogicalViewSettings.toBuilder();
            this.createLogicalViewOperationSettings = settings.createLogicalViewOperationSettings.toBuilder();
            this.getLogicalViewSettings = settings.getLogicalViewSettings.toBuilder();
            this.listLogicalViewsSettings = settings.listLogicalViewsSettings.toBuilder();
            this.updateLogicalViewSettings = settings.updateLogicalViewSettings.toBuilder();
            this.updateLogicalViewOperationSettings = settings.updateLogicalViewOperationSettings.toBuilder();
            this.deleteLogicalViewSettings = settings.deleteLogicalViewSettings.toBuilder();
            this.createMaterializedViewSettings = settings.createMaterializedViewSettings.toBuilder();
            this.createMaterializedViewOperationSettings = settings.createMaterializedViewOperationSettings.toBuilder();
            this.getMaterializedViewSettings = settings.getMaterializedViewSettings.toBuilder();
            this.listMaterializedViewsSettings = settings.listMaterializedViewsSettings.toBuilder();
            this.updateMaterializedViewSettings = settings.updateMaterializedViewSettings.toBuilder();
            this.updateMaterializedViewOperationSettings = settings.updateMaterializedViewOperationSettings.toBuilder();
            this.deleteMaterializedViewSettings = settings.deleteMaterializedViewSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createInstanceSettings, this.getInstanceSettings, this.listInstancesSettings, this.updateInstanceSettings, this.partialUpdateInstanceSettings, this.deleteInstanceSettings, this.createClusterSettings, this.getClusterSettings, this.listClustersSettings, this.updateClusterSettings, this.partialUpdateClusterSettings, this.deleteClusterSettings, (Object[])new UnaryCallSettings.Builder[]{this.createAppProfileSettings, this.getAppProfileSettings, this.listAppProfilesSettings, this.updateAppProfileSettings, this.deleteAppProfileSettings, this.getIamPolicySettings, this.setIamPolicySettings, this.testIamPermissionsSettings, this.listHotTabletsSettings, this.createLogicalViewSettings, this.getLogicalViewSettings, this.listLogicalViewsSettings, this.updateLogicalViewSettings, this.deleteLogicalViewSettings, this.createMaterializedViewSettings, this.getMaterializedViewSettings, this.listMaterializedViewsSettings, this.updateMaterializedViewSettings, this.deleteMaterializedViewSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(BigtableInstanceAdminStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)BigtableInstanceAdminStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)BigtableInstanceAdminStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(BigtableInstanceAdminStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_5_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_5_params"));
            builder.getInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_6_params"));
            builder.listInstancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_6_params"));
            builder.updateInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_6_params"));
            builder.partialUpdateInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_6_params"));
            builder.deleteInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_7_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_7_params"));
            builder.createClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_7_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_7_params"));
            builder.getClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_6_params"));
            builder.listClustersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_6_params"));
            builder.updateClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_6_params"));
            builder.partialUpdateClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_7_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_7_params"));
            builder.createAppProfileSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_7_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_7_params"));
            builder.getAppProfileSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_6_params"));
            builder.listAppProfilesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_6_params"));
            builder.updateAppProfileSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_6_params"));
            builder.deleteAppProfileSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_7_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_7_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_6_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_7_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_7_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_6_params"));
            builder.listHotTabletsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_6_params"));
            builder.createLogicalViewSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLogicalViewSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLogicalViewsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateLogicalViewSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteLogicalViewSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createMaterializedViewSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getMaterializedViewSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listMaterializedViewsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateMaterializedViewSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteMaterializedViewSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_5_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_5_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateInstanceMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(5000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.partialUpdateInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_6_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UpdateInstanceMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(5000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.createClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_7_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_7_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Cluster.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateClusterMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(21600000L)).build()));
            builder.updateClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_6_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Cluster.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UpdateClusterMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(5000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.partialUpdateClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Cluster.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(PartialUpdateClusterMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(5000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.updateAppProfileOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_6_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AppProfile.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UpdateAppProfileMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(5000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.createLogicalViewOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(LogicalView.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateLogicalViewMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateLogicalViewOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(LogicalView.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UpdateLogicalViewMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.createMaterializedViewOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(MaterializedView.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateMaterializedViewMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateMaterializedViewOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(MaterializedView.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UpdateMaterializedViewMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateInstanceRequest, Operation> createInstanceSettings() {
            return this.createInstanceSettings;
        }

        public OperationCallSettings.Builder<CreateInstanceRequest, Instance, CreateInstanceMetadata> createInstanceOperationSettings() {
            return this.createInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<GetInstanceRequest, Instance> getInstanceSettings() {
            return this.getInstanceSettings;
        }

        public UnaryCallSettings.Builder<ListInstancesRequest, ListInstancesResponse> listInstancesSettings() {
            return this.listInstancesSettings;
        }

        public UnaryCallSettings.Builder<Instance, Instance> updateInstanceSettings() {
            return this.updateInstanceSettings;
        }

        public UnaryCallSettings.Builder<PartialUpdateInstanceRequest, Operation> partialUpdateInstanceSettings() {
            return this.partialUpdateInstanceSettings;
        }

        public OperationCallSettings.Builder<PartialUpdateInstanceRequest, Instance, UpdateInstanceMetadata> partialUpdateInstanceOperationSettings() {
            return this.partialUpdateInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteInstanceRequest, Empty> deleteInstanceSettings() {
            return this.deleteInstanceSettings;
        }

        public UnaryCallSettings.Builder<CreateClusterRequest, Operation> createClusterSettings() {
            return this.createClusterSettings;
        }

        public OperationCallSettings.Builder<CreateClusterRequest, Cluster, CreateClusterMetadata> createClusterOperationSettings() {
            return this.createClusterOperationSettings;
        }

        public UnaryCallSettings.Builder<GetClusterRequest, Cluster> getClusterSettings() {
            return this.getClusterSettings;
        }

        public UnaryCallSettings.Builder<ListClustersRequest, ListClustersResponse> listClustersSettings() {
            return this.listClustersSettings;
        }

        public UnaryCallSettings.Builder<Cluster, Operation> updateClusterSettings() {
            return this.updateClusterSettings;
        }

        public OperationCallSettings.Builder<Cluster, Cluster, UpdateClusterMetadata> updateClusterOperationSettings() {
            return this.updateClusterOperationSettings;
        }

        public UnaryCallSettings.Builder<PartialUpdateClusterRequest, Operation> partialUpdateClusterSettings() {
            return this.partialUpdateClusterSettings;
        }

        public OperationCallSettings.Builder<PartialUpdateClusterRequest, Cluster, PartialUpdateClusterMetadata> partialUpdateClusterOperationSettings() {
            return this.partialUpdateClusterOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteClusterRequest, Empty> deleteClusterSettings() {
            return this.deleteClusterSettings;
        }

        public UnaryCallSettings.Builder<CreateAppProfileRequest, AppProfile> createAppProfileSettings() {
            return this.createAppProfileSettings;
        }

        public UnaryCallSettings.Builder<GetAppProfileRequest, AppProfile> getAppProfileSettings() {
            return this.getAppProfileSettings;
        }

        public PagedCallSettings.Builder<ListAppProfilesRequest, ListAppProfilesResponse, BaseBigtableInstanceAdminClient.ListAppProfilesPagedResponse> listAppProfilesSettings() {
            return this.listAppProfilesSettings;
        }

        public UnaryCallSettings.Builder<UpdateAppProfileRequest, Operation> updateAppProfileSettings() {
            return this.updateAppProfileSettings;
        }

        public OperationCallSettings.Builder<UpdateAppProfileRequest, AppProfile, UpdateAppProfileMetadata> updateAppProfileOperationSettings() {
            return this.updateAppProfileOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteAppProfileRequest, Empty> deleteAppProfileSettings() {
            return this.deleteAppProfileSettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public PagedCallSettings.Builder<ListHotTabletsRequest, ListHotTabletsResponse, BaseBigtableInstanceAdminClient.ListHotTabletsPagedResponse> listHotTabletsSettings() {
            return this.listHotTabletsSettings;
        }

        public UnaryCallSettings.Builder<CreateLogicalViewRequest, Operation> createLogicalViewSettings() {
            return this.createLogicalViewSettings;
        }

        public OperationCallSettings.Builder<CreateLogicalViewRequest, LogicalView, CreateLogicalViewMetadata> createLogicalViewOperationSettings() {
            return this.createLogicalViewOperationSettings;
        }

        public UnaryCallSettings.Builder<GetLogicalViewRequest, LogicalView> getLogicalViewSettings() {
            return this.getLogicalViewSettings;
        }

        public PagedCallSettings.Builder<ListLogicalViewsRequest, ListLogicalViewsResponse, BaseBigtableInstanceAdminClient.ListLogicalViewsPagedResponse> listLogicalViewsSettings() {
            return this.listLogicalViewsSettings;
        }

        public UnaryCallSettings.Builder<UpdateLogicalViewRequest, Operation> updateLogicalViewSettings() {
            return this.updateLogicalViewSettings;
        }

        public OperationCallSettings.Builder<UpdateLogicalViewRequest, LogicalView, UpdateLogicalViewMetadata> updateLogicalViewOperationSettings() {
            return this.updateLogicalViewOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteLogicalViewRequest, Empty> deleteLogicalViewSettings() {
            return this.deleteLogicalViewSettings;
        }

        public UnaryCallSettings.Builder<CreateMaterializedViewRequest, Operation> createMaterializedViewSettings() {
            return this.createMaterializedViewSettings;
        }

        public OperationCallSettings.Builder<CreateMaterializedViewRequest, MaterializedView, CreateMaterializedViewMetadata> createMaterializedViewOperationSettings() {
            return this.createMaterializedViewOperationSettings;
        }

        public UnaryCallSettings.Builder<GetMaterializedViewRequest, MaterializedView> getMaterializedViewSettings() {
            return this.getMaterializedViewSettings;
        }

        public PagedCallSettings.Builder<ListMaterializedViewsRequest, ListMaterializedViewsResponse, BaseBigtableInstanceAdminClient.ListMaterializedViewsPagedResponse> listMaterializedViewsSettings() {
            return this.listMaterializedViewsSettings;
        }

        public UnaryCallSettings.Builder<UpdateMaterializedViewRequest, Operation> updateMaterializedViewSettings() {
            return this.updateMaterializedViewSettings;
        }

        public OperationCallSettings.Builder<UpdateMaterializedViewRequest, MaterializedView, UpdateMaterializedViewMetadata> updateMaterializedViewOperationSettings() {
            return this.updateMaterializedViewOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteMaterializedViewRequest, Empty> deleteMaterializedViewSettings() {
            return this.deleteMaterializedViewSettings;
        }

        public BigtableInstanceAdminStubSettings build() throws IOException {
            return new BigtableInstanceAdminStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_5_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_6_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            definitions.put((Object)"no_retry_7_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(300000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(300000L)).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build();
            definitions.put((Object)"no_retry_5_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_6_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"no_retry_7_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

