/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.jdbc;

import com.amazon.redshift.jdbc.MetadataAPIHelper;
import com.amazon.redshift.jdbc.RedshiftConnectionImpl;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.util.RedshiftException;
import com.amazonaws.util.StringUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class MetadataServerAPIHelper
extends MetadataAPIHelper {
    PreparedStatement prst_QUOTE_LITERAL = this.createMetaDataPreparedStatement("select pg_catalog.QUOTE_LITERAL($1);");
    PreparedStatement prst_QUOTE_IDENT = this.createMetaDataPreparedStatement("select pg_catalog.QUOTE_IDENT($1);");

    public MetadataServerAPIHelper(RedshiftConnectionImpl connection) throws SQLException {
        super(connection);
    }

    protected ResultSet getCatalogsServerAPI() throws SQLException {
        ResultSet rs = null;
        try {
            if (RedshiftLogger.isEnable()) {
                this.connection.getLogger().logDebug("Calling Server API SHOW DATABASES", new Object[0]);
            }
            rs = this.runQuery("SHOW DATABASES;");
        }
        catch (SQLException e) {
            throw new RedshiftException("MetadataServerAPIHelper.getCatalogsServerAPI: " + e.getMessage());
        }
        return rs;
    }

    protected List<ResultSet> getSchemasServerAPI(String catalog, String schemaPattern, boolean retEmpty, boolean isSingleDatabaseMetaData) throws SQLException {
        ArrayList<ResultSet> intermediateRs = new ArrayList<ResultSet>();
        if (!retEmpty) {
            try {
                List<String> catalogList = this.callGetCatalogList(catalog, isSingleDatabaseMetaData);
                for (String curCatalog : catalogList) {
                    intermediateRs.add(this.callShowSchemas(curCatalog, schemaPattern));
                }
            }
            catch (SQLException e) {
                throw new RedshiftException("MetadataServerAPIHelper.getSchemasServerAPI: " + e.getMessage());
            }
        }
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Return intermediate result set for catalog: {0}, schemaPattern: {1}", catalog, schemaPattern);
        }
        return intermediateRs;
    }

    protected List<ResultSet> getTablesServerAPI(String catalog, String schemaPattern, String tableNamePattern, boolean retEmpty, boolean isSingleDatabaseMetaData) throws SQLException {
        ArrayList<ResultSet> intermediateRs = new ArrayList<ResultSet>();
        if (!retEmpty) {
            try {
                List<String> catalogList = this.callGetCatalogList(catalog, isSingleDatabaseMetaData);
                for (String curCat : catalogList) {
                    ResultSet schemasRs = this.callShowSchemas(curCat, schemaPattern);
                    while (schemasRs.next()) {
                        intermediateRs.add(this.callShowTables(curCat, schemasRs.getString("schema_name"), tableNamePattern));
                    }
                }
            }
            catch (SQLException e) {
                throw new RedshiftException("MetadataServerAPIHelper.getTablesServerAPI: " + e.getMessage());
            }
        }
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Return intermediate result set for catalog = {0}, schemaPattern = {1}, tableNamePattern = {2}", catalog, schemaPattern, tableNamePattern);
        }
        return intermediateRs;
    }

    protected List<ResultSet> getColumnsServerAPI(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern, boolean retEmpty, boolean isSingleDatabaseMetaData) throws SQLException {
        ArrayList<ResultSet> intermediateRs = new ArrayList<ResultSet>();
        if (!retEmpty) {
            try {
                List<String> catalogList = this.callGetCatalogList(catalog, isSingleDatabaseMetaData);
                for (String curCat : catalogList) {
                    ResultSet schemasRs = this.callShowSchemas(curCat, schemaPattern);
                    while (schemasRs.next()) {
                        String curSchema = schemasRs.getString("schema_name");
                        ResultSet tablesRs = this.callShowTables(curCat, curSchema, tableNamePattern);
                        while (tablesRs.next()) {
                            intermediateRs.add(this.callShowColumns(curCat, curSchema, tablesRs.getString("table_name"), columnNamePattern));
                        }
                    }
                }
            }
            catch (SQLException e) {
                throw new RedshiftException("MetadataServerAPIHelper.getColumnsServerAPI: " + e.getMessage());
            }
        }
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Return intermediate result set for catalog = {0}, schemaPattern = {1}, tableNamePattern = {2}, columnNamePattern = {3}", catalog, schemaPattern, tableNamePattern, columnNamePattern);
        }
        return intermediateRs;
    }

    protected List<String> callGetCatalogList(String catalog, boolean isSingleDatabaseMetaData) throws SQLException {
        List<String> catalogList = null;
        try {
            if (StringUtils.isNullOrEmpty((String)catalog)) {
                catalogList = this.getCatalogList(isSingleDatabaseMetaData);
            } else {
                catalogList = new ArrayList<String>();
                if (isSingleDatabaseMetaData) {
                    if (catalog.equals(this.connection.getCatalog())) {
                        catalogList.add(catalog);
                    }
                } else {
                    catalogList.add(catalog);
                }
            }
        }
        catch (Exception e) {
            throw new RedshiftException("callGetCatalogList: " + e.getMessage());
        }
        if (catalogList == null) {
            throw new RedshiftException("Error when getting catalogList ... ");
        }
        return catalogList;
    }

    protected List<String> getCatalogList(boolean isSingleDatabaseMetaData) throws SQLException {
        ArrayList<String> catalogList = null;
        try {
            String curConnectedCatalog = this.connection.getCatalog();
            catalogList = new ArrayList<String>();
            ResultSet catalogRs = this.getCatalogsServerAPI();
            while (catalogRs.next()) {
                if (isSingleDatabaseMetaData) {
                    String curCatalog = catalogRs.getString("database_name");
                    if (!curCatalog.equals(curConnectedCatalog)) continue;
                    catalogList.add(curCatalog);
                    continue;
                }
                catalogList.add(catalogRs.getString("database_name"));
            }
        }
        catch (SQLException e) {
            throw new RedshiftException("getCatalogList: " + e.getMessage());
        }
        return catalogList;
    }

    protected ResultSet callShowSchemas(String catalog, String schema) throws SQLException {
        if (StringUtils.isNullOrEmpty((String)schema)) {
            return this.callShowSchemasWithOUTLike(catalog);
        }
        return this.callShowSchemasWithLike(catalog, schema);
    }

    protected ResultSet callShowSchemasWithOUTLike(String catalog) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Calling Server API SHOW SCHEMAS on catalog: {0}", catalog);
        }
        return this.runQuery(MessageFormat.format("SHOW SCHEMAS FROM DATABASE {0};", this.callQuoteIdent(catalog)));
    }

    protected ResultSet callShowSchemasWithLike(String catalog, String schema) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Calling Server API SHOW SCHEMAS on catalog: {0}, schemaPattern: {1}", catalog, schema);
        }
        return this.runQuery(MessageFormat.format("SHOW SCHEMAS FROM DATABASE {0} LIKE {1};", this.callQuoteIdent(catalog), this.callQuoteLiteral(schema)));
    }

    protected ResultSet callShowTables(String catalog, String schema, String table) throws SQLException {
        if (StringUtils.isNullOrEmpty((String)table)) {
            return this.callShowTablesWithOUTLike(catalog, schema);
        }
        return this.callShowTablesWithLike(catalog, schema, table);
    }

    protected ResultSet callShowTablesWithOUTLike(String catalog, String schema) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Calling Server API SHOW TABLES on catalog: {0}, schema: {1}", catalog, schema);
        }
        return this.runQuery(MessageFormat.format("SHOW TABLES FROM SCHEMA {0}.{1};", this.callQuoteIdent(catalog), this.callQuoteIdent(schema)));
    }

    protected ResultSet callShowTablesWithLike(String catalog, String schema, String table) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Calling Server API SHOW TABLES on catalog: {0}, schema: {1}, tablePattern: {2}", catalog, schema, table);
        }
        return this.runQuery(MessageFormat.format("SHOW TABLES FROM SCHEMA {0}.{1} LIKE {2};", this.callQuoteIdent(catalog), this.callQuoteIdent(schema), this.callQuoteLiteral(table)));
    }

    protected ResultSet callShowColumns(String catalog, String schema, String table, String column) throws SQLException {
        if (StringUtils.isNullOrEmpty((String)column)) {
            return this.callShowColumnsWithOUTLike(catalog, schema, table);
        }
        return this.callShowColumnsWithLike(catalog, schema, table, column);
    }

    protected ResultSet callShowColumnsWithOUTLike(String catalog, String schema, String table) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Calling Server API SHOW COLUMNS on catalog: {0}, schema: {1}, table: {2}", catalog, schema, table);
        }
        return this.runQuery(MessageFormat.format("SHOW COLUMNS FROM TABLE {0}.{1}.{2};", this.callQuoteIdent(catalog), this.callQuoteIdent(schema), this.callQuoteIdent(table)));
    }

    protected ResultSet callShowColumnsWithLike(String catalog, String schema, String table, String column) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Calling Server API SHOW COLUMNS on catalog: {0}, schema: {1}, table: {2}, columnPattern: {3}", catalog, schema, table, column);
        }
        return this.runQuery(MessageFormat.format("SHOW COLUMNS FROM TABLE {0}.{1}.{2} LIKE {3};", this.callQuoteIdent(catalog), this.callQuoteIdent(schema), this.callQuoteIdent(table), this.callQuoteLiteral(column)));
    }

    protected String callQuoteLiteral(String input) throws SQLException {
        this.prst_QUOTE_LITERAL.setString(1, input);
        this.prst_QUOTE_LITERAL.execute();
        ResultSet rs = this.prst_QUOTE_LITERAL.getResultSet();
        if (rs == null) {
            throw new RedshiftException("callQuoteLiteral: Fail to quote literal: " + input);
        }
        rs.next();
        return rs.getString(1);
    }

    protected String callQuoteIdent(String input) throws SQLException {
        this.prst_QUOTE_IDENT.setString(1, input);
        this.prst_QUOTE_IDENT.execute();
        ResultSet rs = this.prst_QUOTE_IDENT.getResultSet();
        if (rs == null) {
            throw new RedshiftException("callQuoteIdent: Fail to quote identifier: " + input);
        }
        rs.next();
        return rs.getString(1);
    }
}

