/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.gcp.auth;

import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import java.io.IOException;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class NullCredentialInitializer
implements HttpRequestInitializer {
    private static final @UnknownKeyFor @NonNull @Initialized int ACCESS_DENIED = 401;
    private static final @UnknownKeyFor @NonNull @Initialized String NULL_CREDENTIAL_REASON = "Unable to get application default credentials. Please see https://developers.google.com/accounts/docs/application-default-credentials for details on how to specify credentials. This version of the SDK is dependent on the gcloud core component version 2015.02.05 or newer to be able to get credentials from the currently authorized user via gcloud auth.";

    public void initialize(@UnknownKeyFor @NonNull @Initialized HttpRequest httpRequest) throws @UnknownKeyFor @NonNull @Initialized IOException {
        httpRequest.setUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)new NullCredentialHttpUnsuccessfulResponseHandler());
    }

    public static void throwNullCredentialException() {
        throw new RuntimeException(NULL_CREDENTIAL_REASON);
    }

    private static class NullCredentialHttpUnsuccessfulResponseHandler
    implements HttpUnsuccessfulResponseHandler {
        private NullCredentialHttpUnsuccessfulResponseHandler() {
        }

        public @UnknownKeyFor @NonNull @Initialized boolean handleResponse(@UnknownKeyFor @NonNull @Initialized HttpRequest httpRequest, @UnknownKeyFor @NonNull @Initialized HttpResponse httpResponse, @UnknownKeyFor @NonNull @Initialized boolean supportsRetry) throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (!httpResponse.isSuccessStatusCode() && httpResponse.getStatusCode() == 401) {
                NullCredentialInitializer.throwNullCredentialException();
            }
            return supportsRetry;
        }
    }
}

