/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.IExecutionConfiguration;
import org.apache.hop.core.Const;
import org.apache.hop.core.Result;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.IXml;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.pipeline.PipelineMeta;
import org.w3c.dom.Node;

public class PipelineExecutionConfiguration
implements IExecutionConfiguration,
IXml {
    public static final String XML_TAG = "pipeline_execution_configuration";
    private static final String CONST_VALUE = "value";
    private boolean passingExport = false;
    private Map<String, String> parametersMap = new HashMap<String, String>();
    private Map<String, String> variablesMap = new HashMap<String, String>();
    private LogLevel logLevel = LogLevel.BASIC;
    private boolean clearingLog = true;
    private Result previousResult;
    private boolean showingSubComponents = true;
    private boolean setLogfile;
    private boolean setAppendLogfile;
    private String logFileName;
    private boolean createParentFolder;
    private String runConfiguration;
    private boolean logRemoteExecutionLocally;

    public PipelineExecutionConfiguration() {
    }

    @Override
    public Object clone() {
        try {
            PipelineExecutionConfiguration configuration = (PipelineExecutionConfiguration)super.clone();
            configuration.parametersMap = new HashMap<String, String>();
            configuration.parametersMap.putAll(this.parametersMap);
            configuration.variablesMap = new HashMap<String, String>();
            configuration.variablesMap.putAll(this.variablesMap);
            return configuration;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public void setParametersMap(Map<String, String> parametersMap) {
        this.parametersMap = parametersMap;
    }

    @Override
    public Map<String, String> getParametersMap() {
        return this.parametersMap;
    }

    @Override
    public Map<String, String> getVariablesMap() {
        return this.variablesMap;
    }

    @Override
    public void setVariablesMap(Map<String, String> variablesMap) {
        this.variablesMap = variablesMap;
    }

    @Override
    public void setVariablesMap(IVariables variablesMap) {
        this.variablesMap = new HashMap<String, String>();
        for (String name : variablesMap.getVariableNames()) {
            String value = variablesMap.getVariable(name);
            this.variablesMap.put(name, value);
        }
    }

    public void getAllVariables(IVariables variables, PipelineMeta pipelineMeta) {
        String[] keys;
        Properties sp = new Properties();
        for (String key : keys = variables.getVariableNames()) {
            sp.put(key, variables.getVariable(key));
        }
        String[] vars = variables.getVariableNames();
        if (vars != null && vars.length > 0) {
            HashMap<String, String> newVariables = new HashMap<String, String>();
            for (String varname : vars) {
                newVariables.put(varname, Const.NVL((String)this.variablesMap.get(varname), (String)sp.getProperty(varname, "")));
            }
            this.variablesMap.putAll(newVariables);
        }
        for (String variableName : Const.INTERNAL_WORKFLOW_VARIABLES) {
            String value = variables.getVariable(variableName);
            if (Utils.isEmpty((CharSequence)value)) continue;
            this.variablesMap.put(variableName, value);
        }
    }

    public void getUsedVariables(IVariables variables, PipelineMeta pipelineMeta) {
        String[] keys;
        Properties sp = new Properties();
        for (String key : keys = variables.getVariableNames()) {
            if (!StringUtils.isNotEmpty((String)key)) continue;
            sp.put(key, Const.NVL((String)variables.getVariable(key), (String)""));
        }
        List<String> vars = pipelineMeta.getUsedVariables();
        if (!Utils.isEmpty(vars)) {
            HashMap<String, String> newVariables = new HashMap<String, String>();
            for (String varname : vars) {
                if (varname.startsWith("Internal")) continue;
                newVariables.put(varname, Const.NVL((String)this.variablesMap.get(varname), (String)sp.getProperty(varname, "")));
            }
            this.variablesMap.putAll(newVariables);
        }
        for (String variableName : Const.INTERNAL_WORKFLOW_VARIABLES) {
            String value = variables.getVariable(variableName);
            if (Utils.isEmpty((CharSequence)value)) continue;
            this.variablesMap.put(variableName, value);
        }
    }

    @Override
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Override
    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public String getXml(IVariables variables) {
        StringBuilder xml = new StringBuilder(200);
        xml.append("  <pipeline_execution_configuration>").append(Const.CR);
        xml.append("    ").append(XmlHandler.addTagValue((String)"pass_export", (boolean)this.passingExport));
        xml.append("    <parameters>").append(Const.CR);
        ArrayList<String> paramNames = new ArrayList<String>(this.parametersMap.keySet());
        Collections.sort(paramNames);
        for (String name : paramNames) {
            String value = this.parametersMap.get(name);
            xml.append("    <parameter>");
            xml.append(XmlHandler.addTagValue((String)"name", (String)name, (boolean)false, (String[])new String[0]));
            xml.append(XmlHandler.addTagValue((String)CONST_VALUE, (String)value, (boolean)false, (String[])new String[0]));
            xml.append("</parameter>").append(Const.CR);
        }
        xml.append("    </parameters>").append(Const.CR);
        xml.append("    <variables>").append(Const.CR);
        ArrayList<String> variableNames = new ArrayList<String>(this.variablesMap.keySet());
        Collections.sort(variableNames);
        for (String name : variableNames) {
            String value = this.variablesMap.get(name);
            xml.append("    <variable>");
            xml.append(XmlHandler.addTagValue((String)"name", (String)name, (boolean)false, (String[])new String[0]));
            xml.append(XmlHandler.addTagValue((String)CONST_VALUE, (String)value, (boolean)false, (String[])new String[0]));
            xml.append("</variable>").append(Const.CR);
        }
        xml.append("    </variables>").append(Const.CR);
        xml.append("    ").append(XmlHandler.addTagValue((String)"log_level", (String)this.logLevel.getCode()));
        xml.append("    ").append(XmlHandler.addTagValue((String)"log_file", (boolean)this.setLogfile));
        xml.append("    ").append(XmlHandler.addTagValue((String)"log_filename", (String)this.logFileName));
        xml.append("    ").append(XmlHandler.addTagValue((String)"log_file_append", (boolean)this.setAppendLogfile));
        xml.append("    ").append(XmlHandler.addTagValue((String)"create_parent_folder", (boolean)this.createParentFolder));
        xml.append("    ").append(XmlHandler.addTagValue((String)"clear_log", (boolean)this.clearingLog));
        xml.append("    ").append(XmlHandler.addTagValue((String)"show_subcomponents", (boolean)this.showingSubComponents));
        xml.append("    ").append(XmlHandler.addTagValue((String)"run_configuration", (String)this.runConfiguration));
        if (this.previousResult != null) {
            xml.append(this.previousResult.getXml());
        }
        xml.append("</pipeline_execution_configuration>").append(Const.CR);
        return xml.toString();
    }

    public PipelineExecutionConfiguration(Node trecNode) throws HopException {
        this();
        this.passingExport = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)trecNode, (String)"pass_export"));
        Node varsNode = XmlHandler.getSubNode((Node)trecNode, (String)"variables");
        int nrVariables = XmlHandler.countNodes((Node)varsNode, (String)"variable");
        for (int i = 0; i < nrVariables; ++i) {
            Node argNode = XmlHandler.getSubNodeByNr((Node)varsNode, (String)"variable", (int)i);
            String name = XmlHandler.getTagValue((Node)argNode, (String)"name");
            String value = XmlHandler.getTagValue((Node)argNode, (String)CONST_VALUE);
            if (Utils.isEmpty((CharSequence)name)) continue;
            this.variablesMap.put(name, Const.NVL((String)value, (String)""));
        }
        Node parmsNode = XmlHandler.getSubNode((Node)trecNode, (String)"parameters");
        int nrParams = XmlHandler.countNodes((Node)parmsNode, (String)"parameter");
        for (int i = 0; i < nrParams; ++i) {
            Node parmNode = XmlHandler.getSubNodeByNr((Node)parmsNode, (String)"parameter", (int)i);
            String name = XmlHandler.getTagValue((Node)parmNode, (String)"name");
            String value = XmlHandler.getTagValue((Node)parmNode, (String)CONST_VALUE);
            if (Utils.isEmpty((CharSequence)name)) continue;
            this.parametersMap.put(name, value);
        }
        this.logLevel = LogLevel.lookupCode((String)XmlHandler.getTagValue((Node)trecNode, (String)"log_level"));
        this.setLogfile = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)trecNode, (String)"log_file"));
        this.logFileName = XmlHandler.getTagValue((Node)trecNode, (String)"log_filename");
        this.setAppendLogfile = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)trecNode, (String)"log_file_append"));
        this.createParentFolder = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)trecNode, (String)"create_parent_folder"));
        this.clearingLog = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)trecNode, (String)"clear_log"));
        this.showingSubComponents = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)trecNode, (String)"show_subcomponents"));
        this.runConfiguration = XmlHandler.getTagValue((Node)trecNode, (String)"run_configuration");
        Node resultNode = XmlHandler.getSubNode((Node)trecNode, (String)"result");
        if (resultNode != null) {
            try {
                this.previousResult = new Result(resultNode);
            }
            catch (HopException e) {
                throw new HopException("Unable to hydrate previous result", (Throwable)e);
            }
        }
    }

    @Override
    public Result getPreviousResult() {
        return this.previousResult;
    }

    @Override
    public void setPreviousResult(Result previousResult) {
        this.previousResult = previousResult;
    }

    @Override
    public boolean isClearingLog() {
        return this.clearingLog;
    }

    @Override
    public void setClearingLog(boolean clearingLog) {
        this.clearingLog = clearingLog;
    }

    public boolean isPassingExport() {
        return this.passingExport;
    }

    public void setPassingExport(boolean passingExport) {
        this.passingExport = passingExport;
    }

    public boolean isShowingSubComponents() {
        return this.showingSubComponents;
    }

    public void setShowingSubComponents(boolean showingSubComponents) {
        this.showingSubComponents = showingSubComponents;
    }

    public boolean isSetLogfile() {
        return this.setLogfile;
    }

    public void setSetLogfile(boolean setLogfile) {
        this.setLogfile = setLogfile;
    }

    public boolean isSetAppendLogfile() {
        return this.setAppendLogfile;
    }

    public void setSetAppendLogfile(boolean setAppendLogfile) {
        this.setAppendLogfile = setAppendLogfile;
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public void setLogFileName(String fileName) {
        this.logFileName = fileName;
    }

    public boolean isCreateParentFolder() {
        return this.createParentFolder;
    }

    public void setCreateParentFolder(boolean createParentFolder) {
        this.createParentFolder = createParentFolder;
    }

    @Override
    public String getRunConfiguration() {
        return this.runConfiguration;
    }

    @Override
    public void setRunConfiguration(String runConfiguration) {
        this.runConfiguration = runConfiguration;
    }

    public boolean isLogRemoteExecutionLocally() {
        return this.logRemoteExecutionLocally;
    }

    public void setLogRemoteExecutionLocally(boolean logRemoteExecutionLocally) {
        this.logRemoteExecutionLocally = logRemoteExecutionLocally;
    }
}

