/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.HopServerServlet;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.logging.LoggingObjectType;
import org.apache.hop.core.logging.SimpleLoggingObject;
import org.apache.hop.core.util.Utils;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.workflow.WorkflowConfiguration;
import org.apache.hop.workflow.WorkflowExecutionConfiguration;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.config.WorkflowRunConfiguration;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.apache.hop.workflow.engine.WorkflowEngineFactory;
import org.apache.hop.www.BaseHttpServlet;
import org.apache.hop.www.IHopServerPlugin;
import org.apache.hop.www.WebResult;
import org.apache.hop.www.WorkflowMap;

@HopServerServlet(id="execWorkflow", name="Execute workflow from file path")
public class ExecWorkflowServlet
extends BaseHttpServlet
implements IHopServerPlugin {
    private static final long serialVersionUID = -5879219287669847357L;
    private static final String UNABLE_TO_FIND_WORKFLOW = "Unable to find workflow";
    private static final String WORKFLOW = "workflow";
    private static final String LEVEL = "level";
    private static final String RUN_CONFIG = "runConfig";
    public static final String CONTEXT_PATH = "/hop/execWorkflow";

    public ExecWorkflowServlet() {
    }

    public ExecWorkflowServlet(WorkflowMap workflowMap) {
        super(workflowMap);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug("Execute workflow requested");
        }
        String[] knownOptions = new String[]{WORKFLOW, LEVEL, RUN_CONFIG};
        String workflowOption = request.getParameter(WORKFLOW);
        String levelOption = request.getParameter(LEVEL);
        String runConfigOption = request.getParameter(RUN_CONFIG);
        response.setStatus(200);
        String encoding = System.getProperty("HOP_DEFAULT_SERVLET_ENCODING", null);
        if (encoding != null && !Utils.isEmpty((CharSequence)encoding.trim())) {
            response.setCharacterEncoding(encoding);
            response.setContentType("text/html; charset=" + encoding);
        } else {
            response.setContentType("text/xml");
            response.setCharacterEncoding("UTF-8");
        }
        PrintWriter out = response.getWriter();
        if (workflowOption == null) {
            response.setStatus(400);
            out.println(new WebResult("ERROR", "Missing mandatory parameter: workflow"));
            return;
        }
        try {
            WorkflowRunConfiguration defaultRunConfiguration;
            MultiMetadataProvider metadataProvider = this.getServerConfig().getMetadataProvider();
            if (metadataProvider == null) {
                throw new HopException("Metadata provider is not available");
            }
            String resolvedWorkflowPath = this.variables.resolve(workflowOption);
            WorkflowMeta workflowMeta = new WorkflowMeta(this.variables, resolvedWorkflowPath, (IHopMetadataProvider)metadataProvider);
            String[] parameters = workflowMeta.listParameters();
            Enumeration parameterNames = request.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String parameter = (String)parameterNames.nextElement();
                String[] values = request.getParameterValues(parameter);
                if (Const.indexOfString((String)parameter, (String[])knownOptions) >= 0 || Const.indexOfString((String)parameter, (String[])parameters) >= 0) continue;
                this.variables.setVariable(parameter, values[0]);
            }
            WorkflowExecutionConfiguration workflowExecutionConfiguration = new WorkflowExecutionConfiguration();
            LogLevel logLevel = null;
            if (!Utils.isEmpty((CharSequence)levelOption)) {
                logLevel = LogLevel.lookupCode((String)levelOption);
            }
            if (logLevel != null) {
                workflowExecutionConfiguration.setLogLevel(logLevel);
            }
            String runConfigurationName = !StringUtils.isEmpty((String)runConfigOption) ? runConfigOption : ((defaultRunConfiguration = WorkflowRunConfiguration.findDefault((IHopMetadataProvider)metadataProvider)) != null ? defaultRunConfiguration.getName() : "local");
            workflowExecutionConfiguration.setRunConfiguration(runConfigurationName);
            String serverObjectId = UUID.randomUUID().toString();
            SimpleLoggingObject servletLoggingObject = new SimpleLoggingObject(CONTEXT_PATH, LoggingObjectType.HOP_SERVER, null);
            servletLoggingObject.setContainerObjectId(serverObjectId);
            if (logLevel != null) {
                servletLoggingObject.setLogLevel(logLevel);
            }
            IWorkflowEngine<WorkflowMeta> workflow = WorkflowEngineFactory.createWorkflowEngine(this.variables, this.variables.resolve(workflowExecutionConfiguration.getRunConfiguration()), (IHopMetadataProvider)metadataProvider, workflowMeta, (ILoggingObject)servletLoggingObject);
            workflow.setMetadataProvider((IHopMetadataProvider)metadataProvider);
            workflow.copyParametersFromDefinitions(workflowMeta);
            for (String parameter : parameters) {
                String value = request.getParameter(parameter);
                if (value == null) continue;
                workflow.setParameterValue(parameter, value);
            }
            workflow.activateParameters(workflow);
            WorkflowConfiguration workflowConfiguration = new WorkflowConfiguration(workflowMeta, workflowExecutionConfiguration, (IHopMetadataProvider)metadataProvider);
            this.getWorkflowMap().addWorkflow(workflowMeta.getName(), serverObjectId, workflow, workflowConfiguration);
            workflow.setContainerId(serverObjectId);
            this.executeWorkflow(workflow);
            String logging = HopLogStore.getAppender().getBuffer(workflow.getLogChannelId(), false).toString();
            Result result = workflow.getResult();
            if (workflow.isFinished() && (result == null || result.getNrErrors() > 0L)) {
                response.setStatus(500);
                out.println(new WebResult("ERROR", "Error executing workflow: " + logging));
            } else {
                out.println(new WebResult("OK", "Workflow executed successfully"));
            }
            out.flush();
        }
        catch (Exception ex) {
            if (ex.getMessage() != null && ex.getMessage().contains(UNABLE_TO_FIND_WORKFLOW)) {
                response.setStatus(404);
                out.println(new WebResult("ERROR", "Unable to find workflow: " + workflowOption + " (resolved: " + (workflowOption != null ? this.variables.resolve(workflowOption) : "null") + ")"));
            }
            String logging = Const.getStackTracker((Throwable)ex);
            response.setStatus(500);
            out.println(new WebResult("ERROR", "Unexpected error executing workflow: " + Const.CR + logging));
        }
    }

    protected void executeWorkflow(IWorkflowEngine<WorkflowMeta> workflow) throws HopException {
        workflow.startExecution();
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }

    @Override
    public String getService() {
        return "/hop/execWorkflow (" + this.toString() + ")";
    }

    public String toString() {
        return "Execute workflow from file";
    }
}

