/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.BoundedBlockingSubpartition;
import org.apache.flink.runtime.io.network.partition.BoundedData;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;

final class BoundedBlockingSubpartitionReader
implements ResultSubpartitionView {
    private final BoundedBlockingSubpartition parent;
    private final BufferAvailabilityListener availabilityListener;
    @Nullable
    private Buffer nextBuffer;
    @Nullable
    private BoundedData.Reader dataReader;
    private int dataBufferBacklog;
    private boolean isReleased;
    private int sequenceNumber;

    BoundedBlockingSubpartitionReader(BoundedBlockingSubpartition parent, BoundedData data, int numDataBuffers, BufferAvailabilityListener availabilityListener) throws IOException {
        this.parent = (BoundedBlockingSubpartition)Preconditions.checkNotNull((Object)parent);
        Preconditions.checkNotNull((Object)data);
        this.dataReader = data.createReader(this);
        this.nextBuffer = this.dataReader.nextBuffer();
        Preconditions.checkArgument((numDataBuffers >= 0 ? 1 : 0) != 0);
        this.dataBufferBacklog = numDataBuffers;
        this.availabilityListener = (BufferAvailabilityListener)Preconditions.checkNotNull((Object)availabilityListener);
    }

    @Override
    @Nullable
    public ResultSubpartition.BufferAndBacklog getNextBuffer() throws IOException {
        Buffer current = this.nextBuffer;
        if (current == null) {
            return null;
        }
        if (current.isBuffer()) {
            --this.dataBufferBacklog;
        }
        assert (this.dataReader != null);
        this.nextBuffer = this.dataReader.nextBuffer();
        Buffer.DataType nextDataType = this.nextBuffer != null ? this.nextBuffer.getDataType() : Buffer.DataType.NONE;
        return ResultSubpartition.BufferAndBacklog.fromBufferAndLookahead(current, nextDataType, this.dataBufferBacklog, this.sequenceNumber++);
    }

    @Override
    public void notifyDataAvailable() {
        if (this.nextBuffer == null) {
            assert (this.dataReader != null);
            try {
                this.nextBuffer = this.dataReader.nextBuffer();
            }
            catch (IOException ex) {
                throw new IllegalStateException("No data available while reading", ex);
            }
            if (this.nextBuffer != null) {
                this.availabilityListener.notifyDataAvailable(this);
            }
        }
    }

    @Override
    public void releaseAllResources() throws IOException {
        this.isReleased = true;
        IOUtils.closeQuietly((AutoCloseable)this.dataReader);
        this.nextBuffer = null;
        this.dataReader = null;
        this.parent.releaseReaderReference(this);
    }

    @Override
    public boolean isReleased() {
        return this.isReleased;
    }

    @Override
    public void resumeConsumption() {
        throw new UnsupportedOperationException("Method should never be called.");
    }

    @Override
    public void acknowledgeAllDataProcessed() {
    }

    @Override
    public ResultSubpartitionView.AvailabilityWithBacklog getAvailabilityAndBacklog(boolean isCreditAvailable) {
        boolean isAvailable = isCreditAvailable ? this.nextBuffer != null : this.nextBuffer != null && !this.nextBuffer.isBuffer();
        return new ResultSubpartitionView.AvailabilityWithBacklog(isAvailable, this.dataBufferBacklog);
    }

    @Override
    public Throwable getFailureCause() {
        return null;
    }

    @Override
    public int unsynchronizedGetNumberOfQueuedBuffers() {
        return this.parent.unsynchronizedGetNumberOfQueuedBuffers();
    }

    @Override
    public int getNumberOfQueuedBuffers() {
        return this.parent.getNumberOfQueuedBuffers();
    }

    @Override
    public void notifyNewBufferSize(int newBufferSize) {
        this.parent.bufferSize(newBufferSize);
    }

    @Override
    public int peekNextBufferSubpartitionId() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return String.format("Blocking Subpartition Reader: ID=%s, index=%d", this.parent.parent.getPartitionId(), this.parent.getSubPartitionIndex());
    }
}

