/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty;

import java.util.Objects;
import java.util.Random;

public class NettyConnectionId {
    private static final Random RANDOM_SEED = new Random();
    private final long lowerPart;
    private final long upperPart;

    private NettyConnectionId(long lowerPart, long upperPart) {
        this.lowerPart = lowerPart;
        this.upperPart = upperPart;
    }

    public static NettyConnectionId newId() {
        return new NettyConnectionId(RANDOM_SEED.nextLong(), RANDOM_SEED.nextLong());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NettyConnectionId that = (NettyConnectionId)o;
        return this.lowerPart == that.lowerPart && this.upperPart == that.upperPart;
    }

    public int hashCode() {
        return Objects.hash(this.lowerPart, this.upperPart);
    }
}

