/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.widget.highlight;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.database.SqlScriptStatement;
import org.apache.hop.core.util.Utils;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.highlight.StyleAttribute;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;

public class SqlHighlight
implements LineStyleListener {
    SqlScanner scanner;
    StyleAttribute[] styleAttributes;
    ArrayList<int[]> blockComments = new ArrayList();
    public static final int EOF = -1;
    public static final int EOL = 10;
    public static final int WORD = 0;
    public static final int WHITE = 1;
    public static final int KEY = 2;
    public static final int COMMENT = 3;
    public static final int SYMBOL = 4;
    public static final int STRING = 5;
    public static final int OTHER = 6;
    public static final int NUMBER = 7;
    public static final int FUNCTION = 8;
    public static final int PARAM = 9;
    public static final int MAXIMUM_TOKEN = 10;
    private List<SqlScriptStatement> scriptStatements;

    public SqlHighlight() {
        this(List.of());
    }

    public SqlHighlight(List<String> functionNames) {
        this.initializeStyles();
        this.scriptStatements = new ArrayList<SqlScriptStatement>();
        this.scanner = new SqlScanner(functionNames);
    }

    StyleAttribute getStyleAttribute(int type) {
        if (type < 0 || type >= this.styleAttributes.length) {
            return null;
        }
        return this.styleAttributes[type];
    }

    boolean inBlockComment(int start, int end) {
        for (int[] offsets : this.blockComments) {
            if (offsets[0] >= start && offsets[0] <= end) {
                return true;
            }
            if (offsets[1] >= start && offsets[1] <= end) {
                return true;
            }
            if (offsets[0] > start || offsets[1] < end) continue;
            return true;
        }
        return false;
    }

    void initializeStyles() {
        GuiResource resource = GuiResource.getInstance();
        this.styleAttributes = new StyleAttribute[10];
        this.styleAttributes[0] = new StyleAttribute(resource.getColorBlack(), 0);
        this.styleAttributes[1] = new StyleAttribute(resource.getColorBlack(), 0);
        this.styleAttributes[5] = new StyleAttribute(resource.getColorDarkGreen(), 0);
        this.styleAttributes[6] = new StyleAttribute(resource.getColorBlack(), 0);
        this.styleAttributes[7] = new StyleAttribute(resource.getColorOrange(), 0);
        this.styleAttributes[9] = new StyleAttribute(resource.getColor(148, 0, 211), 1);
        if (PropsUi.getInstance().isDarkMode()) {
            this.styleAttributes[3] = new StyleAttribute(resource.getColorGray(), 2);
            this.styleAttributes[2] = new StyleAttribute(resource.getColor(30, 144, 255), 0);
            this.styleAttributes[4] = new StyleAttribute(resource.getColor(243, 126, 131), 0);
            this.styleAttributes[8] = new StyleAttribute(resource.getColor(177, 102, 218), 0);
        } else {
            this.styleAttributes[3] = new StyleAttribute(resource.getColorDarkGray(), 2);
            this.styleAttributes[2] = new StyleAttribute(resource.getColorBlue(), 0);
            this.styleAttributes[4] = new StyleAttribute(resource.getColorDarkRed(), 0);
            this.styleAttributes[8] = new StyleAttribute(resource.getColor(148, 0, 211), 0);
        }
    }

    public void lineGetStyle(LineStyleEvent event) {
        ArrayList<StyleRange> styles = new ArrayList<StyleRange>();
        if (this.inBlockComment(event.lineOffset, event.lineOffset + event.lineText.length())) {
            StyleAttribute attribute = this.getStyleAttribute(3);
            styles.add(new StyleRange(event.lineOffset, event.lineText.length() + 4, attribute.getForeground(), null, attribute.getStyle()));
            event.styles = styles.toArray(new StyleRange[styles.size()]);
            return;
        }
        this.scanner.setRange(event.lineText);
        String xs = ((StyledText)event.widget).getText();
        if (xs != null) {
            this.parseBlockComments(xs);
        }
        int token = this.scanner.nextToken();
        while (token != -1) {
            if (token != 6) {
                if (token == 1 && !styles.isEmpty()) {
                    int start = this.scanner.getStartOffset() + event.lineOffset;
                    lastStyle = (StyleRange)styles.get(styles.size() - 1);
                    if (lastStyle.fontStyle != 0 && lastStyle.start + lastStyle.length == start) {
                        lastStyle.length += this.scanner.getLength();
                    }
                } else {
                    StyleAttribute attribute = this.getStyleAttribute(token);
                    if (attribute != this.styleAttributes[0]) {
                        StyleRange styleRange = new StyleRange(this.scanner.getStartOffset() + event.lineOffset, this.scanner.getLength(), attribute.getForeground(), null, attribute.getStyle());
                        if (styles.isEmpty()) {
                            styles.add(styleRange);
                        } else {
                            lastStyle = (StyleRange)styles.get(styles.size() - 1);
                            if (lastStyle.similarTo(styleRange) && lastStyle.start + lastStyle.length == styleRange.start) {
                                lastStyle.length += styleRange.length;
                            } else {
                                styles.add(styleRange);
                            }
                        }
                    }
                }
            }
            token = this.scanner.nextToken();
        }
        if (this.scriptStatements != null) {
            for (SqlScriptStatement statement : this.scriptStatements) {
                StyleRange styleRange = new StyleRange();
                styleRange.start = statement.getFromIndex();
                styleRange.length = statement.getToIndex() - statement.getFromIndex();
                styleRange.background = statement.isComplete() ? (statement.isOk() ? GuiResource.getInstance().getColor(244, 238, 224) : GuiResource.getInstance().getColor(250, 235, 215)) : GuiResource.getInstance().getColorWhite();
                styles.add(styleRange);
            }
        }
        event.styles = styles.toArray(new StyleRange[styles.size()]);
    }

    public void parseBlockComments(String text) {
        this.blockComments = new ArrayList();
        StringReader buffer = new StringReader(text);
        boolean blkComment = false;
        int cnt = 0;
        int[] offsets = new int[2];
        boolean done = false;
        try {
            block7: while (!done) {
                int ch = buffer.read();
                switch (ch) {
                    case -1: {
                        if (blkComment) {
                            offsets[1] = cnt;
                            this.blockComments.add(offsets);
                        }
                        done = true;
                        continue block7;
                    }
                    case 47: {
                        ch = buffer.read();
                        if (ch == 42 && !blkComment) {
                            offsets = new int[2];
                            offsets[0] = cnt++;
                            blkComment = true;
                        } else {
                            ++cnt;
                        }
                        ++cnt;
                        continue block7;
                    }
                    case 42: {
                        if (blkComment) {
                            ch = buffer.read();
                            ++cnt;
                            if (ch == 47) {
                                blkComment = false;
                                offsets[1] = cnt;
                                this.blockComments.add(offsets);
                            }
                        }
                        ++cnt;
                        continue block7;
                    }
                }
                ++cnt;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public List<SqlScriptStatement> getScriptStatements() {
        return this.scriptStatements;
    }

    public void setScriptStatements(List<SqlScriptStatement> scriptStatements) {
        this.scriptStatements = scriptStatements;
    }

    public class SqlScanner {
        protected Map<String, Integer> reservedKeywords = new HashMap<String, Integer>();
        protected Map<String, Integer> reservedFunctionNames = new HashMap<String, Integer>();
        protected StringBuilder fBuffer = new StringBuilder();
        protected String fDoc;
        protected int fPos;
        protected int fEnd;
        protected int fStartToken;
        protected boolean fEofSeen = false;
        private static final List<String> DEFAULT_FUNCTIONS = List.of("getdate", "case", "convert", "left", "right", "isnumeric", "isdate", "isnumber", "number", "finally", "cast", "var", "fetch_status", "isnull", "charindex", "difference", "len", "nchar", "quotename", "replicate", "reverse", "str", "stuff", "unicode", "ascii", "char", "to_char", "to_date", "to_number", "nvl", "sysdate", "corr", "count", "grouping", "max", "min", "stdev", "sum", "concat", "length", "locate", "ltrim", "posstr", "repeat", "replace", "rtrim", "soundex", "space", "substr", "substring", "trunc", "nextval", "currval", "getclobval", "char_length", "compare", "patindex", "sortkey", "uscalar", "current_date", "current_time", "current_timestamp", "current_user", "session_user", "system_user", "curdate", "curtime", "database", "now", "sysdate", "today", "user", "version", "coalesce", "nullif", "octet_length", "datalength", "decode", "greatest", "ifnull", "least", "char_length", "character_length", "collate", "concatenate", "like", "lower", "position", "translate", "upper", "char_octet_length", "character_maximum_length", "character_octet_length", "ilike", "initcap", "instr", "lcase", "lpad", "patindex", "rpad", "ucase", "bit_length", "abs", "asin", "atan", "ceiling", "cos", "cot", "exp", "floor", "ln", "log", "log10", "mod", "pi", "power", "rand", "round", "sign", "sin", "sqrt", "tan", "trunc", "extract", "interval", "overlaps", "adddate", "age", "date_add", "dateformat", "date_part", "date_sub", "datediff", "dateadd", "datename", "datepart", "day", "dayname", "dayofmonth", "dayofweek", "dayofyear", "hour", "last_day", "minute", "month", "month_between", "monthname", "next_day", "second", "sub_date", "week", "year", "dbo", "log", "objectproperty");
        private static final List<String> KEYWORDS = List.of("create", "procedure", "as", "set", "nocount", "on", "declare", "varchar", "print", "table", "int", "tintytext", "select", "from", "where", "and", "or", "insert", "into", "cursor", "read_only", "for", "open", "fetch", "next", "end", "deallocate", "table", "drop", "exec", "begin", "close", "update", "delete", "truncate", "left", "inner", "outer", "cross", "join", "union", "all", "float", "when", "nolock", "with", "false", "datetime", "dare", "time", "hour", "array", "minute", "second", "millisecond", "view", "function", "catch", "const", "continue", "compute", "browse", "option", "date", "default", "do", "raw", "auto", "explicit", "xmldata", "elements", "binary", "base64", "read", "outfile", "asc", "desc", "else", "eval", "escape", "having", "limit", "offset", "of", "intersect", "except", "using", "variance", "specific", "language", "body", "returns", "specific", "deterministic", "not", "external", "action", "reads", "static", "inherit", "called", "order", "group", "by", "natural", "full", "exists", "between", "some", "any", "unique", "match", "value", "limite", "minus", "references", "grant", "on", "top", "index", "bigint", "text", "char", "use", "move", "exec", "init", "name", "noskip", "skip", "noformat", "format", "stats", "disk", "from", "to", "rownum", "alter", "add", "remove", "move", "alter", "add", "remove", "lineno", "modify", "if", "else", "in", "is", "new", "Number", "null", "string", "switch", "this", "then", "throw", "true", "false", "try", "return", "with", "while", "start", "connect", "optimize", "first", "only", "rows", "sequence", "blob", "clob", "image", "binary", "column", "decimal", "distinct", "primary", "key", "timestamp", "varbinary", "nvarchar", "nchar", "longnvarchar", "nclob", "numeric", "constraint", "dbcc", "backup", "bit", "clustered", "pad_index", "off", "statistics_norecompute", "ignore_dup_key", "allow_row_locks", "allow_page_locks", "textimage_on", "double", "rollback", "tran", "transaction", "commit");

        public SqlScanner(List<String> functionNames) {
            this.addKeywords(KEYWORDS);
            this.addFunctionNames(functionNames);
            if (this.reservedFunctionNames.isEmpty()) {
                this.addFunctionNames(DEFAULT_FUNCTIONS);
            }
        }

        public void addKeywords(List<String> keywords) {
            if (Utils.isEmpty(keywords)) {
                return;
            }
            keywords.forEach(name -> this.reservedKeywords.put((String)name, 2));
        }

        public void addFunctionNames(List<String> functionNames) {
            if (Utils.isEmpty(functionNames)) {
                return;
            }
            functionNames.forEach(name -> this.reservedFunctionNames.put((String)name, 8));
        }

        public final int getLength() {
            return this.fPos - this.fStartToken;
        }

        public final int getStartOffset() {
            return this.fStartToken;
        }

        public int nextToken() {
            this.fStartToken = this.fPos;
            int c = this.read();
            switch (c) {
                case -1: {
                    return -1;
                }
                case 47: {
                    c = this.read();
                    if (c == 47) {
                        while ((c = this.read()) != -1 && c != 10) {
                        }
                        this.unread(c);
                        return 3;
                    }
                    this.unread(c);
                    return 4;
                }
                case 45: {
                    c = this.read();
                    if (c == 45) {
                        while ((c = this.read()) != -1 && c != 10) {
                        }
                        this.unread(c);
                        return 3;
                    }
                    this.unread(c);
                    return 4;
                }
                case 39: {
                    block22: while (true) {
                        c = this.read();
                        switch (c) {
                            case 39: {
                                return 5;
                            }
                            case -1: {
                                this.unread(c);
                                return 5;
                            }
                            case 92: {
                                c = this.read();
                                continue block22;
                            }
                        }
                    }
                }
                case 34: {
                    block23: while (true) {
                        c = this.read();
                        switch (c) {
                            case 34: {
                                return 5;
                            }
                            case -1: {
                                this.unread(c);
                                return 5;
                            }
                            case 92: {
                                c = this.read();
                                continue block23;
                            }
                        }
                    }
                }
                case 33: 
                case 37: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 46: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 94: {
                    return 4;
                }
                case 63: {
                    return 9;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    while (Character.isDigit((char)(c = this.read()))) {
                    }
                    this.unread(c);
                    return 7;
                }
            }
            if (Character.isWhitespace((char)c)) {
                while (Character.isWhitespace((char)(c = this.read()))) {
                }
                this.unread(c);
                return 1;
            }
            if (Character.isJavaIdentifierStart((char)c)) {
                this.fBuffer.setLength(0);
                do {
                    this.fBuffer.append((char)c);
                } while (Character.isJavaIdentifierPart((char)(c = this.read())));
                this.unread(c);
                String name = this.fBuffer.toString();
                if (c == 40) {
                    Integer token = this.reservedFunctionNames.get(name);
                    if (token != null) {
                        return token;
                    }
                } else {
                    Integer token = this.reservedKeywords.get(name);
                    if (token != null) {
                        return token;
                    }
                }
                return 0;
            }
            return 6;
        }

        protected int read() {
            if (this.fPos <= this.fEnd) {
                return this.fDoc.charAt(this.fPos++);
            }
            return -1;
        }

        public void setRange(String text) {
            this.fDoc = text.toLowerCase();
            this.fPos = 0;
            this.fEnd = this.fDoc.length() - 1;
        }

        protected void unread(int c) {
            if (c != -1) {
                --this.fPos;
            }
        }
    }
}

