/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.wire;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.util.VarInt;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.UnsafeByteOperations;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.ByteStreams;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public class ByteStringCoder
extends AtomicCoder<ByteString> {
    private static final @UnknownKeyFor @NonNull @Initialized ByteStringCoder INSTANCE = new ByteStringCoder();
    private static final @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized ByteString> TYPE_DESCRIPTOR = new TypeDescriptor<ByteString>(){};

    public static @UnknownKeyFor @NonNull @Initialized ByteStringCoder of() {
        return INSTANCE;
    }

    private ByteStringCoder() {
    }

    public void encode(@UnknownKeyFor @NonNull @Initialized ByteString value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
        this.encode(value, outStream, Coder.Context.NESTED);
    }

    public void encode(@UnknownKeyFor @NonNull @Initialized ByteString value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
        if (value == null) {
            throw new CoderException("cannot encode a null ByteString");
        }
        if (!context.isWholeStream) {
            VarInt.encode((int)value.size(), (OutputStream)outStream);
        }
        value.writeTo(outStream);
    }

    public @UnknownKeyFor @NonNull @Initialized ByteString decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.decode(inStream, Coder.Context.NESTED);
    }

    public @UnknownKeyFor @NonNull @Initialized ByteString decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (context.isWholeStream) {
            return ByteString.readFrom((InputStream)inStream);
        }
        int size = VarInt.decodeInt((InputStream)inStream);
        if (size == 0) {
            return ByteString.EMPTY;
        }
        byte[] buf = new byte[size];
        ByteStreams.readFully((InputStream)inStream, (byte[])buf, (int)0, (int)size);
        return UnsafeByteOperations.unsafeWrap((byte[])buf, (int)0, (int)size);
    }

    protected @UnknownKeyFor @NonNull @Initialized long getEncodedElementByteSize(@UnknownKeyFor @NonNull @Initialized ByteString value) throws @UnknownKeyFor @NonNull @Initialized Exception {
        int size = value.size();
        return (long)VarInt.getLength((int)size) + (long)size;
    }

    public void verifyDeterministic() {
    }

    public @UnknownKeyFor @NonNull @Initialized boolean consistentWithEquals() {
        return true;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isRegisterByteSizeObserverCheap(@UnknownKeyFor @NonNull @Initialized ByteString value) {
        return true;
    }

    public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized ByteString> getEncodedTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }
}

