/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import org.apache.beam.sdk.io.gcp.bigtable.BigtableWriteSchemaTransformProvider;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;

final class AutoValue_BigtableWriteSchemaTransformProvider_BigtableWriteSchemaTransformConfiguration
extends BigtableWriteSchemaTransformProvider.BigtableWriteSchemaTransformConfiguration {
    private final String tableId;
    private final String instanceId;
    private final String projectId;

    private AutoValue_BigtableWriteSchemaTransformProvider_BigtableWriteSchemaTransformConfiguration(String tableId, String instanceId, String projectId) {
        this.tableId = tableId;
        this.instanceId = instanceId;
        this.projectId = projectId;
    }

    @Override
    @SchemaFieldDescription(value="Bigtable table ID to write data into.")
    public String getTableId() {
        return this.tableId;
    }

    @Override
    @SchemaFieldDescription(value="Bigtable instance ID where the table is located.")
    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    @SchemaFieldDescription(value="Google Cloud project ID containing the Bigtable instance.")
    public String getProjectId() {
        return this.projectId;
    }

    public String toString() {
        return "BigtableWriteSchemaTransformConfiguration{tableId=" + this.tableId + ", instanceId=" + this.instanceId + ", projectId=" + this.projectId + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BigtableWriteSchemaTransformProvider.BigtableWriteSchemaTransformConfiguration) {
            BigtableWriteSchemaTransformProvider.BigtableWriteSchemaTransformConfiguration that = (BigtableWriteSchemaTransformProvider.BigtableWriteSchemaTransformConfiguration)o;
            return this.tableId.equals(that.getTableId()) && this.instanceId.equals(that.getInstanceId()) && this.projectId.equals(that.getProjectId());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.tableId.hashCode();
        h$ *= 1000003;
        h$ ^= this.instanceId.hashCode();
        h$ *= 1000003;
        return h$ ^= this.projectId.hashCode();
    }

    static final class Builder
    extends BigtableWriteSchemaTransformProvider.BigtableWriteSchemaTransformConfiguration.Builder {
        private String tableId;
        private String instanceId;
        private String projectId;

        Builder() {
        }

        @Override
        public BigtableWriteSchemaTransformProvider.BigtableWriteSchemaTransformConfiguration.Builder setTableId(String tableId) {
            if (tableId == null) {
                throw new NullPointerException("Null tableId");
            }
            this.tableId = tableId;
            return this;
        }

        @Override
        public BigtableWriteSchemaTransformProvider.BigtableWriteSchemaTransformConfiguration.Builder setInstanceId(String instanceId) {
            if (instanceId == null) {
                throw new NullPointerException("Null instanceId");
            }
            this.instanceId = instanceId;
            return this;
        }

        @Override
        public BigtableWriteSchemaTransformProvider.BigtableWriteSchemaTransformConfiguration.Builder setProjectId(String projectId) {
            if (projectId == null) {
                throw new NullPointerException("Null projectId");
            }
            this.projectId = projectId;
            return this;
        }

        @Override
        public BigtableWriteSchemaTransformProvider.BigtableWriteSchemaTransformConfiguration build() {
            if (this.tableId == null || this.instanceId == null || this.projectId == null) {
                StringBuilder missing = new StringBuilder();
                if (this.tableId == null) {
                    missing.append(" tableId");
                }
                if (this.instanceId == null) {
                    missing.append(" instanceId");
                }
                if (this.projectId == null) {
                    missing.append(" projectId");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_BigtableWriteSchemaTransformProvider_BigtableWriteSchemaTransformConfiguration(this.tableId, this.instanceId, this.projectId);
        }
    }
}

