/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.PartitionLookupUtils;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.TopicPath;
import java.io.Serializable;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.SubscriptionPartition;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Impulse;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.splittabledofn.ManualWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.SplitResult;
import org.apache.beam.sdk.transforms.splittabledofn.WatermarkEstimators;
import org.apache.beam.sdk.util.SerializableSupplier;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;

class SubscriptionPartitionLoader
extends PTransform<PBegin, PCollection<SubscriptionPartition>> {
    private final @UnknownKeyFor @NonNull @Initialized TopicPath topic;
    private final @UnknownKeyFor @NonNull @Initialized SubscriptionPath subscription;
    private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized TopicPath, @UnknownKeyFor @NonNull @Initialized Integer> getPartitionCount;
    private final @UnknownKeyFor @NonNull @Initialized Duration pollDuration;
    private final @UnknownKeyFor @NonNull @Initialized SerializableSupplier<@UnknownKeyFor @NonNull @Initialized Boolean> terminate;

    SubscriptionPartitionLoader(@UnknownKeyFor @NonNull @Initialized TopicPath topic, @UnknownKeyFor @NonNull @Initialized SubscriptionPath subscription) {
        this(topic, subscription, (SerializableFunction<TopicPath, Integer>)((SerializableFunction & Serializable)PartitionLookupUtils::numPartitions), Duration.standardMinutes((long)1L), (SerializableSupplier<Boolean>)(SerializableSupplier & Serializable)() -> false);
    }

    @VisibleForTesting
    SubscriptionPartitionLoader(@UnknownKeyFor @NonNull @Initialized TopicPath topic, @UnknownKeyFor @NonNull @Initialized SubscriptionPath subscription, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized TopicPath, @UnknownKeyFor @NonNull @Initialized Integer> getPartitionCount, @UnknownKeyFor @NonNull @Initialized Duration pollDuration, @UnknownKeyFor @NonNull @Initialized SerializableSupplier<@UnknownKeyFor @NonNull @Initialized Boolean> terminate) {
        this.topic = topic;
        this.subscription = subscription;
        this.getPartitionCount = getPartitionCount;
        this.pollDuration = pollDuration;
        this.terminate = terminate;
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized SubscriptionPartition> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
        return (PCollection)((PCollection)input.apply("Impulse", (PTransform)Impulse.create())).apply("Watch Partition Count", (PTransform)ParDo.of((DoFn)new GeneratorFn()));
    }

    private class GeneratorFn
    extends DoFn<byte[], SubscriptionPartition> {
        private GeneratorFn() {
        }

        @DoFn.ProcessElement
        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.ProcessContinuation processElement(@UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized Integer> restrictionTracker, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized SubscriptionPartition> output, @UnknownKeyFor @NonNull @Initialized ManualWatermarkEstimator<@UnknownKeyFor @NonNull @Initialized Instant> estimator) {
            int previousCount = (Integer)restrictionTracker.currentRestriction();
            int newCount = (Integer)SubscriptionPartitionLoader.this.getPartitionCount.apply((Object)SubscriptionPartitionLoader.this.topic);
            if (!restrictionTracker.tryClaim((Object)newCount)) {
                return DoFn.ProcessContinuation.stop();
            }
            if (newCount > previousCount) {
                for (int i = previousCount; i < newCount; ++i) {
                    output.outputWithTimestamp((Object)SubscriptionPartition.of(SubscriptionPartitionLoader.this.subscription, Partition.of((long)i)), estimator.currentWatermark());
                }
            }
            estimator.setWatermark(this.getWatermark());
            return DoFn.ProcessContinuation.resume().withResumeDelay(SubscriptionPartitionLoader.this.pollDuration);
        }

        @DoFn.GetInitialWatermarkEstimatorState
        public @UnknownKeyFor @NonNull @Initialized Instant getInitialWatermarkEstimatorState(@DoFn.Timestamp @UnknownKeyFor @NonNull @Initialized Instant initial) {
            return Instant.EPOCH;
        }

        @DoFn.GetInitialRestriction
        public @UnknownKeyFor @NonNull @Initialized Integer getInitialRestriction() {
            return 0;
        }

        @DoFn.NewTracker
        public @UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized Integer> newTracker(final @DoFn.Restriction @UnknownKeyFor @NonNull @Initialized Integer input) {
            return new RestrictionTracker<Integer, Integer>(){
                private @UnknownKeyFor @NonNull @Initialized boolean terminated = false;
                private @UnknownKeyFor @NonNull @Initialized int position = input;

                public @UnknownKeyFor @NonNull @Initialized boolean tryClaim(@UnknownKeyFor @NonNull @Initialized Integer newPosition) {
                    Preconditions.checkArgument((newPosition >= this.position ? 1 : 0) != 0);
                    if (this.terminated) {
                        return false;
                    }
                    if (((Boolean)SubscriptionPartitionLoader.this.terminate.get()).booleanValue()) {
                        this.terminated = true;
                        return false;
                    }
                    this.position = newPosition;
                    return true;
                }

                public @UnknownKeyFor @NonNull @Initialized Integer currentRestriction() {
                    return this.position;
                }

                public @Nullable @UnknownKeyFor @Initialized SplitResult<@UnknownKeyFor @NonNull @Initialized Integer> trySplit(@UnknownKeyFor @NonNull @Initialized double fractionOfRemainder) {
                    if (fractionOfRemainder != 0.0) {
                        return null;
                    }
                    if (this.terminated) {
                        return null;
                    }
                    this.terminated = true;
                    return SplitResult.of((Object)this.position, (Object)this.position);
                }

                public void checkDone() throws @UnknownKeyFor @NonNull @Initialized IllegalStateException {
                    Preconditions.checkState((boolean)this.terminated);
                }

                public // Could not load outer class - annotation placement on inner may be incorrect
                @UnknownKeyFor @NonNull @Initialized RestrictionTracker.IsBounded isBounded() {
                    return RestrictionTracker.IsBounded.UNBOUNDED;
                }
            };
        }

        @DoFn.NewWatermarkEstimator
        public @UnknownKeyFor @NonNull @Initialized ManualWatermarkEstimator<@UnknownKeyFor @NonNull @Initialized Instant> newWatermarkEstimator(@DoFn.WatermarkEstimatorState @UnknownKeyFor @NonNull @Initialized Instant state) {
            return new WatermarkEstimators.Manual(state);
        }

        private @UnknownKeyFor @NonNull @Initialized Instant getWatermark() {
            return Instant.now().minus((ReadableDuration)this.watermarkDelay());
        }

        private @UnknownKeyFor @NonNull @Initialized Duration watermarkDelay() {
            return SubscriptionPartitionLoader.this.pollDuration.multipliedBy(3L).dividedBy(2L);
        }
    }
}

