/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.internal;

import com.clickhouse.client.ClickHouseCredentials;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseNodes;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.config.ClickHouseDefaults;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseFormat;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.jdbc.JdbcConfig;
import com.clickhouse.jdbc.SqlExceptionUtils;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;

@Deprecated
public class ClickHouseJdbcUrlParser {
    public static final String JDBC_PREFIX = "jdbc:";
    public static final String JDBC_CLICKHOUSE_PREFIX = "jdbc:clickhouse:";
    public static final String JDBC_ABBREVIATION_PREFIX = "jdbc:ch:";

    static Properties newProperties() {
        Properties props = new Properties();
        props.setProperty(ClickHouseClientOption.ASYNC.getKey(), Boolean.FALSE.toString());
        props.setProperty(ClickHouseClientOption.FORMAT.getKey(), ClickHouseFormat.RowBinaryWithNamesAndTypes.name());
        props.setProperty(ClickHouseClientOption.PRODUCT_NAME.getKey(), "ClickHouse-JdbcDriver");
        return props;
    }

    public static ConnectionInfo parse(String jdbcUrl, Properties defaults) throws SQLException {
        if (defaults == null) {
            defaults = new Properties();
        }
        if (ClickHouseChecker.isNullOrBlank(jdbcUrl)) {
            throw SqlExceptionUtils.clientError("Non-blank JDBC URL is required");
        }
        if (jdbcUrl.startsWith(JDBC_CLICKHOUSE_PREFIX)) {
            jdbcUrl = jdbcUrl.substring(JDBC_CLICKHOUSE_PREFIX.length());
        } else if (jdbcUrl.startsWith(JDBC_ABBREVIATION_PREFIX)) {
            jdbcUrl = jdbcUrl.substring(JDBC_ABBREVIATION_PREFIX.length());
        } else {
            throw SqlExceptionUtils.clientError(new URISyntaxException(jdbcUrl, ClickHouseUtils.format("'%s' or '%s' prefix is mandatory", JDBC_CLICKHOUSE_PREFIX, JDBC_ABBREVIATION_PREFIX)));
        }
        int index = jdbcUrl.indexOf("//");
        if (index == -1) {
            throw SqlExceptionUtils.clientError(new URISyntaxException(jdbcUrl, "Missing '//' from the given JDBC URL"));
        }
        if (index == 0) {
            jdbcUrl = "http:" + jdbcUrl;
        }
        try {
            String cacheKey = ClickHouseNodes.buildCacheKey(jdbcUrl, defaults);
            ClickHouseNodes nodes = ClickHouseNodes.of(cacheKey, jdbcUrl, defaults);
            Properties props = ClickHouseJdbcUrlParser.newProperties();
            props.putAll(nodes.getTemplate().getOptions());
            props.putAll((Map<?, ?>)defaults);
            return new ConnectionInfo(cacheKey, nodes, props);
        }
        catch (IllegalArgumentException e) {
            throw SqlExceptionUtils.clientError(e);
        }
    }

    private ClickHouseJdbcUrlParser() {
    }

    public static class ConnectionInfo {
        private final String cacheKey;
        private final ClickHouseCredentials credentials;
        private final ClickHouseNodes nodes;
        private final JdbcConfig jdbcConf;
        private final Properties props;

        protected ConnectionInfo(String cacheKey, ClickHouseNodes nodes, Properties props) {
            this.cacheKey = cacheKey;
            this.nodes = nodes;
            this.jdbcConf = new JdbcConfig(props);
            this.props = props;
            ClickHouseCredentials c = nodes.getTemplate().getCredentials().orElse(null);
            if (props != null && !props.isEmpty()) {
                String user = props.getProperty(ClickHouseDefaults.USER.getKey(), "");
                String passwd = props.getProperty(ClickHouseDefaults.PASSWORD.getKey(), "");
                if (!ClickHouseChecker.isNullOrEmpty(user)) {
                    c = ClickHouseCredentials.fromUserAndPassword(user, passwd);
                }
            }
            this.credentials = c;
        }

        public ClickHouseCredentials getDefaultCredentials() {
            return this.credentials;
        }

        @Deprecated
        public ClickHouseNode getServer() {
            return this.nodes.apply(this.nodes.getNodeSelector());
        }

        public JdbcConfig getJdbcConfig() {
            return this.jdbcConf;
        }

        public ClickHouseNodes getNodes() {
            return this.nodes;
        }

        public Properties getProperties() {
            return this.props;
        }
    }
}

