/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.internal;

import com.clickhouse.client.api.sql.SQLUtils;
import com.clickhouse.client.internal.org.antlr.v4.runtime.BaseErrorListener;
import com.clickhouse.client.internal.org.antlr.v4.runtime.CharStreams;
import com.clickhouse.client.internal.org.antlr.v4.runtime.CodePointCharStream;
import com.clickhouse.client.internal.org.antlr.v4.runtime.CommonTokenStream;
import com.clickhouse.client.internal.org.antlr.v4.runtime.RecognitionException;
import com.clickhouse.client.internal.org.antlr.v4.runtime.Recognizer;
import com.clickhouse.client.internal.org.antlr.v4.runtime.tree.ErrorNode;
import com.clickhouse.client.internal.org.antlr.v4.runtime.tree.IterativeParseTreeWalker;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.jdbc.internal.ParsedPreparedStatement;
import com.clickhouse.jdbc.internal.ParsedStatement;
import com.clickhouse.jdbc.internal.parser.antlr4.ClickHouseLexer;
import com.clickhouse.jdbc.internal.parser.antlr4.ClickHouseParser;
import com.clickhouse.jdbc.internal.parser.antlr4.ClickHouseParserBaseListener;
import com.clickhouse.jdbc.internal.parser.javacc.ClickHouseSqlParser;
import com.clickhouse.jdbc.internal.parser.javacc.ClickHouseSqlStatement;
import com.clickhouse.jdbc.internal.parser.javacc.ClickHouseSqlUtils;
import com.clickhouse.jdbc.internal.parser.javacc.JdbcParseHandler;
import com.clickhouse.jdbc.internal.parser.javacc.StatementType;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SqlParserFacade {
    private static final Logger LOG = LoggerFactory.getLogger(SqlParserFacade.class);

    public abstract ParsedStatement parsedStatement(String var1);

    public abstract ParsedPreparedStatement parsePreparedStatement(String var1);

    private static void parseParameters(String originalQuery, ParsedPreparedStatement stmt) {
        int len = originalQuery.length();
        for (int i = 0; i < len; ++i) {
            char ch = originalQuery.charAt(i);
            if (ClickHouseUtils.isQuote(ch)) {
                i = ClickHouseUtils.skipQuotedString(originalQuery, i, len, ch) - 1;
                continue;
            }
            if (ch == '?') {
                int idx = ClickHouseUtils.skipContentsUntil(originalQuery, i + 2, len, '?', ':');
                if (idx < len && originalQuery.charAt(idx - 1) == ':' && originalQuery.charAt(idx) != ':' && originalQuery.charAt(idx - 2) != ':') {
                    i = idx - 1;
                    continue;
                }
                stmt.appendParameter(i);
                continue;
            }
            if (ch == ';' || i + 1 >= len) continue;
            char nextCh = originalQuery.charAt(i + 1);
            if (ch == '-' && nextCh == ch || ch == '#') {
                i = ClickHouseUtils.skipSingleLineComment(originalQuery, i + 2, len) - 1;
                continue;
            }
            if (ch != '/' || nextCh != '*') continue;
            i = ClickHouseUtils.skipMultiLineComment(originalQuery, i + 2, len) - 1;
        }
    }

    public static SqlParserFacade getParser(String name) throws SQLException {
        try {
            SQLParser parserSelection = SQLParser.valueOf(name);
            switch (parserSelection) {
                case JAVACC: {
                    return new JavaCCParser();
                }
                case ANTLR4_PARAMS_PARSER: {
                    return new ANTLR4AndParamsParser();
                }
                case ANTLR4: {
                    return new ANTLR4Parser();
                }
            }
            throw new SQLException("Unsupported parser: " + (Object)((Object)parserSelection));
        }
        catch (IllegalArgumentException e) {
            throw new SQLException("Unknown parser: " + name);
        }
    }

    public static enum SQLParser {
        JAVACC,
        ANTLR4_PARAMS_PARSER,
        ANTLR4;

    }

    private static class JavaCCParser
    extends SqlParserFacade {
        private JavaCCParser() {
        }

        @Override
        public ParsedStatement parsedStatement(String sql) {
            String rolesCount;
            ParsedStatement stmt = new ParsedStatement();
            ClickHouseSqlStatement parsedStmt = this.parse(sql);
            if (parsedStmt.getStatementType() == StatementType.USE) {
                stmt.setUseDatabase(parsedStmt.getDatabase());
            }
            if ((rolesCount = parsedStmt.getSettings().get("_ROLES_COUNT")) != null) {
                int rolesCountInt = Integer.parseInt(rolesCount);
                ArrayList<String> roles = new ArrayList<String>(rolesCountInt);
                boolean resetRoles = false;
                for (int i = 0; i < rolesCountInt; ++i) {
                    String role = parsedStmt.getSettings().get("_ROLE_" + i);
                    if (role.equalsIgnoreCase("NONE")) {
                        resetRoles = true;
                    }
                    roles.add(parsedStmt.getSettings().get("_ROLE_" + i));
                }
                if (resetRoles) {
                    roles.clear();
                }
                stmt.setRoles(roles);
            }
            stmt.setInsert(parsedStmt.getStatementType() == StatementType.INSERT);
            stmt.setHasErrors(parsedStmt.getStatementType() == StatementType.UNKNOWN);
            stmt.setHasResultSet(this.isStmtWithResultSet(parsedStmt));
            return stmt;
        }

        private boolean isStmtWithResultSet(ClickHouseSqlStatement parsedStmt) {
            return parsedStmt.getStatementType() == StatementType.SELECT || parsedStmt.getStatementType() == StatementType.SHOW || parsedStmt.getStatementType() == StatementType.EXPLAIN || parsedStmt.getStatementType() == StatementType.DESCRIBE || parsedStmt.getStatementType() == StatementType.EXISTS || parsedStmt.getStatementType() == StatementType.CHECK;
        }

        @Override
        public ParsedPreparedStatement parsePreparedStatement(String sql) {
            ParsedPreparedStatement stmt = new ParsedPreparedStatement();
            ClickHouseSqlStatement parsedStmt = this.parse(sql);
            if (parsedStmt.getStatementType() == StatementType.USE) {
                stmt.setUseDatabase(parsedStmt.getDatabase());
            }
            stmt.setInsert(parsedStmt.getStatementType() == StatementType.INSERT);
            stmt.setHasErrors(parsedStmt.getStatementType() == StatementType.UNKNOWN);
            stmt.setHasResultSet(this.isStmtWithResultSet(parsedStmt));
            String tableName = parsedStmt.getTable();
            if (parsedStmt.getDatabase() != null && parsedStmt.getTable() != null) {
                tableName = String.format("%s.%s", parsedStmt.getDatabase(), parsedStmt.getTable());
            }
            stmt.setTable(tableName);
            stmt.setInsertWithSelect(parsedStmt.containsKeyword("SELECT") && parsedStmt.getStatementType() == StatementType.INSERT);
            stmt.setAssignValuesGroups(parsedStmt.getValueGroups());
            Integer startIndex = parsedStmt.getPositions().get("ValuesStart");
            if (startIndex != null) {
                int endIndex = parsedStmt.getPositions().get("ValuesEnd");
                stmt.setAssignValuesListStartPosition(startIndex);
                stmt.setAssignValuesListStopPosition(endIndex);
                String query = parsedStmt.getSQL();
                for (int i = startIndex + 1; i < endIndex; ++i) {
                    char ch = query.charAt(i);
                    if (ch == '?' || ch == ',' || Character.isWhitespace(ch)) continue;
                    stmt.setUseFunction(true);
                    break;
                }
            }
            stmt.setUseFunction(parsedStmt.isFuncUsed());
            SqlParserFacade.parseParameters(sql, stmt);
            return stmt;
        }

        public ClickHouseSqlStatement parse(String sql) {
            JdbcParseHandler handler = JdbcParseHandler.getInstance();
            ClickHouseSqlStatement[] stmts = ClickHouseSqlParser.parse(sql, handler);
            if (stmts.length > 1) {
                throw new RuntimeException("More than one SQL statement found: " + sql);
            }
            return stmts[0];
        }
    }

    private static class ANTLR4AndParamsParser
    extends ANTLR4Parser {
        private ANTLR4AndParamsParser() {
        }

        @Override
        public ParsedPreparedStatement parsePreparedStatement(String sql) {
            ParsedPreparedStatement stmt = new ParsedPreparedStatement();
            this.parseSQL(sql, new ParseStatementAndParamsListener(stmt));
            String tableName = stmt.getTable();
            if (stmt.getDatabase() != null && stmt.getTable() != null) {
                tableName = String.format("%s.%s", stmt.getDatabase(), stmt.getTable());
            }
            stmt.setTable(tableName);
            return stmt;
        }

        private static class ParseStatementAndParamsListener
        extends ANTLR4Parser.ParsedPreparedStatementListener {
            public ParseStatementAndParamsListener(ParsedPreparedStatement parsedStatement) {
                super(parsedStatement);
            }

            @Override
            public void enterColumnExprParam(ClickHouseParser.ColumnExprParamContext ctx) {
                this.parsedStatement.appendParameter(ctx.start.getStartIndex());
            }

            @Override
            public void enterCteUnboundColParam(ClickHouseParser.CteUnboundColParamContext ctx) {
                this.parsedStatement.appendParameter(ctx.start.getStartIndex());
            }

            @Override
            public void enterInsertParameter(ClickHouseParser.InsertParameterContext ctx) {
                this.parsedStatement.appendParameter(ctx.start.getStartIndex());
            }

            @Override
            public void enterFromClause(ClickHouseParser.FromClauseContext ctx) {
                if (ctx.JDBC_PARAM_PLACEHOLDER() != null) {
                    this.parsedStatement.appendParameter(ctx.JDBC_PARAM_PLACEHOLDER().getSymbol().getStartIndex());
                }
            }

            @Override
            public void enterViewParam(ClickHouseParser.ViewParamContext ctx) {
                if (ctx.JDBC_PARAM_PLACEHOLDER() != null) {
                    this.parsedStatement.appendParameter(ctx.JDBC_PARAM_PLACEHOLDER().getSymbol().getStartIndex());
                }
            }
        }
    }

    private static class ANTLR4Parser
    extends SqlParserFacade {
        private ANTLR4Parser() {
        }

        @Override
        public ParsedStatement parsedStatement(String sql) {
            ParsedStatement stmt = new ParsedStatement();
            this.parseSQL(sql, new ParsedStatementListener(stmt));
            return stmt;
        }

        @Override
        public ParsedPreparedStatement parsePreparedStatement(String sql) {
            ParsedPreparedStatement stmt = new ParsedPreparedStatement();
            this.parseSQL(sql, new ParsedPreparedStatementListener(stmt));
            String tableName = stmt.getTable();
            if (stmt.getDatabase() != null && stmt.getTable() != null) {
                tableName = String.format("%s.%s", stmt.getDatabase(), stmt.getTable());
            }
            stmt.setTable(tableName);
            SqlParserFacade.parseParameters(sql, stmt);
            return stmt;
        }

        protected ClickHouseParser parseSQL(String sql, ClickHouseParserBaseListener listener) {
            CodePointCharStream charStream = CharStreams.fromString(sql);
            ClickHouseLexer lexer = new ClickHouseLexer(charStream);
            ClickHouseParser parser = new ClickHouseParser(new CommonTokenStream(lexer));
            parser.removeErrorListeners();
            parser.addErrorListener(new ParserErrorListener());
            ClickHouseParser.QueryStmtContext parseTree = parser.queryStmt();
            IterativeParseTreeWalker.DEFAULT.walk(listener, parseTree);
            return parser;
        }

        static boolean isStmtWithResultSet(ClickHouseParser.QueryStmtContext stmtContext) {
            ClickHouseParser.QueryContext qCtx = stmtContext.query();
            return qCtx != null && (qCtx.selectStmt() != null || qCtx.selectUnionStmt() != null || qCtx.showStmt() != null || qCtx.explainStmt() != null || qCtx.describeStmt() != null || qCtx.existsStmt() != null || qCtx.checkStmt() != null);
        }

        private static class ParsedStatementListener
        extends ClickHouseParserBaseListener {
            private final ParsedStatement parsedStatement;

            public ParsedStatementListener(ParsedStatement parsedStatement) {
                this.parsedStatement = parsedStatement;
            }

            @Override
            public void visitErrorNode(ErrorNode node) {
                this.parsedStatement.setHasErrors(true);
            }

            @Override
            public void enterQueryStmt(ClickHouseParser.QueryStmtContext ctx) {
                if (ANTLR4Parser.isStmtWithResultSet(ctx)) {
                    this.parsedStatement.setHasResultSet(true);
                }
            }

            @Override
            public void enterUseStmt(ClickHouseParser.UseStmtContext ctx) {
                if (ctx.databaseIdentifier() != null) {
                    this.parsedStatement.setUseDatabase(SQLUtils.unquoteIdentifier(ctx.databaseIdentifier().getText()));
                }
            }

            @Override
            public void enterSetRoleStmt(ClickHouseParser.SetRoleStmtContext ctx) {
                if (ctx.NONE() != null) {
                    this.parsedStatement.setRoles(Collections.emptyList());
                } else {
                    ArrayList<String> roles = new ArrayList<String>();
                    for (ClickHouseParser.IdentifierContext id : ctx.setRolesList().identifier()) {
                        roles.add(SQLUtils.unquoteIdentifier(id.getText()));
                    }
                    this.parsedStatement.setRoles(roles);
                }
            }
        }

        protected static class ParsedPreparedStatementListener
        extends ClickHouseParserBaseListener {
            protected final ParsedPreparedStatement parsedStatement;

            public ParsedPreparedStatementListener(ParsedPreparedStatement parsedStatement) {
                this.parsedStatement = parsedStatement;
            }

            @Override
            public void enterQueryStmt(ClickHouseParser.QueryStmtContext ctx) {
                if (ANTLR4Parser.isStmtWithResultSet(ctx)) {
                    this.parsedStatement.setHasResultSet(true);
                }
            }

            @Override
            public void enterUseStmt(ClickHouseParser.UseStmtContext ctx) {
                if (ctx.databaseIdentifier() != null) {
                    this.parsedStatement.setUseDatabase(SQLUtils.unquoteIdentifier(ctx.databaseIdentifier().getText()));
                }
            }

            @Override
            public void enterSetRoleStmt(ClickHouseParser.SetRoleStmtContext ctx) {
                if (ctx.NONE() != null) {
                    this.parsedStatement.setRoles(Collections.emptyList());
                } else {
                    ArrayList<String> roles = new ArrayList<String>();
                    for (ClickHouseParser.IdentifierContext id : ctx.setRolesList().identifier()) {
                        roles.add(SQLUtils.unquoteIdentifier(id.getText()));
                    }
                    this.parsedStatement.setRoles(roles);
                }
            }

            @Override
            public void enterColumnExprPrecedence3(ClickHouseParser.ColumnExprPrecedence3Context ctx) {
                super.enterColumnExprPrecedence3(ctx);
            }

            @Override
            public void visitErrorNode(ErrorNode node) {
                this.parsedStatement.setHasErrors(true);
            }

            @Override
            public void enterInsertParameterFuncExpr(ClickHouseParser.InsertParameterFuncExprContext ctx) {
                this.parsedStatement.setUseFunction(true);
            }

            @Override
            public void enterAssignmentValuesList(ClickHouseParser.AssignmentValuesListContext ctx) {
                this.parsedStatement.setAssignValuesListStartPosition(ctx.getStart().getStartIndex());
                this.parsedStatement.setAssignValuesListStopPosition(ctx.getStop().getStopIndex());
            }

            @Override
            public void enterTableExprIdentifier(ClickHouseParser.TableExprIdentifierContext ctx) {
                if (ctx.tableIdentifier() != null) {
                    this.extractAndSetDatabaseAndTable(ctx.tableIdentifier());
                }
            }

            @Override
            public void enterInsertStmt(ClickHouseParser.InsertStmtContext ctx) {
                ClickHouseParser.ColumnsClauseContext columns;
                ClickHouseParser.TableIdentifierContext tableId = ctx.tableIdentifier();
                if (tableId != null) {
                    this.extractAndSetDatabaseAndTable(tableId);
                }
                if ((columns = ctx.columnsClause()) != null) {
                    List<ClickHouseParser.NestedIdentifierContext> names = columns.nestedIdentifier();
                    String[] insertColumns = new String[names.size()];
                    for (int i = 0; i < names.size(); ++i) {
                        insertColumns[i] = names.get(i).getText();
                    }
                    this.parsedStatement.setInsertColumns(insertColumns);
                }
                this.parsedStatement.setInsert(true);
            }

            private void extractAndSetDatabaseAndTable(ClickHouseParser.TableIdentifierContext tableId) {
                if (tableId == null) {
                    return;
                }
                if (tableId.identifier() != null) {
                    this.parsedStatement.setTable(ClickHouseSqlUtils.unescape(tableId.identifier().getText()));
                }
                if (tableId.databaseIdentifier() != null) {
                    String database = tableId.databaseIdentifier().identifier().stream().map(id -> ClickHouseSqlUtils.unescape(id.getText())).collect(Collectors.joining("."));
                    this.parsedStatement.setDatabase(database);
                }
            }

            @Override
            public void enterDataClauseSelect(ClickHouseParser.DataClauseSelectContext ctx) {
                this.parsedStatement.setInsertWithSelect(true);
            }

            @Override
            public void enterDataClauseValues(ClickHouseParser.DataClauseValuesContext ctx) {
                this.parsedStatement.setAssignValuesGroups(ctx.assignmentValues().size());
            }

            @Override
            public void exitInsertParameterFuncExpr(ClickHouseParser.InsertParameterFuncExprContext ctx) {
                this.parsedStatement.setUseFunction(true);
            }
        }

        private static class ParserErrorListener
        extends BaseErrorListener {
            private ParserErrorListener() {
            }

            @Override
            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                LOG.debug("SQL syntax error at line: " + line + ", pos: " + charPositionInLine + ", " + msg);
            }
        }
    }
}

