/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core;

import java.util.ArrayList;
import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.core.KeyedWorkItem;
import org.apache.beam.runners.core.KeyedWorkItems;
import org.apache.beam.runners.core.LateDataUtils;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowTracing;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.WindowedValue;
import org.apache.beam.sdk.values.WindowedValues;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

public class LateDataDroppingDoFnRunner<@UnknownKeyFor K, @UnknownKeyFor InputT, @UnknownKeyFor OutputT, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
implements DoFnRunner<KeyedWorkItem<K, InputT>, KV<K, OutputT>> {
    private final @UnknownKeyFor @NonNull @Initialized DoFnRunner<@UnknownKeyFor @NonNull @Initialized KeyedWorkItem<K, InputT>, @UnknownKeyFor @NonNull @Initialized KV<K, OutputT>> doFnRunner;
    private final @UnknownKeyFor @NonNull @Initialized LateDataFilter lateDataFilter;
    public static final @UnknownKeyFor @NonNull @Initialized String DROPPED_DUE_TO_LATENESS = "droppedDueToLateness";

    public LateDataDroppingDoFnRunner(@UnknownKeyFor @NonNull @Initialized DoFnRunner<@UnknownKeyFor @NonNull @Initialized KeyedWorkItem<K, InputT>, @UnknownKeyFor @NonNull @Initialized KV<K, OutputT>> doFnRunner, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy, @UnknownKeyFor @NonNull @Initialized TimerInternals timerInternals) {
        this.doFnRunner = doFnRunner;
        this.lateDataFilter = new LateDataFilter(windowingStrategy, timerInternals);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized DoFn<@UnknownKeyFor @NonNull @Initialized KeyedWorkItem<K, InputT>, @UnknownKeyFor @NonNull @Initialized KV<K, OutputT>> getFn() {
        return this.doFnRunner.getFn();
    }

    @Override
    public void startBundle() {
        this.doFnRunner.startBundle();
    }

    @Override
    public void processElement(@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KeyedWorkItem<K, InputT>> elem) {
        Iterable nonLateElements = this.lateDataFilter.filter(elem.getValue().key(), elem.getValue().elementsIterable());
        KeyedWorkItem keyedWorkItem = KeyedWorkItems.workItem(elem.getValue().key(), elem.getValue().timersIterable(), nonLateElements);
        this.doFnRunner.processElement(elem.withValue(keyedWorkItem));
    }

    @Override
    public <KeyT> void onTimer(@UnknownKeyFor @NonNull @Initialized String timerId, @UnknownKeyFor @NonNull @Initialized String timerFamilyId, KeyT key, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized Instant outputTimestamp, @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain) {
        this.doFnRunner.onTimer(timerId, timerFamilyId, key, window, timestamp, outputTimestamp, timeDomain);
    }

    @Override
    public void finishBundle() {
        this.doFnRunner.finishBundle();
    }

    @Override
    public <KeyT> void onWindowExpiration(@UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized Instant timestamp, KeyT key) {
        this.doFnRunner.onWindowExpiration(window, timestamp, key);
    }

    @VisibleForTesting
    static class LateDataFilter {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy;
        private final @UnknownKeyFor @NonNull @Initialized TimerInternals timerInternals;
        private final @UnknownKeyFor @NonNull @Initialized Counter droppedDueToLateness;

        public LateDataFilter(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy, @UnknownKeyFor @NonNull @Initialized TimerInternals timerInternals) {
            this.windowingStrategy = windowingStrategy;
            this.timerInternals = timerInternals;
            this.droppedDueToLateness = Metrics.counter(LateDataDroppingDoFnRunner.class, LateDataDroppingDoFnRunner.DROPPED_DUE_TO_LATENESS);
        }

        public <K, InputT> @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT>> filter(K key, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT>> elements) {
            ArrayList<WindowedValue<InputT>> nonLateElements = new ArrayList<WindowedValue<InputT>>();
            for (WindowedValue<InputT> element : elements) {
                for (BoundedWindow window : element.getWindows()) {
                    if (this.canDropDueToExpiredWindow(window)) {
                        this.droppedDueToLateness.inc();
                        WindowTracing.debug("{}: Dropping element at {} for key:{}; window:{} since too far behind inputWatermark:{}; outputWatermark:{}", LateDataFilter.class.getSimpleName(), element.getTimestamp(), key, window, this.timerInternals.currentInputWatermarkTime(), this.timerInternals.currentOutputWatermarkTime());
                        continue;
                    }
                    nonLateElements.add(WindowedValues.of(element.getValue(), element.getTimestamp(), window, element.getPaneInfo()));
                }
            }
            return nonLateElements;
        }

        private @UnknownKeyFor @NonNull @Initialized boolean canDropDueToExpiredWindow(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            Instant inputWM = this.timerInternals.currentInputWatermarkTime();
            return LateDataUtils.garbageCollectionTime(window, this.windowingStrategy).isBefore((ReadableInstant)inputWM);
        }
    }
}

