/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.delay;

import java.util.ArrayList;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.delay.DelayMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class DelayDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = DelayMeta.class;
    private final DelayMeta input;
    private ComboVar wTimeout;
    private CCombo wScaleTime;
    private Button wScaleTimeFromField;
    private Label wlScaleTimeField;
    private ComboVar wScaleTimeField;
    private String[] numericFieldNames = new String[0];
    private String[] stringFieldNames = new String[0];

    public DelayDialog(Shell parent, IVariables variables, DelayMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"DelayDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"DelayDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label wlTimeout = new Label((Composite)this.shell, 131072);
        wlTimeout.setText(BaseMessages.getString(PKG, (String)"DelayDialog.Timeout.Label", (String[])new String[0]));
        wlTimeout.setToolTipText(BaseMessages.getString(PKG, (String)"DelayDialog.Timeout.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTimeout);
        FormData fdlTimeout = new FormData();
        fdlTimeout.left = new FormAttachment(0, 0);
        fdlTimeout.right = new FormAttachment(middle, -margin);
        fdlTimeout.top = new FormAttachment((Control)this.wTransformName, margin);
        wlTimeout.setLayoutData((Object)fdlTimeout);
        this.wTimeout = new ComboVar(this.variables, (Composite)this.shell, 18436);
        this.wTimeout.setToolTipText(BaseMessages.getString(PKG, (String)"DelayDialog.Timeout.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wTimeout);
        this.wTimeout.addModifyListener(e -> {
            this.input.setChanged();
            this.wTimeout.setToolTipText(this.variables.resolve(this.wTimeout.getText()));
        });
        this.wTimeout.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DelayDialog.this.refreshTimeoutFieldItems();
            }
        });
        FormData fdTimeout = new FormData();
        fdTimeout.left = new FormAttachment(middle, 0);
        fdTimeout.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTimeout.right = new FormAttachment(100, 0);
        this.wTimeout.setLayoutData((Object)fdTimeout);
        this.wScaleTime = new CCombo((Composite)this.shell, 2060);
        this.wScaleTime.add(BaseMessages.getString(PKG, (String)"DelayDialog.MSScaleTime.Label", (String[])new String[0]));
        this.wScaleTime.add(BaseMessages.getString(PKG, (String)"DelayDialog.SScaleTime.Label", (String[])new String[0]));
        this.wScaleTime.add(BaseMessages.getString(PKG, (String)"DelayDialog.MnScaleTime.Label", (String[])new String[0]));
        this.wScaleTime.add(BaseMessages.getString(PKG, (String)"DelayDialog.HrScaleTime.Label", (String[])new String[0]));
        this.wScaleTime.select(0);
        PropsUi.setLook((Widget)this.wScaleTime);
        FormData fdScaleTime = new FormData();
        fdScaleTime.left = new FormAttachment(middle, 0);
        fdScaleTime.top = new FormAttachment((Control)this.wTimeout, margin);
        fdScaleTime.right = new FormAttachment(100, 0);
        this.wScaleTime.setLayoutData((Object)fdScaleTime);
        this.wScaleTime.addModifyListener(lsMod);
        this.wScaleTimeFromField = new Button((Composite)this.shell, 32);
        this.wScaleTimeFromField.setText(BaseMessages.getString(PKG, (String)"DelayDialog.ScaleTimeFromField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wScaleTimeFromField);
        FormData fdScaleTimeFromField = new FormData();
        fdScaleTimeFromField.left = new FormAttachment(middle, 0);
        fdScaleTimeFromField.top = new FormAttachment((Control)this.wScaleTime, margin);
        this.wScaleTimeFromField.setLayoutData((Object)fdScaleTimeFromField);
        this.wScaleTimeFromField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DelayDialog.this.input.setChanged();
                DelayDialog.this.enableScaleTimeControls();
            }
        });
        this.wlScaleTimeField = new Label((Composite)this.shell, 131072);
        this.wlScaleTimeField.setText(BaseMessages.getString(PKG, (String)"DelayDialog.ScaleTimeField.Label", (String[])new String[0]));
        this.wlScaleTimeField.setToolTipText(BaseMessages.getString(PKG, (String)"DelayDialog.ScaleTimeField.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlScaleTimeField);
        FormData fdlScaleTimeField = new FormData();
        fdlScaleTimeField.left = new FormAttachment(0, 0);
        fdlScaleTimeField.right = new FormAttachment(middle, -margin);
        fdlScaleTimeField.top = new FormAttachment((Control)this.wScaleTimeFromField, margin);
        this.wlScaleTimeField.setLayoutData((Object)fdlScaleTimeField);
        this.wScaleTimeField = new ComboVar(this.variables, (Composite)this.shell, 18436);
        this.wScaleTimeField.setToolTipText(BaseMessages.getString(PKG, (String)"DelayDialog.ScaleTimeField.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wScaleTimeField);
        this.wScaleTimeField.addModifyListener(lsMod);
        this.wScaleTimeField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DelayDialog.this.refreshScaleTimeFieldItems();
            }
        });
        FormData fdScaleTimeField = new FormData();
        fdScaleTimeField.left = new FormAttachment(middle, 0);
        fdScaleTimeField.top = new FormAttachment((Control)this.wScaleTimeFromField, margin);
        fdScaleTimeField.right = new FormAttachment(100, 0);
        this.wScaleTimeField.setLayoutData((Object)fdScaleTimeField);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, (Control)this.wScaleTimeField);
        this.wCancel.addListener(13, e -> this.cancel());
        this.wOk.addListener(13, e -> this.ok());
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        this.loadAvailableFields();
        this.wTimeout.setItems(this.numericFieldNames);
        this.wScaleTimeField.setItems(this.stringFieldNames);
        if (!Utils.isEmpty((CharSequence)this.input.getTimeoutField())) {
            this.wTimeout.setText(this.input.getTimeoutField());
        } else if (this.input.getTimeout() != null) {
            this.wTimeout.setText(this.input.getTimeout());
        }
        this.wTimeout.setToolTipText(this.variables.resolve(this.wTimeout.getText()));
        this.wScaleTime.select(this.input.getScaleTimeCode());
        this.wScaleTimeFromField.setSelection(this.input.isScaleTimeFromField());
        if (this.input.getScaleTimeField() != null) {
            this.wScaleTimeField.setText(this.input.getScaleTimeField());
        }
        this.enableScaleTimeControls();
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        String timeoutField = this.determineTimeoutField();
        if (timeoutField != null) {
            this.input.setTimeoutField(timeoutField);
            this.input.setTimeout(null);
        } else {
            this.input.setTimeoutField(null);
            this.input.setTimeout(this.wTimeout.getText());
        }
        this.input.setScaleTimeCode(this.wScaleTime.getSelectionIndex());
        this.input.setScaleTimeFromField(this.wScaleTimeFromField.getSelection());
        this.input.setScaleTimeField(this.wScaleTimeFromField.getSelection() && !Utils.isEmpty((CharSequence)this.wScaleTimeField.getText()) ? this.wScaleTimeField.getText() : null);
        this.dispose();
    }

    private String determineTimeoutField() {
        this.loadAvailableFields();
        String candidate = this.wTimeout.getText();
        if (Utils.isEmpty((CharSequence)candidate)) {
            return null;
        }
        for (String field : this.numericFieldNames) {
            if (!candidate.equals(field)) continue;
            return field;
        }
        return null;
    }

    private void enableScaleTimeControls() {
        boolean useField = this.wScaleTimeFromField.getSelection();
        this.wScaleTime.setEnabled(!useField);
        this.wScaleTimeField.setEnabled(useField);
        this.wlScaleTimeField.setEnabled(useField);
    }

    private void loadAvailableFields() {
        try {
            IRowMeta prevFields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (prevFields == null) {
                this.numericFieldNames = new String[0];
                this.stringFieldNames = new String[0];
                return;
            }
            ArrayList<String> numeric = new ArrayList<String>();
            ArrayList<String> strings = new ArrayList<String>();
            for (IValueMeta valueMeta : prevFields.getValueMetaList()) {
                switch (valueMeta.getType()) {
                    case 1: 
                    case 5: 
                    case 6: {
                        numeric.add(valueMeta.getName());
                        break;
                    }
                    case 2: {
                        strings.add(valueMeta.getName());
                        break;
                    }
                }
            }
            this.numericFieldNames = numeric.toArray(new String[0]);
            this.stringFieldNames = strings.toArray(new String[0]);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"DelayDialog.UnableToGetFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DelayDialog.UnableToGetFields.Message", (String[])new String[0]), (Exception)((Object)e));
            this.numericFieldNames = new String[0];
            this.stringFieldNames = new String[0];
        }
    }

    private void refreshTimeoutFieldItems() {
        this.loadAvailableFields();
        String previous = this.wTimeout.getText();
        this.wTimeout.setItems(this.numericFieldNames);
        if (!Utils.isEmpty((CharSequence)previous)) {
            this.wTimeout.setText(previous);
            this.wTimeout.getCComboWidget().setSelection(new Point(previous.length(), previous.length()));
        }
    }

    private void refreshScaleTimeFieldItems() {
        this.loadAvailableFields();
        String previous = this.wScaleTimeField.getText();
        this.wScaleTimeField.setItems(this.stringFieldNames);
        if (!Utils.isEmpty((CharSequence)previous)) {
            this.wScaleTimeField.setText(previous);
            this.wScaleTimeField.getCComboWidget().setSelection(new Point(previous.length(), previous.length()));
        }
    }
}

