/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.s3;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Objects;
import org.apache.beam.sdk.io.aws2.s3.S3FileSystemConfiguration;
import org.apache.beam.sdk.io.aws2.s3.S3ResourceId;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.calledmethods.qual.EnsuresCalledMethodsIf;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompletedMultipartUpload;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.UploadPartResponse;

@SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="Initialization is safe.")
class S3WritableByteChannel
implements WritableByteChannel {
    private final @UnknownKeyFor @NonNull @Initialized S3Client s3Client;
    private final @UnknownKeyFor @NonNull @Initialized S3FileSystemConfiguration config;
    private final @UnknownKeyFor @NonNull @Initialized S3ResourceId path;
    private final @UnknownKeyFor @NonNull @Initialized String uploadId;
    private final @UnknownKeyFor @NonNull @Initialized ByteBuffer uploadBuffer;
    private @UnknownKeyFor @NonNull @Initialized int partNumber = 1;
    private @UnknownKeyFor @NonNull @Initialized boolean open = true;
    private final @UnknownKeyFor @NonNull @Initialized MessageDigest md5 = S3WritableByteChannel.md5();
    private final @UnknownKeyFor @NonNull @Initialized ArrayList<@UnknownKeyFor @NonNull @Initialized CompletedPart> completedParts;

    S3WritableByteChannel(@UnknownKeyFor @NonNull @Initialized S3Client s3, @UnknownKeyFor @NonNull @Initialized S3ResourceId path, @UnknownKeyFor @NonNull @Initialized String contentType, @UnknownKeyFor @NonNull @Initialized S3FileSystemConfiguration config) throws @UnknownKeyFor @NonNull @Initialized IOException {
        CreateMultipartUploadResponse response;
        this.s3Client = (S3Client)Preconditions.checkNotNull((Object)s3, (Object)"s3Client");
        this.config = (S3FileSystemConfiguration)Preconditions.checkNotNull((Object)config);
        this.path = (S3ResourceId)Preconditions.checkNotNull((Object)path, (Object)"path");
        String awsKms = ServerSideEncryption.AWS_KMS.toString();
        Preconditions.checkArgument((boolean)S3WritableByteChannel.atMostOne(config.getSSECustomerKey().getKey() != null, Objects.equals(config.getSSEAlgorithm(), awsKms) || config.getSSEKMSKeyId() != null, config.getSSEAlgorithm() != null && !config.getSSEAlgorithm().equals(awsKms)), (Object)"Either SSECustomerKey (SSE-C) or SSEAlgorithm (SSE-S3) or SSEAwsKeyManagementParams (SSE-KMS) must not be set at the same time.");
        Preconditions.checkArgument((config.getS3UploadBufferSizeBytes() >= 0x500000 ? 1 : 0) != 0, (String)"S3UploadBufferSizeBytes must be at least %s bytes", (int)0x500000);
        this.uploadBuffer = ByteBuffer.allocate(config.getS3UploadBufferSizeBytes());
        this.completedParts = new ArrayList();
        CreateMultipartUploadRequest createMultipartUploadRequest = (CreateMultipartUploadRequest)CreateMultipartUploadRequest.builder().bucket(path.getBucket()).key(path.getKey()).storageClass(config.getS3StorageClass()).contentType(contentType).serverSideEncryption(config.getSSEAlgorithm()).sseCustomerKey(config.getSSECustomerKey().getKey()).sseCustomerAlgorithm(config.getSSECustomerKey().getAlgorithm()).ssekmsKeyId(config.getSSEKMSKeyId()).sseCustomerKeyMD5(config.getSSECustomerKey().getMD5()).bucketKeyEnabled(Boolean.valueOf(config.getBucketKeyEnabled())).build();
        try {
            response = this.s3Client.createMultipartUpload(createMultipartUploadRequest);
        }
        catch (SdkClientException e) {
            throw new IOException(e);
        }
        this.uploadId = response.uploadId();
    }

    private static @UnknownKeyFor @NonNull @Initialized MessageDigest md5() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int write(@UnknownKeyFor @NonNull @Initialized ByteBuffer sourceBuffer) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        int totalBytesWritten = 0;
        while (sourceBuffer.hasRemaining()) {
            int position = sourceBuffer.position();
            int bytesWritten = Math.min(sourceBuffer.remaining(), this.uploadBuffer.remaining());
            totalBytesWritten += bytesWritten;
            if (sourceBuffer.hasArray()) {
                int start = sourceBuffer.arrayOffset() + position;
                this.uploadBuffer.put(sourceBuffer.array(), start, bytesWritten);
                this.md5.update(sourceBuffer.array(), start, bytesWritten);
            } else {
                ByteBuffer copyBuffer = sourceBuffer.asReadOnlyBuffer();
                copyBuffer.mark().limit(position + bytesWritten);
                this.uploadBuffer.put(copyBuffer);
                copyBuffer.reset();
                this.md5.update(copyBuffer);
            }
            sourceBuffer.position(position + bytesWritten);
            if (this.uploadBuffer.hasRemaining() && !sourceBuffer.hasRemaining()) continue;
            this.flush();
        }
        return totalBytesWritten;
    }

    private void flush() throws @UnknownKeyFor @NonNull @Initialized IOException {
        UploadPartResponse response;
        this.uploadBuffer.flip();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.uploadBuffer.array(), 0, this.uploadBuffer.limit());
        UploadPartRequest request = (UploadPartRequest)UploadPartRequest.builder().bucket(this.path.getBucket()).key(this.path.getKey()).uploadId(this.uploadId).partNumber(Integer.valueOf(this.partNumber++)).contentLength(Long.valueOf(this.uploadBuffer.limit())).sseCustomerKey(this.config.getSSECustomerKey().getKey()).sseCustomerAlgorithm(this.config.getSSECustomerKey().getAlgorithm()).sseCustomerKeyMD5(this.config.getSSECustomerKey().getMD5()).contentMD5(Base64.getEncoder().encodeToString(this.md5.digest())).build();
        try {
            response = this.s3Client.uploadPart(request, RequestBody.fromInputStream((InputStream)inputStream, (long)request.contentLength()));
        }
        catch (SdkClientException e) {
            throw new IOException(e);
        }
        CompletedPart part = (CompletedPart)CompletedPart.builder().partNumber(request.partNumber()).eTag(response.eTag()).build();
        this.uploadBuffer.clear();
        this.md5.reset();
        this.completedParts.add(part);
    }

    @Override
    @EnsuresCalledMethodsIf(expression={"this"}, result=false, methods={"close"})
    public @UnknownKeyFor @NonNull @Initialized boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.open = false;
        if (this.uploadBuffer.remaining() > 0) {
            this.flush();
        }
        CompletedMultipartUpload completedMultipartUpload = (CompletedMultipartUpload)CompletedMultipartUpload.builder().parts(this.completedParts).build();
        CompleteMultipartUploadRequest request = (CompleteMultipartUploadRequest)CompleteMultipartUploadRequest.builder().bucket(this.path.getBucket()).key(this.path.getKey()).uploadId(this.uploadId).multipartUpload(completedMultipartUpload).build();
        try {
            this.s3Client.completeMultipartUpload(request);
        }
        catch (SdkClientException e) {
            throw new IOException(e);
        }
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized boolean atMostOne(boolean ... values) {
        boolean one = false;
        for (boolean value : values) {
            if (!one && value) {
                one = true;
                continue;
            }
            if (!value) continue;
            return false;
        }
        return true;
    }
}

