/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.twitter.chill.IKryoRegistrar;
import com.twitter.chill.SingleRegistrar;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.PriorityQueue;

class PriorityQueueSerializer
extends Serializer<PriorityQueue<?>> {
    private Field compField;

    public static IKryoRegistrar registrar() {
        return new SingleRegistrar(PriorityQueue.class, (Serializer)new PriorityQueueSerializer());
    }

    public PriorityQueueSerializer() {
        try {
            this.compField = PriorityQueue.class.getDeclaredField("comparator");
            this.compField.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Comparator<?> getComparator(PriorityQueue<?> q) {
        try {
            return (Comparator)this.compField.get(q);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void write(Kryo k, Output o, PriorityQueue<?> q) {
        k.writeClassAndObject(o, this.getComparator(q));
        o.writeInt(q.size(), true);
        for (Object a : q) {
            k.writeClassAndObject(o, a);
            o.flush();
        }
    }

    public PriorityQueue<?> read(Kryo k, Input i, Class<PriorityQueue<?>> c) {
        Comparator comp = (Comparator)k.readClassAndObject(i);
        int sz = i.readInt(true);
        PriorityQueue<Object> result = sz == 0 ? new PriorityQueue<Object>(1, comp) : new PriorityQueue(sz, comp);
        for (int idx = 0; idx < sz; ++idx) {
            result.add(k.readClassAndObject(i));
        }
        return result;
    }
}

