/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.avro;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.parquet.Preconditions;
import org.apache.parquet.avro.ParentValueContainer;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.variant.ImmutableMetadata;
import org.apache.parquet.variant.Metadata;
import org.apache.parquet.variant.VariantBuilder;
import org.apache.parquet.variant.VariantConverters;

class AvroVariantConverter
extends GroupConverter
implements VariantConverters.ParentConverter<VariantBuilder> {
    private final ParentValueContainer parent;
    private final Schema avroSchema;
    private final GenericData model;
    private final int metadataPos;
    private final int valuePos;
    private final GroupConverter wrappedConverter;
    private VariantBuilder builder = null;
    private ImmutableMetadata metadata = null;

    AvroVariantConverter(ParentValueContainer parent, GroupType variantGroup, Schema avroSchema, GenericData model) {
        this.parent = parent;
        this.avroSchema = avroSchema;
        this.metadataPos = avroSchema.getField("metadata").pos();
        this.valuePos = avroSchema.getField("value").pos();
        this.model = model;
        this.wrappedConverter = VariantConverters.newVariantConverter((GroupType)variantGroup, this::setMetadata, (VariantConverters.ParentConverter)this);
    }

    public void build(Consumer<VariantBuilder> consumer) {
        Preconditions.checkState((this.builder != null ? 1 : 0) != 0, (String)"Cannot build variant: builder has not been initialized");
        consumer.accept(this.builder);
    }

    public Converter getConverter(int fieldIndex) {
        return this.wrappedConverter.getConverter(fieldIndex);
    }

    public void start() {
        this.wrappedConverter.start();
    }

    public void end() {
        this.wrappedConverter.end();
        Preconditions.checkState((this.metadata != null ? 1 : 0) != 0, (String)"Cannot build variant: missing metadata");
        this.builder.appendNullIfEmpty();
        Object record = this.model.newRecord(null, this.avroSchema);
        this.model.setField(record, "metadata", this.metadataPos, (Object)this.metadata.getEncodedBuffer());
        this.model.setField(record, "value", this.valuePos, (Object)this.builder.encodedValue());
        this.parent.add(record);
        this.builder = null;
    }

    void setMetadata(ByteBuffer metadataBuffer) {
        if (this.metadata == null || this.metadata.getEncodedBuffer() != metadataBuffer) {
            this.metadata = new ImmutableMetadata(metadataBuffer);
        }
        this.builder = new VariantBuilder((Metadata)this.metadata);
    }
}

