/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.services.dataflow.model.AutoscalingSettings;
import com.google.api.services.dataflow.model.DataflowPackage;
import com.google.api.services.dataflow.model.DebugOptions;
import com.google.api.services.dataflow.model.Disk;
import com.google.api.services.dataflow.model.Environment;
import com.google.api.services.dataflow.model.Job;
import com.google.api.services.dataflow.model.Step;
import com.google.api.services.dataflow.model.WorkerPool;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.dataflow.BatchViewOverrides;
import org.apache.beam.runners.dataflow.CreateDataflowView;
import org.apache.beam.runners.dataflow.DataflowRunner;
import org.apache.beam.runners.dataflow.PrimitiveParDoSingleFactory;
import org.apache.beam.runners.dataflow.ReadTranslator;
import org.apache.beam.runners.dataflow.TransformTranslator;
import org.apache.beam.runners.dataflow.internal.DataflowGroupByKey;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.runners.dataflow.util.CloudObject;
import org.apache.beam.runners.dataflow.util.CloudObjects;
import org.apache.beam.runners.dataflow.util.OutputReference;
import org.apache.beam.runners.dataflow.util.Structs;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.options.ExperimentalOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.StreamingOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.testing.TestStream;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.resourcehints.ResourceHint;
import org.apache.beam.sdk.transforms.resourcehints.ResourceHints;
import org.apache.beam.sdk.transforms.windowing.DefaultTrigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.util.AppliedCombineFn;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.DoFnInfo;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.util.StringUtils;
import org.apache.beam.sdk.util.construction.Environments;
import org.apache.beam.sdk.util.construction.ParDoTranslation;
import org.apache.beam.sdk.util.construction.SdkComponents;
import org.apache.beam.sdk.util.construction.SplittableParDo;
import org.apache.beam.sdk.util.construction.TransformInputs;
import org.apache.beam.sdk.util.construction.WindowingStrategyTranslation;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowedValues;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.PercentCodec;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
public class DataflowPipelineTranslator {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(DataflowPipelineTranslator.class);
    private static final @UnknownKeyFor @NonNull @Initialized ObjectMapper MAPPER = new ObjectMapper();
    private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Class, @UnknownKeyFor @NonNull @Initialized TransformTranslator> transformTranslators = new HashMap<Class, TransformTranslator>();
    private final @UnknownKeyFor @NonNull @Initialized DataflowPipelineOptions options;

    private static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] serializeWindowingStrategy(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        try {
            SdkComponents sdkComponents = SdkComponents.create();
            String workerHarnessContainerImageURL = DataflowRunner.getContainerImageForJob((DataflowPipelineOptions)options.as(DataflowPipelineOptions.class));
            RunnerApi.Environment defaultEnvironmentForDataflow = Environments.createDockerEnvironment((String)workerHarnessContainerImageURL);
            sdkComponents.registerEnvironment(defaultEnvironmentForDataflow);
            return WindowingStrategyTranslation.toMessageProto(windowingStrategy, (SdkComponents)sdkComponents).toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Unable to format windowing strategy %s as bytes", windowingStrategy), e);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized DataflowPipelineTranslator fromOptions(@UnknownKeyFor @NonNull @Initialized DataflowPipelineOptions options) {
        return new DataflowPipelineTranslator(options);
    }

    private DataflowPipelineTranslator(@UnknownKeyFor @NonNull @Initialized DataflowPipelineOptions options) {
        this.options = options;
    }

    public @UnknownKeyFor @NonNull @Initialized JobSpecification translate(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipelineProto, @UnknownKeyFor @NonNull @Initialized SdkComponents sdkComponents, @UnknownKeyFor @NonNull @Initialized DataflowRunner runner, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized DataflowPackage> packages) {
        Translator translator = new Translator(pipeline, runner, sdkComponents);
        Job result = translator.translate(packages);
        return new JobSpecification(result, pipelineProto, Collections.unmodifiableMap(translator.stepNames));
    }

    public static @UnknownKeyFor @NonNull @Initialized String jobToString(@UnknownKeyFor @NonNull @Initialized Job job) {
        try {
            return MAPPER.writeValueAsString((Object)job);
        }
        catch (JsonProcessingException exc) {
            throw new IllegalStateException("Failed to render Job as String.", exc);
        }
    }

    public static <TransformT extends PTransform> void registerTransformTranslator(@UnknownKeyFor @NonNull @Initialized Class<TransformT> transformClass, @UnknownKeyFor @NonNull @Initialized TransformTranslator<@UnknownKeyFor @NonNull @Initialized ? extends TransformT> transformTranslator) {
        if (transformTranslators.put(transformClass, transformTranslator) != null) {
            throw new IllegalArgumentException("defining multiple translators for " + transformClass);
        }
    }

    public <TransformT extends PTransform> @UnknownKeyFor @NonNull @Initialized TransformTranslator<TransformT> getTransformTranslator(@UnknownKeyFor @NonNull @Initialized Class<TransformT> transformClass) {
        return transformTranslators.get(transformClass);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "DataflowPipelineTranslator#" + this.hashCode();
    }

    private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> getProperties(@UnknownKeyFor @NonNull @Initialized Step step) {
        HashMap properties = step.getProperties();
        if (properties == null) {
            properties = new HashMap();
            step.setProperties(properties);
        }
        return properties;
    }

    private static void translateInputs(@UnknownKeyFor @NonNull @Initialized TransformTranslator.StepTranslationContext stepContext, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> input, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputs, @UnknownKeyFor @NonNull @Initialized TransformTranslator.TranslationContext context) {
        stepContext.addInput("parallel_input", (PInput)input);
        DataflowPipelineTranslator.translateSideInputs(stepContext, sideInputs, context);
    }

    private static void translateSideInputs(@UnknownKeyFor @NonNull @Initialized TransformTranslator.StepTranslationContext stepContext, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputs, @UnknownKeyFor @NonNull @Initialized TransformTranslator.TranslationContext context) {
        HashMap<String, Object> nonParInputs = new HashMap<String, Object>();
        for (PCollectionView<?> view : sideInputs) {
            nonParInputs.put(view.getTagInternal().getId(), (Object)context.asOutputReference((PValue)view, context.getProducer((PValue)view)));
        }
        stepContext.addInput("non_parallel_inputs", nonParInputs);
    }

    private static void translateFn(@UnknownKeyFor @NonNull @Initialized TransformTranslator.StepTranslationContext stepContext, @UnknownKeyFor @NonNull @Initialized DoFn fn, @UnknownKeyFor @NonNull @Initialized WindowingStrategy windowingStrategy, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputs, @UnknownKeyFor @NonNull @Initialized Coder inputCoder, @UnknownKeyFor @NonNull @Initialized TransformTranslator.TranslationContext context, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> mainOutput, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputCoders, @UnknownKeyFor @NonNull @Initialized DoFnSchemaInformation doFnSchemaInformation, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputMapping) {
        boolean isStateful = DoFnSignatures.isStateful((DoFn)fn);
        if (isStateful) {
            DataflowPipelineOptions options = context.getPipelineOptions();
            DataflowRunner.verifyDoFnSupported(fn, options.isStreaming(), options);
            DataflowRunner.verifyStateSupportForWindowingStrategy(windowingStrategy);
        }
        stepContext.addInput("user_fn", fn.getClass().getName());
        stepContext.addInput("serialized_fn", StringUtils.byteArrayToJsonString((byte[])SerializableUtils.serializeToByteArray((Serializable)DoFnInfo.forFn((DoFn)fn, (WindowingStrategy)windowingStrategy, sideInputs, (Coder)inputCoder, outputCoders, mainOutput, (DoFnSchemaInformation)doFnSchemaInformation, sideInputMapping))));
        if (context.getPipelineOptions().isStreaming() && isStateful) {
            stepContext.addInput("uses_keyed_state", "true");
        }
    }

    private static void translateOutputs(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputs, @UnknownKeyFor @NonNull @Initialized TransformTranslator.StepTranslationContext stepContext) {
        for (Map.Entry<TupleTag<?>, PCollection<?>> taggedOutput : outputs.entrySet()) {
            TupleTag<?> tag = taggedOutput.getKey();
            stepContext.addOutput(tag.getId(), taggedOutput.getValue());
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized CloudObject translateCoder(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coder) {
        return CloudObjects.asCloudObject(coder, null);
    }

    static {
        DataflowPipelineTranslator.registerTransformTranslator(View.CreatePCollectionView.class, new TransformTranslator<View.CreatePCollectionView>(){

            @Override
            public void translate(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized View.CreatePCollectionView transform, @UnknownKeyFor @NonNull @Initialized TransformTranslator.TranslationContext context) {
                this.translateTyped(transform, context);
            }

            private <ElemT, ViewT> void translateTyped(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized View.CreatePCollectionView<ElemT, ViewT> transform, @UnknownKeyFor @NonNull @Initialized TransformTranslator.TranslationContext context) {
                TransformTranslator.StepTranslationContext stepContext = context.addStep((PTransform<?, ?>)transform, "CollectionToSingleton");
                PCollection input = (PCollection)context.getInput(transform);
                stepContext.addInput("parallel_input", (PInput)input);
                WindowingStrategy windowingStrategy = input.getWindowingStrategy();
                stepContext.addInput("windowing_strategy", StringUtils.byteArrayToJsonString((byte[])DataflowPipelineTranslator.serializeWindowingStrategy(windowingStrategy, context.getPipelineOptions())));
                stepContext.addInput("is_merging_window_fn", windowingStrategy.needsMerge());
                stepContext.addCollectionToSingletonOutput(input, "output", transform.getView());
            }
        });
        DataflowPipelineTranslator.registerTransformTranslator(CreateDataflowView.class, new TransformTranslator<CreateDataflowView>(){

            @Override
            public void translate(@UnknownKeyFor @NonNull @Initialized CreateDataflowView transform, @UnknownKeyFor @NonNull @Initialized TransformTranslator.TranslationContext context) {
                this.translateTyped(transform, context);
            }

            private <ElemT, ViewT> void translateTyped(@UnknownKeyFor @NonNull @Initialized CreateDataflowView<ElemT, ViewT> transform, @UnknownKeyFor @NonNull @Initialized TransformTranslator.TranslationContext context) {
                TransformTranslator.StepTranslationContext stepContext = context.addStep(transform, "CollectionToSingleton");
                PCollection input = (PCollection)context.getInput(transform);
                stepContext.addInput("parallel_input", (PInput)input);
                stepContext.addCollectionToSingletonOutput(input, "output", transform.getView());
            }
        });
        DataflowPipelineTranslator.registerTransformTranslator(DataflowRunner.CombineGroupedValues.class, new TransformTranslator<DataflowRunner.CombineGroupedValues>(){

            @Override
            public void translate(@UnknownKeyFor @NonNull @Initialized DataflowRunner.CombineGroupedValues transform, @UnknownKeyFor @NonNull @Initialized TransformTranslator.TranslationContext context) {
                this.translateHelper(transform, context);
            }

            private <K, InputT, OutputT> void translateHelper(@UnknownKeyFor @NonNull @Initialized DataflowRunner.CombineGroupedValues<K, InputT, OutputT> primitiveTransform, @UnknownKeyFor @NonNull @Initialized TransformTranslator.TranslationContext context) {
                Combine.GroupedValues<K, InputT, OutputT> originalTransform = primitiveTransform.getOriginalCombine();
                TransformTranslator.StepTranslationContext stepContext = context.addStep(primitiveTransform, "CombineValues");
                DataflowPipelineTranslator.translateInputs(stepContext, (PCollection)context.getInput(primitiveTransform), originalTransform.getSideInputs(), context);
                AppliedCombineFn fn = originalTransform.getAppliedFn(((PCollection)context.getInput(primitiveTransform)).getPipeline().getCoderRegistry(), ((PCollection)context.getInput(primitiveTransform)).getCoder(), ((PCollection)context.getInput(primitiveTransform)).getWindowingStrategy());
                stepContext.addEncodingInput(fn.getAccumulatorCoder());
                stepContext.addInput("serialized_fn", StringUtils.byteArrayToJsonString((byte[])SerializableUtils.serializeToByteArray((Serializable)fn)));
                stepContext.addOutput("output", (PCollection)context.getOutput(primitiveTransform));
            }
        });
        DataflowPipelineTranslator.registerTransformTranslator(Flatten.PCollections.class, new TransformTranslator<Flatten.PCollections>(){

            @Override
            public void translate(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized Flatten.PCollections transform, @UnknownKeyFor @NonNull @Initialized TransformTranslator.TranslationContext context) {
                this.flattenHelper(transform, context);
            }

            private <T> void flattenHelper(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized Flatten.PCollections<T> transform, @UnknownKeyFor @NonNull @Initialized TransformTranslator.TranslationContext context) {
                TransformTranslator.StepTranslationContext stepContext = context.addStep((PTransform<?, ?>)transform, "Flatten");
                ArrayList<OutputReference> inputs = new ArrayList<OutputReference>();
                for (PValue pValue : context.getInputs(transform).values()) {
                    inputs.add(context.asOutputReference(pValue, context.getProducer(pValue)));
                }
                stepContext.addInput("inputs", inputs);
                stepContext.addOutput("output", (PCollection)context.getOutput(transform));
            }
        });
        DataflowPipelineTranslator.registerTransformTranslator(BatchViewOverrides.GroupByKeyAndSortValuesOnly.class, new TransformTranslator<BatchViewOverrides.GroupByKeyAndSortValuesOnly>(){

            @Override
            public void translate( @UnknownKeyFor @NonNull @Initialized BatchViewOverrides.GroupByKeyAndSortValuesOnly transform, @UnknownKeyFor @NonNull @Initialized TransformTranslator.TranslationContext context) {
                this.groupByKeyAndSortValuesHelper(transform, context);
            }

            private <K1, K2, V> void groupByKeyAndSortValuesHelper( @UnknownKeyFor @NonNull @Initialized BatchViewOverrides.GroupByKeyAndSortValuesOnly<K1, K2, V> transform, @UnknownKeyFor @NonNull @Initialized TransformTranslator.TranslationContext context) {
                TransformTranslator.StepTranslationContext stepContext = context.addStep(transform, "GroupByKey");
                PCollection input = (PCollection)context.getInput(transform);
                stepContext.addInput("parallel_input", (PInput)input);
                stepContext.addOutput("output", (PCollection)context.getOutput(transform));
                stepContext.addInput("sort_values", true);
                stepContext.addInput("disallow_combiner_lifting", true);
            }
        });
        DataflowPipelineTranslator.registerTransformTranslator(DataflowGroupByKey.class, new TransformTranslator<DataflowGroupByKey>(){

            @Override
            public void translate(@UnknownKeyFor @NonNull @Initialized DataflowGroupByKey transform, @UnknownKeyFor @NonNull @Initialized TransformTranslator.TranslationContext context) {
                this.dataflowGroupByKeyHelper(transform, context);
            }

            private <K, V> void dataflowGroupByKeyHelper(@UnknownKeyFor @NonNull @Initialized DataflowGroupByKey<K, V> transform, @UnknownKeyFor @NonNull @Initialized TransformTranslator.TranslationContext context) {
                TransformTranslator.StepTranslationContext stepContext = context.addStep(transform, "GroupByKey");
                PCollection input = (PCollection)context.getInput(transform);
                stepContext.addInput("parallel_input", (PInput)input);
                stepContext.addOutput("output", (PCollection)context.getOutput(transform));
                WindowingStrategy windowingStrategy = input.getWindowingStrategy();
                stepContext.addInput("disallow_combiner_lifting", true);
                stepContext.addInput("serialized_fn", StringUtils.byteArrayToJsonString((byte[])DataflowPipelineTranslator.serializeWindowingStrategy(windowingStrategy, context.getPipelineOptions())));
                stepContext.addInput("is_merging_window_fn", !windowingStrategy.getWindowFn().isNonMerging());
                stepContext.addInput("allow_duplicates", transform.allowDuplicates());
            }
        });
        DataflowPipelineTranslator.registerTransformTranslator(GroupByKey.class, new TransformTranslator<GroupByKey>(){

            @Override
            public void translate(@UnknownKeyFor @NonNull @Initialized GroupByKey transform, @UnknownKeyFor @NonNull @Initialized TransformTranslator.TranslationContext context) {
                this.groupByKeyHelper(transform, context);
            }

            private <K, V> void groupByKeyHelper(@UnknownKeyFor @NonNull @Initialized GroupByKey<K, V> transform, @UnknownKeyFor @NonNull @Initialized TransformTranslator.TranslationContext context) {
                boolean allowCombinerLifting;
                TransformTranslator.StepTranslationContext stepContext = context.addStep((PTransform<?, ?>)transform, "GroupByKey");
                PCollection input = (PCollection)context.getInput(transform);
                stepContext.addInput("parallel_input", (PInput)input);
                stepContext.addOutput("output", (PCollection)context.getOutput(transform));
                WindowingStrategy windowingStrategy = input.getWindowingStrategy();
                boolean isStreaming = ((StreamingOptions)context.getPipelineOptions().as(StreamingOptions.class)).isStreaming();
                boolean bl = allowCombinerLifting = !windowingStrategy.needsMerge() && windowingStrategy.getWindowFn().assignsToOneWindow();
                if (isStreaming) {
                    allowCombinerLifting &= transform.fewKeys();
                    allowCombinerLifting &= windowingStrategy.getTrigger() instanceof DefaultTrigger;
                }
                stepContext.addInput("disallow_combiner_lifting", !allowCombinerLifting);
                stepContext.addInput("serialized_fn", StringUtils.byteArrayToJsonString((byte[])DataflowPipelineTranslator.serializeWindowingStrategy(windowingStrategy, context.getPipelineOptions())));
                stepContext.addInput("is_merging_window_fn", !windowingStrategy.getWindowFn().isNonMerging());
            }
        });
        DataflowPipelineTranslator.registerTransformTranslator(ParDo.MultiOutput.class, new TransformTranslator<ParDo.MultiOutput>(){

            @Override
            public void translate(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ParDo.MultiOutput transform, @UnknownKeyFor @NonNull @Initialized TransformTranslator.TranslationContext context) {
                this.translateMultiHelper(transform, context);
            }

            private <InputT, OutputT> void translateMultiHelper(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ParDo.MultiOutput<InputT, OutputT> transform, @UnknownKeyFor @NonNull @Initialized TransformTranslator.TranslationContext context) {
                TransformTranslator.StepTranslationContext stepContext = context.addStep((PTransform<?, ?>)transform, "ParallelDo");
                DoFnSchemaInformation doFnSchemaInformation = ParDoTranslation.getSchemaInformation(context.getCurrentTransform());
                Map sideInputMapping = ParDoTranslation.getSideInputMapping(context.getCurrentTransform());
                Map<TupleTag, Coder> outputCoders = context.getOutputs(transform).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((PCollection)e.getValue()).getCoder()));
                DataflowPipelineTranslator.translateInputs(stepContext, (PCollection)context.getInput(transform), transform.getSideInputs().values(), context);
                DataflowPipelineTranslator.translateOutputs(context.getOutputs(transform), stepContext);
                DataflowPipelineTranslator.translateFn(stepContext, transform.getFn(), ((PCollection)context.getInput(transform)).getWindowingStrategy(), transform.getSideInputs().values(), ((PCollection)context.getInput(transform)).getCoder(), context, transform.getMainOutputTag(), outputCoders, doFnSchemaInformation, sideInputMapping);
            }
        });
        DataflowPipelineTranslator.registerTransformTranslator(PrimitiveParDoSingleFactory.ParDoSingle.class, new TransformTranslator<PrimitiveParDoSingleFactory.ParDoSingle>(){

            @Override
            public void translate(PrimitiveParDoSingleFactory.ParDoSingle transform, TransformTranslator.TranslationContext context) {
                this.translateSingleHelper(transform, context);
            }

            private <InputT, OutputT> void translateSingleHelper(PrimitiveParDoSingleFactory.ParDoSingle<InputT, OutputT> transform, TransformTranslator.TranslationContext context) {
                DoFnSchemaInformation doFnSchemaInformation = ParDoTranslation.getSchemaInformation(context.getCurrentTransform());
                Map sideInputMapping = ParDoTranslation.getSideInputMapping(context.getCurrentTransform());
                TransformTranslator.StepTranslationContext stepContext = context.addStep((PTransform<?, ?>)transform, "ParallelDo");
                Map<TupleTag, Coder> outputCoders = context.getOutputs(transform).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((PCollection)e.getValue()).getCoder()));
                DataflowPipelineTranslator.translateInputs(stepContext, (PCollection)context.getInput(transform), transform.getSideInputs().values(), context);
                stepContext.addOutput(transform.getMainOutputTag().getId(), (PCollection)context.getOutput(transform));
                DataflowPipelineTranslator.translateFn(stepContext, transform.getFn(), ((PCollection)context.getInput(transform)).getWindowingStrategy(), transform.getSideInputs().values(), ((PCollection)context.getInput(transform)).getCoder(), context, transform.getMainOutputTag(), outputCoders, doFnSchemaInformation, sideInputMapping);
            }
        });
        DataflowPipelineTranslator.registerTransformTranslator(Window.Assign.class, new TransformTranslator<Window.Assign>(){

            @Override
            public void translate(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized Window.Assign transform, @UnknownKeyFor @NonNull @Initialized TransformTranslator.TranslationContext context) {
                this.translateHelper(transform, context);
            }

            private <T> void translateHelper(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized Window.Assign<T> transform, @UnknownKeyFor @NonNull @Initialized TransformTranslator.TranslationContext context) {
                TransformTranslator.StepTranslationContext stepContext = context.addStep((PTransform<?, ?>)transform, "Bucket");
                PCollection input = (PCollection)context.getInput(transform);
                stepContext.addInput("parallel_input", (PInput)input);
                stepContext.addOutput("output", (PCollection)context.getOutput(transform));
                WindowingStrategy strategy = ((PCollection)context.getOutput(transform)).getWindowingStrategy();
                byte[] serializedBytes = DataflowPipelineTranslator.serializeWindowingStrategy(strategy, context.getPipelineOptions());
                String serializedJson = StringUtils.byteArrayToJsonString((byte[])serializedBytes);
                stepContext.addInput("serialized_fn", serializedJson);
            }
        });
        DataflowPipelineTranslator.registerTransformTranslator(SplittableParDo.PrimitiveBoundedRead.class, new ReadTranslator());
        DataflowPipelineTranslator.registerTransformTranslator(TestStream.class, new TransformTranslator<TestStream>(){

            @Override
            public void translate(@UnknownKeyFor @NonNull @Initialized TestStream transform, @UnknownKeyFor @NonNull @Initialized TransformTranslator.TranslationContext context) {
                this.translateTyped(transform, context);
            }

            private <T> void translateTyped(@UnknownKeyFor @NonNull @Initialized TestStream<T> transform, @UnknownKeyFor @NonNull @Initialized TransformTranslator.TranslationContext context) {
                try {
                    TransformTranslator.StepTranslationContext stepContext = context.addStep((PTransform<?, ?>)transform, "ParallelRead");
                    String ptransformId = context.getSdkComponents().getPTransformIdOrThrow(context.getCurrentTransform());
                    stepContext.addInput("serialized_fn", ptransformId);
                    stepContext.addInput("format", "test_stream");
                    RunnerApi.TestStreamPayload.Builder payloadBuilder = RunnerApi.TestStreamPayload.newBuilder();
                    for (TestStream.Event event : transform.getEvents()) {
                        if (event instanceof TestStream.ElementEvent) {
                            RunnerApi.TestStreamPayload.Event.AddElements.Builder addElementsBuilder = RunnerApi.TestStreamPayload.Event.AddElements.newBuilder();
                            Iterable elements = ((TestStream.ElementEvent)event).getElements();
                            for (TimestampedValue element : elements) {
                                addElementsBuilder.addElements(RunnerApi.TestStreamPayload.TimestampedElement.newBuilder().setEncodedElement(ByteString.copyFrom((byte[])CoderUtils.encodeToByteArray((Coder)transform.getValueCoder(), (Object)element.getValue()))).setTimestamp(element.getTimestamp().getMillis() * 1000L));
                            }
                            payloadBuilder.addEventsBuilder().setElementEvent(addElementsBuilder);
                            continue;
                        }
                        if (event instanceof TestStream.WatermarkEvent) {
                            payloadBuilder.addEventsBuilder().setWatermarkEvent(RunnerApi.TestStreamPayload.Event.AdvanceWatermark.newBuilder().setNewWatermark(((TestStream.WatermarkEvent)event).getWatermark().getMillis() * 1000L));
                            continue;
                        }
                        if (!(event instanceof TestStream.ProcessingTimeEvent)) continue;
                        payloadBuilder.addEventsBuilder().setProcessingTimeEvent(RunnerApi.TestStreamPayload.Event.AdvanceProcessingTime.newBuilder().setAdvanceDuration(((TestStream.ProcessingTimeEvent)event).getProcessingTimeAdvance().getMillis() * 1000L));
                    }
                    stepContext.addInput("serialized_test_stream", StringUtils.byteArrayToJsonString((byte[])payloadBuilder.build().toByteArray()));
                    stepContext.addOutput("output", (PCollection)context.getOutput(transform));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        DataflowPipelineTranslator.registerTransformTranslator(SplittableParDo.ProcessKeyedElements.class, new TransformTranslator<SplittableParDo.ProcessKeyedElements>(){

            @Override
            public void translate(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized SplittableParDo.ProcessKeyedElements transform, @UnknownKeyFor @NonNull @Initialized TransformTranslator.TranslationContext context) {
                this.translateTyped(transform, context);
            }

            private <InputT, OutputT, RestrictionT, WatermarkEstimatorStateT> void translateTyped(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized SplittableParDo.ProcessKeyedElements<InputT, OutputT, RestrictionT, WatermarkEstimatorStateT> transform, @UnknownKeyFor @NonNull @Initialized TransformTranslator.TranslationContext context) {
                DoFnSchemaInformation doFnSchemaInformation = ParDoTranslation.getSchemaInformation(context.getCurrentTransform());
                Map sideInputMapping = ParDoTranslation.getSideInputMapping(context.getCurrentTransform());
                TransformTranslator.StepTranslationContext stepContext = context.addStep((PTransform<?, ?>)transform, "SplittableProcessKeyed");
                Map<TupleTag, Coder> outputCoders = context.getOutputs(transform).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((PCollection)e.getValue()).getCoder()));
                DataflowPipelineTranslator.translateInputs(stepContext, (PCollection)context.getInput(transform), transform.getSideInputs(), context);
                DataflowPipelineTranslator.translateOutputs(context.getOutputs(transform), stepContext);
                DataflowPipelineTranslator.translateFn(stepContext, transform.getFn(), transform.getInputWindowingStrategy(), transform.getSideInputs(), transform.getElementCoder(), context, transform.getMainOutputTag(), outputCoders, doFnSchemaInformation, sideInputMapping);
                stepContext.addInput("restriction_coder", (Map<String, Object>)((Object)DataflowPipelineTranslator.translateCoder((Coder)KvCoder.of((Coder)transform.getRestrictionCoder(), (Coder)transform.getWatermarkEstimatorStateCoder()))));
            }
        });
    }

    static class StepTranslator
    implements TransformTranslator.StepTranslationContext {
        private final @UnknownKeyFor @NonNull @Initialized DataflowPipelineTranslator. @UnknownKeyFor @NonNull @Initialized Translator translator;
        private final @UnknownKeyFor @NonNull @Initialized Step step;
        private final @UnknownKeyFor @NonNull @Initialized PercentCodec percentCodec = new PercentCodec("+".getBytes(StandardCharsets.US_ASCII), false);

        private StepTranslator(@UnknownKeyFor @NonNull @Initialized DataflowPipelineTranslator. @UnknownKeyFor @NonNull @Initialized Translator translator, @UnknownKeyFor @NonNull @Initialized Step step) {
            this.translator = translator;
            this.step = step;
        }

        private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> getProperties() {
            return DataflowPipelineTranslator.getProperties(this.step);
        }

        @Override
        public void addEncodingInput(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coder) {
            CloudObject encoding = DataflowPipelineTranslator.translateCoder(coder);
            Structs.addObject(this.getProperties(), "encoding", (Map<String, Object>)((Object)encoding));
        }

        @Override
        public void addInput(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Boolean value) {
            Structs.addBoolean(this.getProperties(), name, value);
        }

        @Override
        public void addInput(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized String value) {
            Structs.addString(this.getProperties(), name, value);
        }

        @Override
        public void addInput(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Long value) {
            Structs.addLong(this.getProperties(), name, value);
        }

        @Override
        public void addInput(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> elements) {
            Structs.addDictionary(this.getProperties(), name, elements);
        }

        @Override
        public void addInput(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object>> elements) {
            Structs.addList(this.getProperties(), name, elements);
        }

        @Override
        public void addInput(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized PInput value) {
            if (!(value instanceof PValue)) {
                throw new IllegalStateException("Input must be a PValue");
            }
            PValue pvalue = (PValue)value;
            this.addInput(name, (Map<String, Object>)((Object)this.translator.asOutputReference(pvalue, this.translator.getProducer(pvalue))));
        }

        @Override
        public void addOutput(@UnknownKeyFor @NonNull @Initialized String name, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> value) {
            this.translator.producers.put(value, this.translator.currentTransform);
            WindowedValues.FullWindowedValueCoder coder = WindowedValues.getFullCoder((Coder)value.getCoder(), (Coder)value.getWindowingStrategy().getWindowFn().windowCoder());
            this.addOutput(name, (PValue)value, (Coder<?>)coder);
        }

        @Override
        public void addCollectionToSingletonOutput(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> inputValue, @UnknownKeyFor @NonNull @Initialized String outputName, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> outputValue) {
            this.translator.producers.put(outputValue, this.translator.currentTransform);
            Coder inputValueCoder = (Coder)Preconditions.checkNotNull((Object)((Coder)this.translator.outputCoders.get(inputValue)));
            Preconditions.checkState((boolean)(inputValueCoder instanceof WindowedValues.WindowedValueCoder));
            IterableCoder outputValueCoder = IterableCoder.of((Coder)inputValueCoder);
            this.addOutput(outputName, (PValue)outputValue, (Coder<?>)outputValueCoder);
        }

        private void addOutput(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized PValue value, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> valueCoder) {
            this.translator.registerOutputName(value, name);
            if (value instanceof PCollection) {
                if (this.translator.runner.doesPCollectionRequireAutoSharding((PCollection)value)) {
                    this.addInput("allows_shardable_state", "true");
                }
                if (this.translator.runner.doesPCollectionPreserveKeys((PCollection)value)) {
                    this.addInput("preserves_keys", "true");
                }
            }
            Map<String, Object> properties = this.getProperties();
            ArrayList<HashMap<String, Object>> outputInfoList = null;
            try {
                outputInfoList = (ArrayList<HashMap<String, Object>>)properties.get("output_info");
            }
            catch (Exception e) {
                throw new RuntimeException("Inconsistent dataflow pipeline translation", e);
            }
            if (outputInfoList == null) {
                outputInfoList = new ArrayList<HashMap<String, Object>>();
                properties.put("output_info", outputInfoList);
            }
            HashMap<String, Object> outputInfo = new HashMap<String, Object>();
            Structs.addString(outputInfo, "output_name", name);
            String stepName = Structs.getString(properties, "user_name");
            String generatedName = String.format("%s.out%d", stepName, outputInfoList.size());
            Structs.addString(outputInfo, "user_name", generatedName);
            if (value instanceof PCollection && this.translator.runner.doesPCollectionRequireIndexedFormat((PCollection)value) || value instanceof PCollectionView && "beam:side_input:multimap:v1".equals(((PCollectionView)value).getViewFn().getMaterialization().getUrn())) {
                Structs.addBoolean(outputInfo, "use_indexed_format", true);
            }
            if (valueCoder != null) {
                CloudObject encoding = DataflowPipelineTranslator.translateCoder(valueCoder);
                Structs.addObject(outputInfo, "encoding", (Map<String, Object>)((Object)encoding));
                this.translator.outputCoders.put(value, valueCoder);
            }
            outputInfoList.add(outputInfo);
        }

        private void addDisplayData(@UnknownKeyFor @NonNull @Initialized HasDisplayData hasDisplayData) {
            DisplayData displayData = DisplayData.from((HasDisplayData)hasDisplayData);
            List list = (List)MAPPER.convertValue((Object)displayData, List.class);
            Structs.addList(this.getProperties(), "display_data", list);
        }

        private void addResourceHints(@UnknownKeyFor @NonNull @Initialized ResourceHints hints) {
            HashMap<String, Object> urlEncodedHints = new HashMap<String, Object>();
            for (Map.Entry entry : hints.hints().entrySet()) {
                try {
                    urlEncodedHints.put((String)entry.getKey(), new String(this.percentCodec.encode(((ResourceHint)entry.getValue()).toBytes()), StandardCharsets.US_ASCII));
                }
                catch (EncoderException e) {
                    throw new RuntimeException("Invalid value for resource hint: " + (String)entry.getKey(), e);
                }
            }
            if (urlEncodedHints.size() > 0) {
                Structs.addDictionary(this.getProperties(), "resource_hints", urlEncodedHints);
            }
        }
    }

    class Translator
    extends Pipeline.PipelineVisitor.Defaults
    implements TransformTranslator.TranslationContext {
        private final @UnknownKeyFor @NonNull @Initialized Pipeline pipeline;
        private final @UnknownKeyFor @NonNull @Initialized DataflowRunner runner;
        private final @UnknownKeyFor @NonNull @Initialized Job job = new Job();
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized String> stepNames = new HashMap();
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PValue, @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> producers = new HashMap();
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PValue, @UnknownKeyFor @NonNull @Initialized String> outputNames = new HashMap<PValue, String>();
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PValue, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputCoders = new HashMap();
        private final @UnknownKeyFor @NonNull @Initialized SdkComponents sdkComponents;
        private /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> currentTransform;
        private @UnknownKeyFor @NonNull @Initialized ArrayDeque<// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node> parents = new ArrayDeque();

        public Translator(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized DataflowRunner runner, SdkComponents sdkComponents) {
            this.pipeline = pipeline;
            this.runner = runner;
            this.sdkComponents = sdkComponents;
        }

        public @UnknownKeyFor @NonNull @Initialized Job translate(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized DataflowPackage> packages) {
            List<String> experiments;
            this.job.setName(DataflowPipelineTranslator.this.options.getJobName().toLowerCase());
            Environment environment = new Environment();
            this.job.setEnvironment(environment);
            this.job.getEnvironment().setServiceOptions(DataflowPipelineTranslator.this.options.getDataflowServiceOptions());
            WorkerPool workerPool = new WorkerPool();
            if (DataflowPipelineTranslator.this.options.isEnableStreamingEngine()) {
                experiments = DataflowPipelineTranslator.this.options.getExperiments();
                experiments = experiments == null ? new ArrayList<String>() : new ArrayList(experiments);
                if (!experiments.contains("enable_streaming_engine")) {
                    experiments.add("enable_streaming_engine");
                }
                if (!experiments.contains("enable_windmill_service")) {
                    experiments.add("enable_windmill_service");
                }
                DataflowPipelineTranslator.this.options.setExperiments(experiments);
            } else {
                experiments = DataflowPipelineTranslator.this.options.getExperiments();
                if (experiments != null && (experiments.contains("enable_streaming_engine") || experiments.contains("enable_windmill_service"))) {
                    throw new IllegalArgumentException("Streaming engine both disabled and enabled: enableStreamingEngine is set to false, but enable_windmill_service and/or enable_streaming_engine are present. It is recommended you only set enableStreamingEngine.");
                }
            }
            if (DataflowPipelineTranslator.this.options.isStreaming()) {
                this.job.setType("JOB_TYPE_STREAMING");
            } else {
                this.job.setType("JOB_TYPE_BATCH");
                workerPool.setDiskType(DataflowPipelineTranslator.this.options.getWorkerDiskType());
            }
            if (DataflowPipelineTranslator.this.options.getWorkerMachineType() != null) {
                workerPool.setMachineType(DataflowPipelineTranslator.this.options.getWorkerMachineType());
            }
            if (DataflowPipelineTranslator.this.options.getUsePublicIps() != null) {
                if (DataflowPipelineTranslator.this.options.getUsePublicIps().booleanValue()) {
                    workerPool.setIpConfiguration("WORKER_IP_PUBLIC");
                } else {
                    workerPool.setIpConfiguration("WORKER_IP_PRIVATE");
                }
            }
            workerPool.setPackages(packages);
            workerPool.setNumWorkers(Integer.valueOf(DataflowPipelineTranslator.this.options.getNumWorkers()));
            if (DataflowPipelineTranslator.this.options.getMaxNumWorkers() != 0 && DataflowPipelineTranslator.this.options.getNumWorkers() > DataflowPipelineTranslator.this.options.getMaxNumWorkers()) {
                throw new IllegalArgumentException(String.format("numWorkers (%d) cannot exceed maxNumWorkers (%d).", DataflowPipelineTranslator.this.options.getNumWorkers(), DataflowPipelineTranslator.this.options.getMaxNumWorkers()));
            }
            if (DataflowPipelineTranslator.this.options.getLabels() != null) {
                this.job.setLabels(DataflowPipelineTranslator.this.options.getLabels());
            }
            if (DataflowPipelineTranslator.this.options.isStreaming() && !ExperimentalOptions.hasExperiment((PipelineOptions)DataflowPipelineTranslator.this.options, (String)"enable_windmill_service")) {
                Disk disk = new Disk();
                disk.setDiskType(DataflowPipelineTranslator.this.options.getWorkerDiskType());
                workerPool.setDataDisks(Collections.singletonList(disk));
            }
            if (!Strings.isNullOrEmpty((String)DataflowPipelineTranslator.this.options.getZone())) {
                workerPool.setZone(DataflowPipelineTranslator.this.options.getZone());
            }
            if (!Strings.isNullOrEmpty((String)DataflowPipelineTranslator.this.options.getNetwork())) {
                workerPool.setNetwork(DataflowPipelineTranslator.this.options.getNetwork());
            }
            if (!Strings.isNullOrEmpty((String)DataflowPipelineTranslator.this.options.getSubnetwork())) {
                workerPool.setSubnetwork(DataflowPipelineTranslator.this.options.getSubnetwork());
            }
            if (DataflowPipelineTranslator.this.options.getDiskSizeGb() > 0) {
                workerPool.setDiskSizeGb(Integer.valueOf(DataflowPipelineTranslator.this.options.getDiskSizeGb()));
            }
            AutoscalingSettings settings = new AutoscalingSettings();
            if (DataflowPipelineTranslator.this.options.getAutoscalingAlgorithm() != null) {
                settings.setAlgorithm(DataflowPipelineTranslator.this.options.getAutoscalingAlgorithm().getAlgorithm());
            }
            settings.setMaxNumWorkers(Integer.valueOf(DataflowPipelineTranslator.this.options.getMaxNumWorkers()));
            workerPool.setAutoscalingSettings(settings);
            ArrayList<WorkerPool> workerPools = new ArrayList<WorkerPool>();
            workerPools.add(workerPool);
            environment.setWorkerPools(workerPools);
            if (DataflowPipelineTranslator.this.options.getServiceAccount() != null) {
                environment.setServiceAccountEmail(DataflowPipelineTranslator.this.options.getServiceAccount());
            }
            if (DataflowPipelineTranslator.this.options.getDataflowKmsKey() != null) {
                environment.setServiceKmsKeyName(DataflowPipelineTranslator.this.options.getDataflowKmsKey());
            }
            if (DataflowPipelineTranslator.this.options.isHotKeyLoggingEnabled() || ExperimentalOptions.hasExperiment((PipelineOptions)DataflowPipelineTranslator.this.options, (String)"enable_hot_key_logging")) {
                DebugOptions debugOptions = new DebugOptions();
                debugOptions.setEnableHotKeyLogging(Boolean.valueOf(true));
                environment.setDebugOptions(debugOptions);
            }
            if (DataflowRunner.useUnifiedWorker(DataflowPipelineTranslator.this.options)) {
                LOG.info("Skipping v1 pipeline translation since this job will run on v2.");
            } else {
                this.pipeline.traverseTopologically((Pipeline.PipelineVisitor)this);
            }
            return this.job;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized DataflowPipelineOptions getPipelineOptions() {
            return DataflowPipelineTranslator.this.options;
        }

        @Override
        public <InputT extends PInput> /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getInputs(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PTransform<InputT, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
            return this.getCurrentTransform(transform).getInputs();
        }

        @Override
        public <InputT extends PValue> InputT getInput(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PTransform<InputT, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
            return (InputT)((PValue)Iterables.getOnlyElement((Iterable)TransformInputs.nonAdditionalInputs(this.getCurrentTransform(transform))));
        }

        @Override
        public <OutputT extends POutput> /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getOutputs(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, OutputT> transform) {
            return this.getCurrentTransform(transform).getOutputs();
        }

        @Override
        public <OutputT extends PValue> OutputT getOutput(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, OutputT> transform) {
            return (OutputT)((PValue)Iterables.getOnlyElement(this.getOutputs(transform).values()));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getFullName(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
            return this.getCurrentTransform(transform).getFullName();
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getCurrentTransform() {
            return this.currentTransform;
        }

        private /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getCurrentTransform(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
            Preconditions.checkArgument((this.currentTransform != null && this.currentTransform.getTransform() == transform ? 1 : 0) != 0, (Object)"can only be called with current transform");
            return this.currentTransform;
        }

        public void visitPrimitiveTransform(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
            PTransform transform = node.getTransform();
            TransformTranslator<?> translator = DataflowPipelineTranslator.this.getTransformTranslator(transform.getClass());
            Preconditions.checkState((translator != null ? 1 : 0) != 0, (String)"no translator registered for primitive transform %s at node %s", (Object)transform, (Object)node.getFullName());
            LOG.debug("Translating {}", (Object)transform);
            this.currentTransform = node.toAppliedPTransform(this.getPipeline());
            ResourceHints hints = transform.getResourceHints();
            transform.setResourceHints(this.currentTransform.getResourceHints());
            translator.translate(transform, this);
            transform.setResourceHints(hints);
            this.currentTransform = null;
        }

        public void visitValue(@UnknownKeyFor @NonNull @Initialized PValue value, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node producer) {
            LOG.debug("Checking translation of {}", (Object)value);
            if (producer.getTransform() instanceof CreateDataflowView) {
                this.asOutputReference((PValue)((CreateDataflowView)producer.getTransform()).getView(), (AppliedPTransform<?, ?, ?>)producer.toAppliedPTransform(this.getPipeline()));
                return;
            }
            this.asOutputReference(value, producer.toAppliedPTransform(this.getPipeline()));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized StepTranslator addStep(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform, @UnknownKeyFor @NonNull @Initialized String type) {
            String stepName = this.genStepName();
            if (this.stepNames.put(this.getCurrentTransform(transform), stepName) != null) {
                throw new IllegalArgumentException(transform + " already has a name specified");
            }
            ArrayList<Step> steps = this.job.getSteps();
            if (steps == null) {
                steps = new ArrayList<Step>();
                this.job.setSteps(steps);
            }
            Step step = new Step();
            step.setName(stepName);
            step.setKind(type);
            steps.add(step);
            StepTranslator stepContext = new StepTranslator(this, step);
            stepContext.addInput("user_name", this.getFullName(transform));
            stepContext.addDisplayData(transform);
            stepContext.addResourceHints(transform.getResourceHints());
            LOG.info("Adding {} as step {}", (Object)this.getCurrentTransform(transform).getFullName(), (Object)stepName);
            return stepContext;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized OutputReference asOutputReference(@UnknownKeyFor @NonNull @Initialized PValue value, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> producer) {
            String stepName = this.stepNames.get(producer);
            Preconditions.checkArgument((stepName != null ? 1 : 0) != 0, (String)"%s doesn't have a name specified", producer);
            String outputName = this.outputNames.get(value);
            Preconditions.checkArgument((outputName != null ? 1 : 0) != 0, (String)"output %s doesn't have a name specified", (Object)value);
            return new OutputReference(stepName, outputName);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized SdkComponents getSdkComponents() {
            return this.sdkComponents;
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getProducer(@UnknownKeyFor @NonNull @Initialized PValue value) {
            return (AppliedPTransform)Preconditions.checkNotNull(this.producers.get(value), (String)"Unknown producer for value %s while translating step %s", (Object)value, (Object)this.currentTransform.getFullName());
        }

        private @UnknownKeyFor @NonNull @Initialized String genStepName() {
            return "s" + (this.stepNames.size() + 1);
        }

        private void registerOutputName(@UnknownKeyFor @NonNull @Initialized PValue value, @UnknownKeyFor @NonNull @Initialized String name) {
            if (this.outputNames.put(value, name) != null) {
                throw new IllegalArgumentException("output " + value + " already has a name specified");
            }
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
            if (!node.isRootNode()) {
                this.parents.addFirst(node);
            }
            return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
        }

        public void leaveCompositeTransform(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
            if (!node.isRootNode()) {
                this.parents.removeFirst();
            }
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getCurrentParent() {
            if (this.parents.isEmpty()) {
                return null;
            }
            return this.parents.peekFirst().toAppliedPTransform(this.getPipeline());
        }
    }

    public static class JobSpecification {
        private final @UnknownKeyFor @NonNull @Initialized Job job;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized String> stepNames;
        private final // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipelineProto;

        public JobSpecification(@UnknownKeyFor @NonNull @Initialized Job job, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipelineProto, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized String> stepNames) {
            this.job = job;
            this.pipelineProto = pipelineProto;
            this.stepNames = stepNames;
        }

        public @UnknownKeyFor @NonNull @Initialized Job getJob() {
            return this.job;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline getPipelineProto() {
            return this.pipelineProto;
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized String> getStepNames() {
            return this.stepNames;
        }
    }
}

