/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.models;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ModelType;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.CompositeParameters;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.models.AbstractModelComposite;
import org.apache.hop.ui.core.widget.TextVar;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class HuggingFaceComposite
extends AbstractModelComposite {
    private final Label accessTokenLabel = this.createLabel();
    private final TextVar accessTokenInput = this.createTextVar();
    private final Label modelIdLabel;
    private final TextVar modelIdInput;
    private final Label timeoutLabel;
    private final TextVar timeoutInput;
    private final Label temperatureLabel;
    private final TextVar temperatureInput;
    private final Label maxNewTokensLabel;
    private final TextVar maxNewTokensInput;
    private final Button returnFullTextButton;
    private final Button waitForModelButton;

    public HuggingFaceComposite(CompositeParameters parameters) {
        super(ModelType.HUGGING_FACE, parameters);
        this.prepare("AccessToken", this.accessTokenLabel, (Control)this.accessTokenInput);
        this.temperatureLabel = this.createLabel();
        this.temperatureInput = this.createTextVar();
        this.prepare("Temperature", this.temperatureLabel, (Control)this.temperatureInput);
        this.modelIdLabel = this.createLabel();
        this.modelIdInput = this.createTextVar();
        this.prepare("ModelId", this.modelIdLabel, (Control)this.modelIdInput);
        this.maxNewTokensLabel = this.createLabel();
        this.maxNewTokensInput = this.createTextVar();
        this.prepare("MaxNewTokens", this.maxNewTokensLabel, (Control)this.maxNewTokensInput);
        this.timeoutLabel = this.createLabel();
        this.timeoutInput = this.createTextVar();
        this.prepare("Timeout", this.timeoutLabel, (Control)this.timeoutInput);
        this.returnFullTextButton = this.createButton();
        this.prepare("ReturnFullText", null, (Control)this.returnFullTextButton);
        this.waitForModelButton = this.createButton();
        this.prepare("WaitForModel", null, (Control)this.waitForModelButton);
    }

    @Override
    public void loadData() {
        if (!this.isSelectedModelType()) {
            return;
        }
        if (this.meta.getHuggingFaceAccessToken() != null) {
            this.accessTokenInput.setText(this.meta.getHuggingFaceAccessToken());
        }
        if (this.meta.getHuggingFaceTemperature() != null) {
            this.temperatureInput.setText("" + this.meta.getHuggingFaceTemperature());
        }
        if (this.meta.getHuggingFaceModelId() != null) {
            this.modelIdInput.setText(this.meta.getHuggingFaceModelId());
        }
        if (this.meta.getHuggingFaceMaxNewTokens() != null) {
            this.maxNewTokensInput.setText("" + this.meta.getHuggingFaceMaxNewTokens());
        }
        if (this.meta.getHuggingFaceTimeout() != null) {
            this.timeoutInput.setText("" + this.meta.getHuggingFaceTimeout());
        }
        this.returnFullTextButton.setSelection(this.meta.isHuggingFaceReturnFullText());
        this.waitForModelButton.setSelection(this.meta.isHuggingFaceWaitForModel());
    }

    @Override
    public boolean validateInputs() {
        if (!this.isSelectedModelType()) {
            return true;
        }
        String temperature = StringUtils.trim((String)this.temperatureInput.getText());
        return StringUtils.isBlank((CharSequence)temperature) || NumberUtils.isCreatable((String)temperature);
    }

    @Override
    public void updateTransformMeta() {
        if (!this.validateInputs()) {
            return;
        }
        this.meta.setHuggingFaceAccessToken(this.trimStringToNull(this.accessTokenInput.getText()));
        this.meta.setHuggingFaceTemperature(this.trimDoubleToNull(this.temperatureInput.getText()));
        this.meta.setHuggingFaceModelId(this.trimStringToNull(this.modelIdInput.getText()));
        this.meta.setHuggingFaceMaxNewTokens(this.trimIntegerToNull(this.maxNewTokensInput.getText()));
        this.meta.setHuggingFaceTimeout(this.trimIntegerToNull(this.timeoutInput.getText()));
        this.meta.setHuggingFaceReturnFullText(this.returnFullTextButton.getSelection());
        this.meta.setHuggingFaceWaitForModel(this.waitForModelButton.getSelection());
    }

    public Label getAccessTokenLabel() {
        return this.accessTokenLabel;
    }

    public TextVar getAccessTokenInput() {
        return this.accessTokenInput;
    }

    public Label getModelIdLabel() {
        return this.modelIdLabel;
    }

    public TextVar getModelIdInput() {
        return this.modelIdInput;
    }

    public Label getTimeoutLabel() {
        return this.timeoutLabel;
    }

    public TextVar getTimeoutInput() {
        return this.timeoutInput;
    }

    public Label getTemperatureLabel() {
        return this.temperatureLabel;
    }

    public TextVar getTemperatureInput() {
        return this.temperatureInput;
    }

    public Label getMaxNewTokensLabel() {
        return this.maxNewTokensLabel;
    }

    public TextVar getMaxNewTokensInput() {
        return this.maxNewTokensInput;
    }

    public Button getReturnFullTextButton() {
        return this.returnFullTextButton;
    }

    public Button getWaitForModelButton() {
        return this.waitForModelButton;
    }
}

