/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.schema;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.querybuilder.schema.AlterMaterializedView;
import com.datastax.oss.driver.api.querybuilder.schema.AlterMaterializedViewStart;
import com.datastax.oss.driver.internal.querybuilder.CqlHelper;
import com.datastax.oss.driver.internal.querybuilder.ImmutableCollections;
import com.datastax.oss.driver.internal.querybuilder.schema.OptionsUtils;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultAlterMaterializedView
implements AlterMaterializedViewStart,
AlterMaterializedView {
    private final CqlIdentifier keyspace;
    private final CqlIdentifier viewName;
    private final ImmutableMap<String, Object> options;

    public DefaultAlterMaterializedView(@NonNull CqlIdentifier viewName) {
        this(null, viewName);
    }

    public DefaultAlterMaterializedView(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier viewName) {
        this(keyspace, viewName, (ImmutableMap<String, Object>)ImmutableMap.of());
    }

    public DefaultAlterMaterializedView(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier viewName, @NonNull ImmutableMap<String, Object> options) {
        this.keyspace = keyspace;
        this.viewName = viewName;
        this.options = options;
    }

    @Override
    @NonNull
    public AlterMaterializedView withOption(@NonNull String name, @NonNull Object value) {
        return new DefaultAlterMaterializedView(this.keyspace, this.viewName, ImmutableCollections.append(this.options, name, value));
    }

    @Override
    @NonNull
    public String asCql() {
        StringBuilder builder = new StringBuilder("ALTER MATERIALIZED VIEW ");
        CqlHelper.qualify(this.keyspace, this.viewName, builder);
        builder.append(OptionsUtils.buildOptions(this.options, true));
        return builder.toString();
    }

    public String toString() {
        return this.asCql();
    }

    @Override
    @NonNull
    public Map<String, Object> getOptions() {
        return this.options;
    }

    @Nullable
    public CqlIdentifier getKeyspace() {
        return this.keyspace;
    }

    @NonNull
    public CqlIdentifier getMaterializedView() {
        return this.viewName;
    }
}

