/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.delay;

import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.widget.LabelTextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.actions.delay.ActionDelay;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ActionDelayDialog
extends ActionDialog {
    private static final Class<?> PKG = ActionDelay.class;
    private Text wName;
    private CCombo wScaleTime;
    private LabelTextVar wMaximumTimeout;
    private ActionDelay action;
    private boolean changed;

    public ActionDelayDialog(Shell parent, ActionDelay action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = action;
        if (this.action.getName() == null) {
            this.action.setName(BaseMessages.getString(PKG, (String)"ActionDelay.Title", (String[])new String[0]));
        }
    }

    public IAction open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.shell.setMinimumSize(400, 190);
        PropsUi.setLook((Widget)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        ModifyListener lsMod = e -> this.action.setChanged();
        this.changed = this.action.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionDelay.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"System.ActionName.Label", (String[])new String[0]));
        wlName.setToolTipText(BaseMessages.getString(PKG, (String)"System.ActionName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wName);
        this.wName.addModifyListener(lsMod);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, 0);
        fdName.top = new FormAttachment(0, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        this.wMaximumTimeout = new LabelTextVar(this.variables, (Composite)this.shell, BaseMessages.getString(PKG, (String)"ActionDelay.MaximumTimeout.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionDelay.MaximumTimeout.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wMaximumTimeout);
        this.wMaximumTimeout.addModifyListener(lsMod);
        FormData fdMaximumTimeout = new FormData();
        fdMaximumTimeout.left = new FormAttachment(0, 0);
        fdMaximumTimeout.top = new FormAttachment((Control)this.wName, margin);
        fdMaximumTimeout.right = new FormAttachment(100, 0);
        this.wMaximumTimeout.setLayoutData((Object)fdMaximumTimeout);
        this.wMaximumTimeout.addModifyListener(e -> this.wMaximumTimeout.setToolTipText(this.variables.resolve(this.wMaximumTimeout.getText())));
        this.wScaleTime = new CCombo((Composite)this.shell, 2060);
        this.wScaleTime.add(BaseMessages.getString(PKG, (String)"ActionDelay.SScaleTime.Label", (String[])new String[0]));
        this.wScaleTime.add(BaseMessages.getString(PKG, (String)"ActionDelay.MnScaleTime.Label", (String[])new String[0]));
        this.wScaleTime.add(BaseMessages.getString(PKG, (String)"ActionDelay.HrScaleTime.Label", (String[])new String[0]));
        this.wScaleTime.select(0);
        PropsUi.setLook((Widget)this.wScaleTime);
        FormData fdScaleTime = new FormData();
        fdScaleTime.left = new FormAttachment(middle, 0);
        fdScaleTime.top = new FormAttachment((Control)this.wMaximumTimeout, margin);
        fdScaleTime.right = new FormAttachment(100, 0);
        this.wScaleTime.setLayoutData((Object)fdScaleTime);
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)margin, null);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    public void getData() {
        if (this.action.getName() != null) {
            this.wName.setText(this.action.getName());
        }
        if (this.action.getMaximumTimeout() != null) {
            this.wMaximumTimeout.setText(this.action.getMaximumTimeout());
        }
        this.wScaleTime.select(this.action.scaleTime);
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.action.setChanged(this.changed);
        this.action = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.TransformActionNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.action.setName(this.wName.getText());
        this.action.setMaximumTimeout(this.wMaximumTimeout.getText());
        this.action.scaleTime = this.wScaleTime.getSelectionIndex();
        this.dispose();
    }
}

