/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.janino.function;

import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.pipeline.transforms.janino.function.FunctionExample;

public class FunctionDescription {
    public static final String CONST_TD = "</td>";
    private String category;
    private String name;
    private String description;
    private String syntax;
    private String returns;
    private String constraints;
    private String semantics;
    private String importPackage;
    private List<FunctionExample> functionExamples;

    public FunctionDescription(String category, String name, String description, String syntax, String returns, String constraints, String semantics, String importPackage, List<FunctionExample> functionExamples) {
        this.category = category;
        this.name = name;
        this.description = description;
        this.syntax = syntax;
        this.returns = returns;
        this.constraints = constraints;
        this.semantics = semantics;
        this.importPackage = importPackage;
        this.functionExamples = functionExamples;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void setSyntax(String syntax) {
        this.syntax = syntax;
    }

    public String getReturns() {
        return this.returns;
    }

    public void setReturns(String returns) {
        this.returns = returns;
    }

    public String getConstraints() {
        return this.constraints;
    }

    public void setConstraints(String constraints) {
        this.constraints = constraints;
    }

    public String getSemantics() {
        return this.semantics;
    }

    public void setSemantics(String semantics) {
        this.semantics = semantics;
    }

    public List<FunctionExample> getFunctionExamples() {
        return this.functionExamples;
    }

    public void setFunctionExamples(List<FunctionExample> functionExamples) {
        this.functionExamples = functionExamples;
    }

    public String getHtmlReport() {
        StringBuilder report = new StringBuilder(200);
        report.append("<H2>").append(this.name).append("</H2>").append(Const.CR);
        report.append("<b><u>Description:</u></b> ").append(this.description).append("<br>").append(Const.CR);
        if (!Utils.isEmpty((CharSequence)this.syntax)) {
            report.append("<b><u>Syntax:</u></b> <pre>").append(this.syntax).append("</pre><br>").append(Const.CR);
        }
        if (!Utils.isEmpty((CharSequence)this.returns)) {
            report.append("<b><u>Returns:</u></b>  ").append(this.returns).append("<br>").append(Const.CR);
        }
        if (!Utils.isEmpty((CharSequence)this.constraints)) {
            report.append("<b><u>Constraints:</u></b>  ").append(this.constraints).append("<br>").append(Const.CR);
        }
        if (!Utils.isEmpty((CharSequence)this.semantics)) {
            report.append("<b><u>Semantics:</u></b>  ").append(this.semantics).append("<br>").append(Const.CR);
        }
        if (!this.functionExamples.isEmpty()) {
            report.append(Const.CR);
            report.append("<br><b><u>Examples:</u></b><p>  ").append(Const.CR);
            report.append("<table border=\"1\">");
            report.append("<tr>");
            report.append("<th>Expression</th>");
            report.append("<th>Result</th>");
            report.append("<th>Comment</th>");
            report.append("</tr>");
            for (FunctionExample example : this.functionExamples) {
                report.append("<tr>");
                report.append("<td>").append(example.getExpression()).append(CONST_TD);
                report.append("<td>").append(example.getResult()).append(CONST_TD);
                if (!Utils.isEmpty((CharSequence)example.getComment())) {
                    report.append("<td>").append(example.getComment()).append(CONST_TD);
                }
                report.append("</tr>");
                report.append(Const.CR);
            }
            report.append("</table>");
        }
        return report.toString();
    }

    public String getImportPackage() {
        return this.importPackage;
    }

    public void setImportPackage(String importPackage) {
        this.importPackage = importPackage;
    }
}

