/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.keys;

import java.util.Arrays;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.util.typedef.F;

public abstract class JavaObjectIndexKey
implements IndexKey {
    private static final byte[] EMPTY_BYTES = new byte[0];

    public int hashCode() {
        return this.key().hashCode();
    }

    @Override
    public IndexKeyType type() {
        return IndexKeyType.JAVA_OBJECT;
    }

    @Override
    public int compare(IndexKey o) {
        int h2;
        Object o1 = this.key();
        Object o2 = o.key();
        boolean isComparable = o1 instanceof Comparable;
        boolean otherIsComparable = o2 instanceof Comparable;
        if (isComparable && otherIsComparable && JavaObjectIndexKey.haveCommonComparableSuperclass(o1.getClass(), o2.getClass())) {
            return ((Comparable)o1).compareTo(o2);
        }
        if (o1.getClass() != o2.getClass()) {
            if (isComparable != otherIsComparable) {
                return isComparable ? -1 : 1;
            }
            return o1.getClass().getName().compareTo(o2.getClass().getName());
        }
        int h1 = o1.hashCode();
        if (h1 == (h2 = o2.hashCode())) {
            return o1.equals(o2) ? 0 : Integer.signum(F.compareArrays(this.bytesNoCopy(), ((JavaObjectIndexKey)o).bytesNoCopy()));
        }
        return h1 > h2 ? 1 : -1;
    }

    static boolean haveCommonComparableSuperclass(Class<?> cls0, Class<?> cls1) {
        if (cls0 != cls1 && !cls0.isAssignableFrom(cls1) && !cls1.isAssignableFrom(cls0)) {
            Class<?> supCls1;
            Class<?> supCls0;
            do {
                supCls0 = cls0;
            } while (Comparable.class.isAssignableFrom(cls0 = cls0.getSuperclass()));
            do {
                supCls1 = cls1;
            } while (Comparable.class.isAssignableFrom(cls1 = cls1.getSuperclass()));
            return supCls0 == supCls1;
        }
        return true;
    }

    public abstract byte[] bytesNoCopy();

    public byte[] bytes() {
        byte[] bytes = this.bytesNoCopy();
        if (bytes == null) {
            return null;
        }
        int len = bytes.length;
        return len == 0 ? EMPTY_BYTES : Arrays.copyOf(bytes, len);
    }

    public String toString() {
        return this.key().toString();
    }
}

