/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.tostring;

import java.util.Arrays;
import org.apache.ignite.internal.util.GridStringBuilder;
import org.apache.ignite.internal.util.tostring.CircularStringBuilder;
import org.apache.ignite.internal.util.tostring.SBLengthLimit;

public class SBLimitedLength
extends GridStringBuilder {
    private static final long serialVersionUID = 0L;
    private SBLengthLimit lenLimit;
    private CircularStringBuilder tail;

    SBLimitedLength(int cap) {
        super(cap);
    }

    void initLimit(SBLengthLimit lenLimit) {
        this.lenLimit = lenLimit;
        if (this.tail != null) {
            this.tail.reset();
        }
    }

    public void reset() {
        super.setLength(0);
        this.lenLimit.reset();
        if (this.tail != null) {
            this.tail.reset();
        }
    }

    public CircularStringBuilder getTail() {
        return this.tail;
    }

    public void setTail(CircularStringBuilder tail) {
        this.tail = tail;
    }

    private GridStringBuilder onWrite(int lenBeforeWrite) {
        assert (this.lenLimit != null);
        this.lenLimit.onWrite(this, this.length() - lenBeforeWrite);
        return this;
    }

    @Override
    public GridStringBuilder a(Object obj) {
        if (this.lenLimit.overflowed(this)) {
            this.tail.append(obj);
            return this;
        }
        int curLen = this.length();
        super.a(obj);
        return this.onWrite(curLen);
    }

    @Override
    public GridStringBuilder a(String str) {
        if (this.lenLimit.overflowed(this)) {
            this.tail.append(str);
            return this;
        }
        int curLen = this.length();
        super.a(str);
        return this.onWrite(curLen);
    }

    @Override
    public GridStringBuilder a(StringBuffer sb) {
        if (this.lenLimit.overflowed(this)) {
            this.tail.append(sb);
            return this;
        }
        int curLen = this.length();
        super.a(sb);
        return this.onWrite(curLen);
    }

    @Override
    public GridStringBuilder a(CharSequence s) {
        if (this.lenLimit.overflowed(this)) {
            this.tail.append(s);
            return this;
        }
        int curLen = this.length();
        super.a(s);
        return this.onWrite(curLen);
    }

    @Override
    public GridStringBuilder a(CharSequence s, int start, int end) {
        if (this.lenLimit.overflowed(this)) {
            this.tail.append(s.subSequence(start, end));
            return this;
        }
        int curLen = this.length();
        super.a(s, start, end);
        return this.onWrite(curLen);
    }

    @Override
    public GridStringBuilder a(char[] str) {
        if (this.lenLimit.overflowed(this)) {
            this.tail.append(str);
            return this;
        }
        int curLen = this.length();
        super.a(str);
        return this.onWrite(curLen);
    }

    @Override
    public GridStringBuilder a(char[] str, int offset, int len) {
        if (this.lenLimit.overflowed(this)) {
            this.tail.append(Arrays.copyOfRange(str, offset, len));
            return this;
        }
        int curLen = this.length();
        super.a(str, offset, len);
        return this.onWrite(curLen);
    }

    @Override
    public GridStringBuilder a(boolean b) {
        if (this.lenLimit.overflowed(this)) {
            this.tail.append(b);
            return this;
        }
        int curLen = this.length();
        super.a(b);
        return this.onWrite(curLen);
    }

    @Override
    public GridStringBuilder a(char c) {
        if (this.lenLimit.overflowed(this)) {
            this.tail.append(Character.valueOf(c));
            return this;
        }
        int curLen = this.length();
        super.a(c);
        return this.onWrite(curLen);
    }

    @Override
    public GridStringBuilder a(int i) {
        if (this.lenLimit.overflowed(this)) {
            this.tail.append(i);
            return this;
        }
        int curLen = this.length();
        super.a(i);
        return this.onWrite(curLen);
    }

    @Override
    public GridStringBuilder a(long lng) {
        if (this.lenLimit.overflowed(this)) {
            this.tail.append(lng);
            return this;
        }
        int curLen = this.length();
        super.a(lng);
        return this.onWrite(curLen);
    }

    @Override
    public GridStringBuilder a(float f) {
        if (this.lenLimit.overflowed(this)) {
            this.tail.append(Float.valueOf(f));
            return this;
        }
        int curLen = this.length();
        super.a(f);
        return this.onWrite(curLen);
    }

    @Override
    public GridStringBuilder a(double d) {
        if (this.lenLimit.overflowed(this)) {
            this.tail.append(d);
            return this;
        }
        int curLen = this.length();
        super.a(d);
        return this.onWrite(curLen);
    }

    @Override
    public GridStringBuilder appendCodePoint(int codePoint) {
        if (this.lenLimit.overflowed(this)) {
            this.tail.append(codePoint);
            return this;
        }
        int curLen = this.length();
        super.appendCodePoint(codePoint);
        return this.onWrite(curLen);
    }

    @Override
    public String toString() {
        if (this.tail == null) {
            return super.toString();
        }
        int tailLen = this.tail.length();
        StringBuilder res = new StringBuilder(this.impl().length() + tailLen + 100);
        res.append((CharSequence)this.impl());
        if (this.tail.getSkipped() > 0) {
            res.append("... and ").append(String.valueOf(this.tail.getSkipped() + tailLen)).append(" skipped ...");
        }
        res.append(this.tail.toString());
        return res.toString();
    }

    public boolean isOverflowed() {
        return this.lenLimit.overflowed(this);
    }
}

