/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.rsc.driver;

import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.hive.HiveContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkEntries {
    private static final Logger LOG = LoggerFactory.getLogger(SparkEntries.class);
    private volatile JavaSparkContext sc;
    private final SparkConf conf;
    private volatile SQLContext sqlctx;
    private volatile HiveContext hivectx;
    private volatile SparkSession sparksession;

    public SparkEntries(SparkConf conf) {
        this.conf = conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaSparkContext sc() {
        if (this.sc == null) {
            SparkEntries sparkEntries = this;
            synchronized (sparkEntries) {
                if (this.sc == null) {
                    long t1 = System.nanoTime();
                    LOG.info("Starting Spark context...");
                    SparkContext scalaSc = SparkContext.getOrCreate((SparkConf)this.conf);
                    this.sc = new JavaSparkContext(scalaSc);
                    LOG.info("Spark context finished initialization in {}ms", (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t1));
                }
            }
        }
        return this.sc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SparkSession sparkSession() {
        if (this.sparksession == null) {
            SparkEntries sparkEntries = this;
            synchronized (sparkEntries) {
                if (this.sparksession == null) {
                    SparkSession.Builder builder = SparkSession.builder().sparkContext(this.sc().sc());
                    try {
                        SparkConf conf = this.sc().getConf();
                        String catalog = conf.get("spark.sql.catalogImplementation", "in-memory").toLowerCase();
                        if (catalog.equals("hive") && SparkSession$.MODULE$.hiveClassesArePresent()) {
                            ClassLoader loader;
                            ClassLoader classLoader = loader = Thread.currentThread().getContextClassLoader() != null ? Thread.currentThread().getContextClassLoader() : this.getClass().getClassLoader();
                            if (loader.getResource("hive-site.xml") == null) {
                                LOG.warn("livy.repl.enable-hive-context is true but no hive-site.xml found on classpath");
                            }
                            builder.enableHiveSupport();
                            this.sparksession = builder.getOrCreate();
                            LOG.info("Created Spark session (with Hive support).");
                        } else {
                            builder.config("spark.sql.catalogImplementation", "in-memory");
                            this.sparksession = builder.getOrCreate();
                            LOG.info("Created Spark session.");
                        }
                    }
                    catch (Exception e) {
                        LOG.warn("SparkSession is not supported", (Throwable)e);
                        throw e;
                    }
                }
            }
        }
        return this.sparksession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLContext sqlctx() {
        if (this.sqlctx == null) {
            SparkEntries sparkEntries = this;
            synchronized (sparkEntries) {
                if (this.sqlctx == null) {
                    this.sqlctx = this.sparkSession().sqlContext();
                    LOG.info("Created SQLContext.");
                }
            }
        }
        return this.sqlctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HiveContext hivectx() {
        if (this.hivectx == null) {
            SparkEntries sparkEntries = this;
            synchronized (sparkEntries) {
                SparkConf conf;
                if (this.hivectx == null && ((conf = this.sc().getConf()).getBoolean("spark.repl.enableHiveContext", false) || conf.get("spark.sql.catalogImplementation", "in-memory").toLowerCase().equals("hive"))) {
                    ClassLoader loader;
                    ClassLoader classLoader = loader = Thread.currentThread().getContextClassLoader() != null ? Thread.currentThread().getContextClassLoader() : this.getClass().getClassLoader();
                    if (loader.getResource("hive-site.xml") == null) {
                        LOG.warn("livy.repl.enable-hive-context is true but no hive-site.xml found on classpath.");
                    }
                    this.hivectx = new HiveContext(this.sc().sc());
                    LOG.info("Created HiveContext.");
                }
            }
        }
        return this.hivectx;
    }

    public synchronized void stop() {
        if (this.sc != null) {
            this.sc.stop();
        }
    }
}

