/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.filescan.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PatternTreeMap;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.storageengine.dataregion.modification.Deletion;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.read.control.FileReaderManager;
import org.apache.iotdb.db.storageengine.dataregion.read.filescan.IChunkHandle;
import org.apache.iotdb.db.storageengine.dataregion.read.filescan.IFileScanHandle;
import org.apache.iotdb.db.storageengine.dataregion.read.filescan.model.AbstractChunkOffset;
import org.apache.iotdb.db.storageengine.dataregion.read.filescan.model.AbstractDeviceChunkMetaData;
import org.apache.iotdb.db.storageengine.dataregion.read.filescan.model.AlignedDeviceChunkMetaData;
import org.apache.iotdb.db.storageengine.dataregion.read.filescan.model.DeviceChunkMetaData;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileID;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.DeviceTimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.ITimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.utils.TsFileDeviceStartEndTimeIterator;
import org.apache.iotdb.db.utils.ModificationUtils;
import org.apache.iotdb.db.utils.datastructure.PatternTreeMapFactory;
import org.apache.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.TsFileDeviceIterator;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.utils.Pair;

public class ClosedFileScanHandleImpl
implements IFileScanHandle {
    private final TsFileResource tsFileResource;
    private final QueryContext queryContext;
    private PatternTreeMap<Modification, PatternTreeMapFactory.ModsSerializer> curFileMods = null;
    private final Map<IDeviceID, Map<String, List<TimeRange>>> deviceToModifications;

    public ClosedFileScanHandleImpl(TsFileResource tsFileResource, QueryContext context) {
        this.tsFileResource = tsFileResource;
        this.queryContext = context;
        this.deviceToModifications = new HashMap<IDeviceID, Map<String, List<TimeRange>>>();
    }

    @Override
    public TsFileDeviceStartEndTimeIterator getDeviceStartEndTimeIterator() throws IOException {
        ITimeIndex timeIndex = this.tsFileResource.getTimeIndex();
        return timeIndex instanceof DeviceTimeIndex ? new TsFileDeviceStartEndTimeIterator((DeviceTimeIndex)timeIndex) : new TsFileDeviceStartEndTimeIterator(this.tsFileResource.buildDeviceTimeIndex());
    }

    @Override
    public boolean isDeviceTimeDeleted(IDeviceID deviceID, long timestamp) throws IllegalPathException {
        this.curFileMods = this.curFileMods != null ? this.curFileMods : this.queryContext.loadAllModificationsFromDisk(this.tsFileResource);
        List<Modification> modifications = this.queryContext.getPathModifications(this.curFileMods, deviceID);
        List<TimeRange> timeRangeList = modifications.stream().filter(Deletion.class::isInstance).map(Deletion.class::cast).map(Deletion::getTimeRange).collect(Collectors.toList());
        return ModificationUtils.isPointDeletedWithoutOrderedRange(timestamp, timeRangeList);
    }

    @Override
    public boolean isTimeSeriesTimeDeleted(IDeviceID deviceID, String timeSeriesName, long timestamp) throws IllegalPathException {
        Map<String, List<TimeRange>> modificationTimeRange = this.deviceToModifications.get(deviceID);
        if (modificationTimeRange != null && modificationTimeRange.containsKey(timeSeriesName)) {
            return ModificationUtils.isPointDeleted(timestamp, modificationTimeRange.get(timeSeriesName));
        }
        this.curFileMods = this.curFileMods != null ? this.curFileMods : this.queryContext.loadAllModificationsFromDisk(this.tsFileResource);
        List<Modification> modifications = this.queryContext.getPathModifications(this.curFileMods, new PartialPath(deviceID, timeSeriesName));
        List<TimeRange> timeRangeList = modifications.stream().filter(Deletion.class::isInstance).map(Deletion.class::cast).map(Deletion::getTimeRange).collect(Collectors.toList());
        TimeRange.sortAndMerge(timeRangeList);
        this.deviceToModifications.computeIfAbsent(deviceID, k -> new HashMap()).put(timeSeriesName, timeRangeList);
        return ModificationUtils.isPointDeleted(timestamp, timeRangeList);
    }

    @Override
    public Iterator<AbstractDeviceChunkMetaData> getAllDeviceChunkMetaData() throws IOException {
        TsFileSequenceReader tsFileReader = FileReaderManager.getInstance().get(this.getFilePath(), this.tsFileResource.getTsFileID(), true);
        TsFileDeviceIterator deviceIterator = tsFileReader.getAllDevicesIteratorWithIsAligned();
        LinkedList<AbstractDeviceChunkMetaData> deviceChunkMetaDataList = new LinkedList<AbstractDeviceChunkMetaData>();
        while (deviceIterator.hasNext()) {
            Pair deviceIDWithIsAligned = deviceIterator.next();
            Map metadataForDevice = tsFileReader.getTimeseriesMetadataOffsetByDevice(deviceIterator.getFirstMeasurementNodeOfCurrentDevice(), Collections.emptySet(), true);
            if (!((Boolean)deviceIDWithIsAligned.right).booleanValue()) {
                deviceChunkMetaDataList.add(new DeviceChunkMetaData((IDeviceID)deviceIDWithIsAligned.left, metadataForDevice.values().stream().flatMap(pair -> ((List)pair.getLeft()).stream()).collect(Collectors.toList())));
                continue;
            }
            List timeChunkMetaDataList = (List)((Pair)metadataForDevice.get("")).getLeft();
            ArrayList<List> valueMetaDataList = new ArrayList<List>();
            for (Map.Entry pair2 : metadataForDevice.entrySet()) {
                if (((String)pair2.getKey()).isEmpty()) continue;
                valueMetaDataList.add((List)((Pair)pair2.getValue()).getLeft());
            }
            ArrayList<AlignedChunkMetadata> alignedDeviceChunkMetaData = new ArrayList<AlignedChunkMetadata>();
            for (IChunkMetadata timeChunkMetaData : timeChunkMetaDataList) {
                for (List chunkMetadataList : valueMetaDataList) {
                    alignedDeviceChunkMetaData.add(new AlignedChunkMetadata(timeChunkMetaData, chunkMetadataList));
                }
            }
            deviceChunkMetaDataList.add(new AlignedDeviceChunkMetaData((IDeviceID)deviceIDWithIsAligned.left, alignedDeviceChunkMetaData));
        }
        return deviceChunkMetaDataList.iterator();
    }

    @Override
    public Iterator<IChunkHandle> getChunkHandles(List<AbstractChunkOffset> chunkInfoList, List<Statistics<? extends Serializable>> statisticsList, List<Integer> orderedIndexList) {
        String filePath = this.tsFileResource.getTsFilePath();
        TsFileID tsFileID = this.tsFileResource.getTsFileID();
        ArrayList<IChunkHandle> chunkHandleList = new ArrayList<IChunkHandle>();
        for (int i : orderedIndexList) {
            AbstractChunkOffset chunkOffset = chunkInfoList.get(i);
            chunkHandleList.add(chunkOffset.generateChunkHandle(filePath, tsFileID, statisticsList.get(i)));
        }
        return chunkHandleList.iterator();
    }

    @Override
    public boolean isClosed() {
        return true;
    }

    @Override
    public boolean isDeleted() {
        return this.tsFileResource.isDeleted();
    }

    public String getFilePath() {
        return this.tsFileResource.getTsFilePath();
    }

    @Override
    public TsFileResource getTsResource() {
        return this.tsFileResource;
    }
}

