/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker;

import io.moquette.broker.SessionRegistry;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttVersion;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static final Logger BUFF_LOGGER = LoggerFactory.getLogger((String)"BufferManagement");

    public static void release(Object obj, String tag) {
        if (obj instanceof SessionRegistry.PublishedMessage) {
            SessionRegistry.PublishedMessage msg = (SessionRegistry.PublishedMessage)obj;
            msg.release();
            if (BUFF_LOGGER.isTraceEnabled()) {
                if (tag == null) {
                    BUFF_LOGGER.trace("release object");
                } else {
                    BUFF_LOGGER.trace("release object, tag: {}", (Object)tag);
                }
            }
        } else if (obj instanceof ReferenceCounted) {
            ReferenceCountUtil.release((Object)obj);
            if (BUFF_LOGGER.isTraceEnabled()) {
                if (tag == null) {
                    BUFF_LOGGER.trace("release object");
                } else {
                    BUFF_LOGGER.trace("release object, tag: {}", (Object)tag);
                }
            }
        }
    }

    public static ByteBufHolder retainDuplicate(ByteBufHolder obj, String tag) {
        ByteBufHolder duplicate = obj.retainedDuplicate();
        if (BUFF_LOGGER.isTraceEnabled()) {
            if (tag == null) {
                BUFF_LOGGER.trace("retain duplicate");
            } else {
                BUFF_LOGGER.trace("retain duplicate tag: {}", (Object)tag);
            }
        }
        return duplicate;
    }

    public static void retain(Object obj, int increment, String tag) {
        if (obj instanceof SessionRegistry.PublishedMessage) {
            SessionRegistry.PublishedMessage msg = (SessionRegistry.PublishedMessage)obj;
            msg.retain();
            if (BUFF_LOGGER.isTraceEnabled()) {
                if (tag == null) {
                    BUFF_LOGGER.trace("retain object incr {}", (Object)increment);
                } else {
                    BUFF_LOGGER.trace("retain object incr {}, tag: {}", (Object)increment, (Object)tag);
                }
            }
        } else if (obj instanceof ReferenceCounted) {
            ReferenceCountUtil.retain((Object)obj, (int)increment);
            if (BUFF_LOGGER.isTraceEnabled()) {
                if (tag == null) {
                    BUFF_LOGGER.trace("retain object incr {}", (Object)increment);
                } else {
                    BUFF_LOGGER.trace("retain object incr {}, tag: {}", (Object)increment, (Object)tag);
                }
            }
        }
    }

    public static void retain(Object obj, String tag) {
        if (obj instanceof SessionRegistry.PublishedMessage) {
            SessionRegistry.PublishedMessage msg = (SessionRegistry.PublishedMessage)obj;
            msg.retain();
            if (BUFF_LOGGER.isTraceEnabled()) {
                if (tag == null) {
                    BUFF_LOGGER.trace("retain object");
                } else {
                    BUFF_LOGGER.trace("retain object, tag: {}", (Object)tag);
                }
            }
        } else if (obj instanceof ReferenceCounted) {
            ReferenceCountUtil.retain((Object)obj);
            if (BUFF_LOGGER.isTraceEnabled()) {
                if (tag == null) {
                    BUFF_LOGGER.trace("retain object");
                } else {
                    BUFF_LOGGER.trace("retain object, tag: {}", (Object)tag);
                }
            }
        }
    }

    public static <T, K> T defaultGet(Map<K, T> map, K key, T defaultValue) {
        T value = map.get(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static int messageId(MqttMessage msg) {
        return ((MqttMessageIdVariableHeader)msg.variableHeader()).messageId();
    }

    public static byte[] readBytesAndRewind(ByteBuf payload) {
        byte[] payloadContent = new byte[payload.readableBytes()];
        payload.getBytes(payload.readerIndex(), payloadContent, 0, payload.readableBytes());
        return payloadContent;
    }

    public static MqttVersion versionFromConnect(MqttConnectMessage msg) {
        return MqttVersion.fromProtocolNameAndLevel((String)msg.variableHeader().name(), (byte)((byte)msg.variableHeader().version()));
    }

    private Utils() {
    }

    public static final class Couple<K, L> {
        public final K v1;
        public final L v2;

        public Couple(K v1, L v2) {
            this.v1 = v1;
            this.v2 = v2;
        }

        public static <K, L> Couple<K, L> of(K v1, L v2) {
            return new Couple<K, L>(v1, v2);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Couple couple = (Couple)o;
            return Objects.equals(this.v1, couple.v1) && Objects.equals(this.v2, couple.v2);
        }

        public int hashCode() {
            return Objects.hash(this.v1, this.v2);
        }
    }
}

