/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.util.ArrayList;
import org.apache.tsfile.utils.BitMap;

public class LazyBitMap {
    private final int startPosition;
    private final int endPosition;
    private final int blockSize;
    private final ArrayList<BitMap> blocks;

    public LazyBitMap(int startIndex, int appendSize, int endIndex) {
        if (endIndex < startIndex) {
            throw new IllegalArgumentException("endIndex must be >= startIndex");
        }
        if (appendSize <= 0) {
            throw new IllegalArgumentException("appendSize must be positive");
        }
        this.startPosition = startIndex;
        this.endPosition = endIndex;
        this.blockSize = appendSize;
        this.blocks = new ArrayList(2);
    }

    public void mark(int index) {
        if (index < this.startPosition) {
            throw new IndexOutOfBoundsException("Index below startPosition: " + index);
        }
        if (index > this.endPosition) {
            throw new IndexOutOfBoundsException("Index exceeds endPosition: " + index);
        }
        int blockIndex = this.getBlockIndex(index);
        this.ensureCapacity(blockIndex);
        BitMap block = this.blocks.get(blockIndex);
        if (block == null) {
            block = new BitMap(this.blockSize);
            this.blocks.set(blockIndex, block);
        }
        block.mark(this.getInnerIndex(index));
    }

    private void ensureCapacity(int blockIndex) {
        while (blockIndex >= this.blocks.size()) {
            this.blocks.add(null);
        }
    }

    public boolean isMarked(int index) {
        if (index < this.startPosition) {
            return false;
        }
        if (index > this.endPosition) {
            throw new IndexOutOfBoundsException("Index exceeds endPosition: " + index);
        }
        int blockIndex = this.getBlockIndex(index);
        if (blockIndex >= this.blocks.size()) {
            return false;
        }
        BitMap block = this.blocks.get(blockIndex);
        if (block == null) {
            return false;
        }
        return block.isMarked(this.getInnerIndex(index));
    }

    private int getBlockIndex(int index) {
        return (index - this.startPosition) / this.blockSize;
    }

    private int getInnerIndex(int index) {
        return (index - this.startPosition) % this.blockSize;
    }
}

