/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.taglib;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.logging.log4j.taglib.Log4jTaglibLogger;
import org.apache.logging.log4j.taglib.Log4jTaglibLoggerContext;
import org.apache.logging.log4j.taglib.TagUtils;

abstract class LoggerAwareTagSupport
extends BodyTagSupport {
    private static final long serialVersionUID = 1L;
    private transient Log4jTaglibLoggerContext loggerContext;
    private transient Object logger;

    protected LoggerAwareTagSupport() {
        this.init();
    }

    protected void init() {
        this.logger = null;
    }

    public final void release() {
        super.release();
        this.init();
    }

    public final void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.loggerContext = Log4jTaglibLoggerContext.getInstance(pageContext.getServletContext());
    }

    protected final Log4jTaglibLogger getLogger() throws JspException {
        if (this.logger != null) {
            return TagUtils.resolveLogger(this.loggerContext, this.logger, null);
        }
        Log4jTaglibLogger logger = TagUtils.getDefaultLogger(this.pageContext);
        if (logger == null) {
            String name = this.pageContext.getPage().getClass().getName();
            logger = TagUtils.resolveLogger(this.loggerContext, name, null);
            TagUtils.setDefaultLogger(this.pageContext, logger);
        }
        return logger;
    }

    public final void setLogger(Object logger) {
        this.logger = logger;
    }
}

