/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleNotFoundException;
import org.apache.maven.lifecycle.LifecyclePhaseNotFoundException;
import org.apache.maven.lifecycle.internal.GoalTask;
import org.apache.maven.lifecycle.internal.LifecyclePluginResolver;
import org.apache.maven.lifecycle.internal.LifecycleTask;
import org.apache.maven.lifecycle.internal.LifecycleTaskSegmentCalculator;
import org.apache.maven.lifecycle.internal.MojoDescriptorCreator;
import org.apache.maven.lifecycle.internal.PhaseId;
import org.apache.maven.lifecycle.internal.TaskSegment;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MojoNotFoundException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.prefix.NoPluginFoundForPrefixException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class DefaultLifecycleTaskSegmentCalculator
implements LifecycleTaskSegmentCalculator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultLifecycleTaskSegmentCalculator.class);
    private final MojoDescriptorCreator mojoDescriptorCreator;
    private final LifecyclePluginResolver lifecyclePluginResolver;

    @Inject
    public DefaultLifecycleTaskSegmentCalculator(MojoDescriptorCreator mojoDescriptorCreator, LifecyclePluginResolver lifecyclePluginResolver) {
        this.mojoDescriptorCreator = mojoDescriptorCreator;
        this.lifecyclePluginResolver = lifecyclePluginResolver;
    }

    @Override
    public List<TaskSegment> calculateTaskSegments(MavenSession session) throws PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, MojoNotFoundException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, PluginVersionResolutionException, LifecyclePhaseNotFoundException, LifecycleNotFoundException {
        MavenProject rootProject = session.getTopLevelProject();
        List<String> tasks = Objects.requireNonNull(session.getGoals());
        if (tasks.isEmpty() && rootProject.getDefaultGoal() != null && !rootProject.getDefaultGoal().isEmpty()) {
            tasks = Stream.of(rootProject.getDefaultGoal().split("\\s+")).filter(g -> !g.isEmpty()).collect(Collectors.toList());
        }
        return this.calculateTaskSegments(session, tasks);
    }

    @Override
    public List<TaskSegment> calculateTaskSegments(MavenSession session, List<String> tasks) throws PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, MojoNotFoundException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, PluginVersionResolutionException {
        ArrayList<TaskSegment> taskSegments = new ArrayList<TaskSegment>(tasks.size());
        TaskSegment currentSegment = null;
        for (String task : tasks) {
            if (this.isBeforeOrAfterPhase(task)) {
                String prevTask = task;
                task = PhaseId.of(task).phase();
                LOGGER.warn("Illegal call to phase '{}'. The main phase '{}' will be used instead.", (Object)prevTask, (Object)task);
            }
            if (this.isGoalSpecification(task)) {
                boolean aggregating;
                this.lifecyclePluginResolver.resolveMissingPluginVersions(session.getTopLevelProject(), session);
                MojoDescriptor mojoDescriptor = this.mojoDescriptorCreator.getMojoDescriptor(task, session, session.getTopLevelProject());
                boolean bl = aggregating = mojoDescriptor.isAggregator() || !mojoDescriptor.isProjectRequired();
                if (currentSegment == null || currentSegment.isAggregating() != aggregating) {
                    currentSegment = new TaskSegment(aggregating);
                    taskSegments.add(currentSegment);
                }
                currentSegment.getTasks().add(new GoalTask(task));
                continue;
            }
            if (currentSegment == null || currentSegment.isAggregating()) {
                currentSegment = new TaskSegment(false);
                taskSegments.add(currentSegment);
            }
            currentSegment.getTasks().add(new LifecycleTask(task));
        }
        return taskSegments;
    }

    @Override
    public boolean requiresProject(MavenSession session) {
        List<String> goals = session.getGoals();
        if (goals != null) {
            for (String goal : goals) {
                if (this.isGoalSpecification(goal)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isBeforeOrAfterPhase(String task) {
        return task.startsWith("before:") || task.startsWith("after:");
    }

    private boolean isGoalSpecification(String task) {
        return task.indexOf(58) >= 0;
    }
}

