/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto.util;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.nifi.web.api.dto.util.ParseDefaultingDateTimeFormatter;

public class TimeAdapter
extends XmlAdapter<String, Date> {
    public static final String DEFAULT_TIME_FORMAT = "HH:mm:ss z";
    private static final ZoneId ZONE_ID = TimeZone.getDefault().toZoneId();
    private final ParseDefaultingDateTimeFormatter formatter = new ParseDefaultingDateTimeFormatter(timestamp -> String.format("%s%s%s", timestamp.getYear(), timestamp.getMonthValue(), timestamp.getDayOfMonth()), timestamp -> new DateTimeFormatterBuilder().appendPattern(DEFAULT_TIME_FORMAT).parseDefaulting(ChronoField.YEAR, timestamp.getYear()).parseDefaulting(ChronoField.MONTH_OF_YEAR, timestamp.getMonthValue()).parseDefaulting(ChronoField.DAY_OF_MONTH, timestamp.getDayOfMonth()).parseDefaulting(ChronoField.MILLI_OF_SECOND, 0L).toFormatter(Locale.US));

    public String marshal(Date date) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(DEFAULT_TIME_FORMAT, Locale.US);
        ZonedDateTime localDateTime = ZonedDateTime.ofInstant(date.toInstant(), ZONE_ID);
        return formatter.format(localDateTime);
    }

    public Date unmarshal(String date) {
        DateTimeFormatter parser = this.formatter.get();
        LocalDateTime parsedDateTime = LocalDateTime.parse(date, parser);
        LocalDateTime now = LocalDateTime.now();
        return Date.from(parsedDateTime.toInstant(ZONE_ID.getRules().getOffset(now)));
    }
}

