/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentdetect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import opennlp.tools.sentdetect.SDContextGenerator;
import opennlp.tools.util.StringUtil;

public class DefaultSDContextGenerator
implements SDContextGenerator {
    protected final StringBuffer buf;
    protected final List<String> collectFeats;
    private final Set<String> inducedAbbreviations;
    private final Set<Character> eosCharacters;

    public DefaultSDContextGenerator(char[] eosCharacters) {
        this(Collections.emptySet(), eosCharacters);
    }

    public DefaultSDContextGenerator(Set<String> inducedAbbreviations, char[] eosCharacters) {
        this.inducedAbbreviations = inducedAbbreviations;
        this.eosCharacters = new HashSet<Character>();
        for (char eosChar : eosCharacters) {
            this.eosCharacters.add(Character.valueOf(eosChar));
        }
        this.buf = new StringBuffer();
        this.collectFeats = new ArrayList<String>();
    }

    private static String escapeChar(Character c) {
        if (c.charValue() == '\n') {
            return "<LF>";
        }
        if (c.charValue() == '\r') {
            return "<CR>";
        }
        return String.valueOf(c);
    }

    public String[] getContext(CharSequence sb, int position) {
        String next;
        String suffix;
        int lastIndex = sb.length() - 1;
        if (position > 0 && StringUtil.isWhitespace((char)sb.charAt(position - 1))) {
            this.collectFeats.add("sp");
        }
        if (position < lastIndex && StringUtil.isWhitespace((char)sb.charAt(position + 1))) {
            this.collectFeats.add("sn");
        }
        this.collectFeats.add("eos=" + DefaultSDContextGenerator.escapeChar(Character.valueOf(sb.charAt(position))));
        int prefixStart = DefaultSDContextGenerator.previousSpaceIndex(sb, position);
        int c = position;
        while (--c > prefixStart) {
            if (!this.eosCharacters.contains(Character.valueOf(sb.charAt(c)))) continue;
            prefixStart = c++;
        }
        String prefix = String.valueOf(sb.subSequence(prefixStart, position)).trim();
        int prevStart = DefaultSDContextGenerator.previousSpaceIndex(sb, prefixStart);
        String previous = String.valueOf(sb.subSequence(prevStart, prefixStart)).trim();
        int suffixEnd = DefaultSDContextGenerator.nextSpaceIndex(sb, position, lastIndex);
        c = position;
        while (++c < suffixEnd) {
            if (!this.eosCharacters.contains(Character.valueOf(sb.charAt(c)))) continue;
            suffixEnd = c--;
        }
        int nextEnd = DefaultSDContextGenerator.nextSpaceIndex(sb, suffixEnd + 1, lastIndex + 1);
        if (position == lastIndex) {
            suffix = "";
            next = "";
        } else {
            suffix = String.valueOf(sb.subSequence(position + 1, suffixEnd)).trim();
            next = String.valueOf(sb.subSequence(suffixEnd + 1, nextEnd)).trim();
        }
        this.collectFeatures(prefix, suffix, previous, next, Character.valueOf(sb.charAt(position)));
        String[] context = new String[this.collectFeats.size()];
        context = this.collectFeats.toArray(context);
        this.collectFeats.clear();
        return context;
    }

    protected void collectFeatures(String prefix, String suffix, String previous, String next, Character eosChar) {
        this.buf.append("x=");
        this.buf.append(prefix);
        this.collectFeats.add(this.buf.toString());
        this.buf.setLength(0);
        if (!prefix.isEmpty()) {
            this.collectFeats.add(Integer.toString(prefix.length()));
            if (DefaultSDContextGenerator.isFirstUpper(prefix)) {
                this.collectFeats.add("xcap");
            }
            if (eosChar != null && this.inducedAbbreviations.contains(prefix + eosChar)) {
                this.collectFeats.add("xabbrev");
            }
        }
        this.buf.append("v=");
        this.buf.append(previous);
        this.collectFeats.add(this.buf.toString());
        this.buf.setLength(0);
        if (!previous.isEmpty()) {
            if (DefaultSDContextGenerator.isFirstUpper(previous)) {
                this.collectFeats.add("vcap");
            }
            if (this.inducedAbbreviations.contains(previous)) {
                this.collectFeats.add("vabbrev");
            }
        }
        this.buf.append("s=");
        this.buf.append(suffix);
        this.collectFeats.add(this.buf.toString());
        this.buf.setLength(0);
        if (!suffix.isEmpty()) {
            if (DefaultSDContextGenerator.isFirstUpper(suffix)) {
                this.collectFeats.add("scap");
            }
            if (this.inducedAbbreviations.contains(suffix)) {
                this.collectFeats.add("sabbrev");
            }
        }
        this.buf.append("n=");
        this.buf.append(next);
        this.collectFeats.add(this.buf.toString());
        this.buf.setLength(0);
        if (!next.isEmpty()) {
            if (DefaultSDContextGenerator.isFirstUpper(next)) {
                this.collectFeats.add("ncap");
            }
            if (this.inducedAbbreviations.contains(next)) {
                this.collectFeats.add("nabbrev");
            }
        }
    }

    private static boolean isFirstUpper(String s) {
        return Character.isUpperCase(s.charAt(0));
    }

    private static int previousSpaceIndex(CharSequence sb, int seek) {
        while (--seek > 0 && !StringUtil.isWhitespace((char)sb.charAt(seek))) {
        }
        if (seek > 0 && StringUtil.isWhitespace((char)sb.charAt(seek))) {
            while (seek > 0 && StringUtil.isWhitespace((char)sb.charAt(seek - 1))) {
                --seek;
            }
            return seek;
        }
        return 0;
    }

    private static int nextSpaceIndex(CharSequence sb, int seek, int lastIndex) {
        ++seek;
        while (seek < lastIndex) {
            char c = sb.charAt(seek);
            if (StringUtil.isWhitespace((char)c)) {
                while (sb.length() > seek + 1 && StringUtil.isWhitespace((char)sb.charAt(seek + 1))) {
                    ++seek;
                }
                return seek;
            }
            ++seek;
        }
        return lastIndex;
    }
}

