/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.model;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import opennlp.tools.commons.Internal;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.GenericModelWriter;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.util.Parameters;
import opennlp.tools.util.TrainingParameters;

public final class ModelUtil {
    private ModelUtil() {
    }

    public static void writeModel(MaxentModel model, final OutputStream out) throws IOException, IllegalArgumentException {
        Objects.requireNonNull(model, "model parameter must not be null");
        Objects.requireNonNull(out, "out parameter must not be null");
        GenericModelWriter modelWriter = new GenericModelWriter((AbstractModel)model, new DataOutputStream(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                out.write(b);
            }
        }));
        modelWriter.persist();
    }

    public static boolean validateOutcomes(MaxentModel model, String ... expectedOutcomes) {
        boolean result = true;
        if (expectedOutcomes.length == model.getNumOutcomes()) {
            HashSet<String> expectedOutcomesSet = new HashSet<String>(Arrays.asList(expectedOutcomes));
            for (int i = 0; i < model.getNumOutcomes(); ++i) {
                if (expectedOutcomesSet.contains(model.getOutcome(i))) continue;
                result = false;
                break;
            }
        } else {
            result = false;
        }
        return result;
    }

    public static byte[] read(InputStream in) throws IOException {
        int length;
        ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = in.read(buffer)) > 0) {
            byteArrayOut.write(buffer, 0, length);
        }
        byteArrayOut.close();
        return byteArrayOut.toByteArray();
    }

    public static void addCutoffAndIterations(Map<String, String> manifestInfoEntries, int cutoff, int iterations) {
        manifestInfoEntries.put("Training-Cutoff", Integer.toString(cutoff));
        manifestInfoEntries.put("Training-Iterations", Integer.toString(iterations));
    }

    @Internal
    public static TrainingParameters createDefaultTrainingParameters() {
        TrainingParameters mlParams = new TrainingParameters();
        mlParams.put("Algorithm", Parameters.ALGORITHM_DEFAULT_VALUE);
        mlParams.put("Iterations", 100);
        mlParams.put("Cutoff", 5);
        return mlParams;
    }
}

