/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.File;
import java.io.FileNotFoundException;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.commons.Internal;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.MarkableFileInputStreamFactory;

@Internal
public class FormatUtil {
    public static InputStreamFactory createInputStreamFactory(File file) {
        try {
            return new MarkableFileInputStreamFactory(file);
        }
        catch (FileNotFoundException e) {
            throw new TerminateToolException(-1, "File '" + String.valueOf(file) + "' cannot be found", (Throwable)e);
        }
    }

    public static void checkInputFile(String name, File inFile) {
        String isFailure = null;
        if (inFile.isDirectory()) {
            isFailure = "The " + name + " file is a directory!";
        } else if (!inFile.exists()) {
            isFailure = "The " + name + " file does not exist!";
        } else if (!inFile.canRead()) {
            isFailure = "No permissions to read the " + name + " file!";
        }
        if (null != isFailure) {
            throw new TerminateToolException(-1, isFailure + " Path: " + inFile.getAbsolutePath());
        }
    }
}

