/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.chunker;

import java.io.IOException;
import java.util.LinkedList;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.chunker.Chunker;
import opennlp.tools.chunker.ChunkerEvaluationMonitor;
import opennlp.tools.chunker.ChunkerEvaluator;
import opennlp.tools.chunker.ChunkerME;
import opennlp.tools.chunker.ChunkerModel;
import opennlp.tools.cmdline.AbstractEvaluatorTool;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.chunker.ChunkEvaluationErrorListener;
import opennlp.tools.cmdline.chunker.ChunkerModelLoader;
import opennlp.tools.cmdline.params.EvaluatorParams;
import opennlp.tools.util.ObjectStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChunkerEvaluatorTool
extends AbstractEvaluatorTool<ChunkSample, EvalToolParams> {
    private static final Logger logger = LoggerFactory.getLogger(ChunkerEvaluatorTool.class);

    public ChunkerEvaluatorTool() {
        super(ChunkSample.class, EvalToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "Measures the performance of the Chunker model with the reference data";
    }

    @Override
    public void run(String format, String[] args) {
        super.run(format, args);
        ChunkerModel model = (ChunkerModel)new ChunkerModelLoader().load(((EvalToolParams)this.params).getModel());
        LinkedList<ChunkEvaluationErrorListener> listeners = new LinkedList<ChunkEvaluationErrorListener>();
        if (((EvalToolParams)this.params).getMisclassified().booleanValue()) {
            listeners.add(new ChunkEvaluationErrorListener());
        }
        ChunkerEvaluator evaluator = new ChunkerEvaluator((Chunker)new ChunkerME(model), listeners.toArray(new ChunkerEvaluationMonitor[0]));
        final PerformanceMonitor monitor = new PerformanceMonitor("sent");
        try (ObjectStream<ChunkSample> measuredSampleStream = new ObjectStream<ChunkSample>(){

            public ChunkSample read() throws IOException {
                monitor.incrementCounter();
                return (ChunkSample)ChunkerEvaluatorTool.this.sampleStream.read();
            }

            public void reset() throws IOException {
                ChunkerEvaluatorTool.this.sampleStream.reset();
            }

            public void close() throws IOException {
                ChunkerEvaluatorTool.this.sampleStream.close();
            }
        };){
            monitor.startAndPrintThroughput();
            evaluator.evaluate((ObjectStream)measuredSampleStream);
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while reading test data: " + e.getMessage(), (Throwable)e);
        }
        monitor.stopAndPrintFinalResult();
        logger.info(evaluator.getFMeasure().toString());
    }

    static interface EvalToolParams
    extends EvaluatorParams {
    }
}

