/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.persistence.relational.jdbc.models;

import jakarta.annotation.Nullable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.polaris.core.entity.PolarisEvent;
import org.apache.polaris.immutables.PolarisImmutable;
import org.apache.polaris.persistence.relational.jdbc.DatabaseType;
import org.apache.polaris.persistence.relational.jdbc.models.Converter;
import org.apache.polaris.persistence.relational.jdbc.models.ImmutableModelEvent;

@PolarisImmutable
public interface ModelEvent
extends Converter<PolarisEvent> {
    public static final String TABLE_NAME = "EVENTS";
    public static final String CATALOG_ID = "catalog_id";
    public static final String EVENT_ID = "event_id";
    public static final String REQUEST_ID = "request_id";
    public static final String EVENT_TYPE = "event_type";
    public static final String TIMESTAMP_MS = "timestamp_ms";
    public static final String PRINCIPAL_NAME = "principal_name";
    public static final String RESOURCE_TYPE = "resource_type";
    public static final String RESOURCE_IDENTIFIER = "resource_identifier";
    public static final String ADDITIONAL_PROPERTIES = "additional_properties";
    public static final List<String> ALL_COLUMNS = List.of("catalog_id", "event_id", "request_id", "event_type", "timestamp_ms", "principal_name", "resource_type", "resource_identifier", "additional_properties");
    public static final ModelEvent CONVERTER = ImmutableModelEvent.builder().catalogId("").eventId("").requestId("").eventType("").timestampMs(0L).principalName("").resourceType(PolarisEvent.ResourceType.CATALOG).resourceIdentifier("").additionalProperties("").build();

    public String getCatalogId();

    public String getEventId();

    @Nullable
    public String getRequestId();

    public String getEventType();

    public long getTimestampMs();

    @Nullable
    public String getPrincipalName();

    public PolarisEvent.ResourceType getResourceType();

    public String getResourceIdentifier();

    public String getAdditionalProperties();

    @Override
    default public PolarisEvent fromResultSet(ResultSet rs) throws SQLException {
        ImmutableModelEvent modelEvent = ImmutableModelEvent.builder().catalogId(rs.getString(CATALOG_ID)).eventId(rs.getString(EVENT_ID)).requestId(rs.getString(REQUEST_ID)).eventType(rs.getString(EVENT_TYPE)).timestampMs(rs.getLong(TIMESTAMP_MS)).principalName(rs.getString(PRINCIPAL_NAME)).resourceType(PolarisEvent.ResourceType.valueOf((String)rs.getString(RESOURCE_TYPE))).resourceIdentifier(rs.getString(RESOURCE_IDENTIFIER)).additionalProperties(rs.getString(ADDITIONAL_PROPERTIES)).build();
        return ModelEvent.toEvent(modelEvent);
    }

    @Override
    default public Map<String, Object> toMap(DatabaseType databaseType) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(CATALOG_ID, this.getCatalogId());
        map.put(EVENT_ID, this.getEventId());
        map.put(REQUEST_ID, this.getRequestId());
        map.put(EVENT_TYPE, this.getEventType());
        map.put(TIMESTAMP_MS, this.getTimestampMs());
        map.put(PRINCIPAL_NAME, this.getPrincipalName());
        map.put(RESOURCE_TYPE, this.getResourceType().toString());
        map.put(RESOURCE_IDENTIFIER, this.getResourceIdentifier());
        if (databaseType.equals((Object)DatabaseType.POSTGRES)) {
            map.put(ADDITIONAL_PROPERTIES, this.toJsonbPGobject(this.getAdditionalProperties()));
        } else {
            map.put(ADDITIONAL_PROPERTIES, this.getAdditionalProperties());
        }
        return map;
    }

    public static ModelEvent fromEvent(PolarisEvent event) {
        if (event == null) {
            return null;
        }
        return ImmutableModelEvent.builder().catalogId(event.getCatalogId()).eventId(event.getId()).requestId(event.getRequestId()).eventType(event.getEventType()).timestampMs(event.getTimestampMs()).principalName(event.getPrincipalName()).resourceType(event.getResourceType()).resourceIdentifier(event.getResourceIdentifier()).additionalProperties(event.getAdditionalProperties()).build();
    }

    public static PolarisEvent toEvent(ModelEvent model) {
        if (model == null) {
            return null;
        }
        PolarisEvent polarisEvent = new PolarisEvent(model.getCatalogId(), model.getEventId(), model.getRequestId(), model.getEventType(), model.getTimestampMs(), model.getPrincipalName(), model.getResourceType(), model.getResourceIdentifier());
        polarisEvent.setAdditionalProperties(model.getAdditionalProperties());
        return polarisEvent;
    }
}

